/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceColumnInSeries;
import com.sap.sailing.domain.base.Series;
import com.sap.sailing.domain.common.ScoringSchemeType;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.impl.LeaderboardTotalRankComparator;
import com.sap.sailing.domain.leaderboard.impl.LowPoint;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public abstract class LowPointWithEliminatingMedalSeriesWithPromotions
extends LowPoint {
    private static final long serialVersionUID = 7759999270911627798L;
    private final int[] numberOfPromotedCompetitorsIntoLastMedalRaces;

    public LowPointWithEliminatingMedalSeriesWithPromotions(int[] numberOfPromotedCompetitorsIntoLastMedalRaces) {
        if (numberOfPromotedCompetitorsIntoLastMedalRaces == null) {
            throw new NullPointerException("array specifying number of promoted competitors must not be null");
        }
        this.numberOfPromotedCompetitorsIntoLastMedalRaces = numberOfPromotedCompetitorsIntoLastMedalRaces;
    }

    @Override
    public ScoringSchemeType getType() {
        return super.getType();
    }

    public int getNumberOfCompetitorsBetterThanThoseSailingInSeries(Series medalSeries) {
        List allMedalSeries = Util.asList((Iterable)Util.filter(medalSeries.getRegatta().getSeries(), series -> series.isMedal()));
        int result = 0;
        int indexInNumberOfPromotedCompetitorsIntoLastMedalRaces = this.numberOfPromotedCompetitorsIntoLastMedalRaces.length - 1;
        if (allMedalSeries.size() > 1) {
            ListIterator i = allMedalSeries.listIterator(allMedalSeries.size());
            while (i.hasPrevious() && i.previous() != medalSeries) {
                result += this.numberOfPromotedCompetitorsIntoLastMedalRaces[indexInNumberOfPromotedCompetitorsIntoLastMedalRaces--];
            }
        }
        return result;
    }

    public int getNumberOfCompetitorsAdvancingFromOpeningSeriesToOrThroughSeries(Series medalSeries) {
        List allMedalSeries = Util.asList((Iterable)Util.filter(medalSeries.getRegatta().getSeries(), series -> series.isMedal()));
        int result = 0;
        if (this.numberOfPromotedCompetitorsIntoLastMedalRaces.length > 0) {
            int indexInNumberOfPromotedCompetitorsIntoLastMedalRaces = this.numberOfPromotedCompetitorsIntoLastMedalRaces.length;
            if (!allMedalSeries.isEmpty()) {
                result = this.numberOfPromotedCompetitorsIntoLastMedalRaces[--indexInNumberOfPromotedCompetitorsIntoLastMedalRaces];
                ListIterator i = allMedalSeries.listIterator(allMedalSeries.size());
                while (indexInNumberOfPromotedCompetitorsIntoLastMedalRaces > 0 && i.hasPrevious() && i.previous() != medalSeries) {
                    result += this.numberOfPromotedCompetitorsIntoLastMedalRaces[--indexInNumberOfPromotedCompetitorsIntoLastMedalRaces];
                }
            }
        }
        return result;
    }

    @Override
    public boolean isParticipatingInMedalRace(Competitor competitor, Double competitorMedalRaceScore, RaceColumnInSeries medalRaceColumn, Supplier<Map<Competitor, Integer>> competitorsRankedByOpeningSeries) {
        Integer openingSeriesRank;
        return super.isParticipatingInMedalRace(competitor, competitorMedalRaceScore, medalRaceColumn, competitorsRankedByOpeningSeries) || (openingSeriesRank = competitorsRankedByOpeningSeries.get().get(competitor)) != null && openingSeriesRank <= this.getNumberOfCompetitorsAdvancingFromOpeningSeriesToOrThroughSeries(medalRaceColumn.getSeries());
    }

    @Override
    public int compareByMedalRaceScore(Double o1MedalRaceScore, Double o2MedalRaceScore, boolean nullScoresAreBetter) {
        return 0;
    }

    @Override
    public int compareByScoreSum(Competitor o1, List<Util.Pair<RaceColumn, Double>> o1Scores, double o1ScoreSum, Competitor o2, List<Util.Pair<RaceColumn, Double>> o2Scores, double o2ScoreSum, boolean nullScoresAreBetter, boolean haveValidMedalRaceScores, Supplier<Map<Competitor, Integer>> competitorsRankedByOpeningSeries) {
        int result;
        Series lastSeriesO2ScoredIn;
        Series lastSeriesO1ScoredIn = this.getLastSeriesCompetitorScoredIn(o1Scores);
        if (!(lastSeriesO1ScoredIn != (lastSeriesO2ScoredIn = this.getLastSeriesCompetitorScoredIn(o2Scores)) && (lastSeriesO1ScoredIn != null && lastSeriesO1ScoredIn.isMedal() || lastSeriesO2ScoredIn != null && lastSeriesO2ScoredIn.isMedal()))) {
            result = super.compareByScoreSum(o1, o1Scores, o1ScoreSum, o2, o2Scores, o2ScoreSum, nullScoresAreBetter, haveValidMedalRaceScores, competitorsRankedByOpeningSeries);
        } else {
            int numberOfCompetitorsBetterThanThoseSailingInLastSeriesAnyOfTheTwoCompetitorsScoredIn;
            int o1ZeroBasedLastScoredSeriesIndex = lastSeriesO1ScoredIn == null ? -1 : Util.indexOf(lastSeriesO1ScoredIn.getRegatta().getSeries(), (Object)lastSeriesO1ScoredIn);
            int o2ZeroBasedLastScoredSeriesIndex = lastSeriesO2ScoredIn == null ? -1 : Util.indexOf(lastSeriesO2ScoredIn.getRegatta().getSeries(), (Object)lastSeriesO2ScoredIn);
            int openingSeriesRankO1 = competitorsRankedByOpeningSeries.get().get(o1);
            int openingSeriesRankO2 = competitorsRankedByOpeningSeries.get().get(o2);
            assert (o1ZeroBasedLastScoredSeriesIndex != o2ZeroBasedLastScoredSeriesIndex);
            result = o1ZeroBasedLastScoredSeriesIndex > o2ZeroBasedLastScoredSeriesIndex ? (openingSeriesRankO2 <= (numberOfCompetitorsBetterThanThoseSailingInLastSeriesAnyOfTheTwoCompetitorsScoredIn = this.getNumberOfCompetitorsBetterThanThoseSailingInSeries(lastSeriesO1ScoredIn)) ? 1 : -1) : (openingSeriesRankO1 <= (numberOfCompetitorsBetterThanThoseSailingInLastSeriesAnyOfTheTwoCompetitorsScoredIn = this.getNumberOfCompetitorsBetterThanThoseSailingInSeries(lastSeriesO2ScoredIn)) ? -1 : 1);
        }
        return result;
    }

    private Series getLastSeriesCompetitorScoredIn(List<Util.Pair<RaceColumn, Double>> competitorScores) {
        Series result = null;
        ListIterator<Util.Pair<RaceColumn, Double>> i = competitorScores.listIterator(competitorScores.size());
        while (i.hasPrevious()) {
            Util.Pair<RaceColumn, Double> score = i.previous();
            if (score.getB() == null || !(score.getA() instanceof RaceColumnInSeries)) continue;
            result = ((RaceColumnInSeries)score.getA()).getSeries();
            break;
        }
        return result;
    }

    @Override
    public int compareByBetterScore(Competitor o1, List<Util.Pair<RaceColumn, Double>> o1Scores, Competitor o2, List<Util.Pair<RaceColumn, Double>> o2Scores, Iterable<RaceColumn> raceColumnsToConsider, boolean nullScoresAreBetter, TimePoint timePoint, Leaderboard leaderboard, Map<Competitor, Set<RaceColumn>> discardedRaceColumnsPerCompetitor, BiFunction<Competitor, RaceColumn, Double> totalPointsSupplier, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        int result;
        Util.Pair lastColumnO1ScoredIn = (Util.Pair)Util.last((Iterable)Util.filter(o1Scores, o1s -> o1s.getB() != null));
        Util.Pair lastColumnO2ScoredIn = (Util.Pair)Util.last((Iterable)Util.filter(o1Scores, o2s -> o2s.getB() != null));
        RaceColumnInSeries lastMedalRaceColumnScored = lastColumnO1ScoredIn != null && ((RaceColumn)lastColumnO1ScoredIn.getA()).isMedalRace() && lastColumnO1ScoredIn.getA() instanceof RaceColumnInSeries ? (RaceColumnInSeries)lastColumnO1ScoredIn.getA() : (lastColumnO2ScoredIn != null && ((RaceColumn)lastColumnO2ScoredIn.getA()).isMedalRace() && lastColumnO2ScoredIn.getA() instanceof RaceColumnInSeries ? (RaceColumnInSeries)lastColumnO2ScoredIn.getA() : null);
        if (lastMedalRaceColumnScored != null) {
            ArrayList<RaceColumn> raceColumnsToConsiderWithoutThoseOfLastMedalSeriesToConsider = new ArrayList<RaceColumn>();
            for (RaceColumn raceColumnToConsider : raceColumnsToConsider) {
                if (raceColumnToConsider instanceof RaceColumnInSeries && ((RaceColumnInSeries)raceColumnToConsider).getSeries() == lastMedalRaceColumnScored.getSeries()) break;
                raceColumnsToConsiderWithoutThoseOfLastMedalSeriesToConsider.add(raceColumnToConsider);
            }
            result = new LeaderboardTotalRankComparator(leaderboard, timePoint, this, nullScoresAreBetter, raceColumnsToConsiderWithoutThoseOfLastMedalSeriesToConsider, totalPointsSupplier, cache).compare(o1, o2);
        } else {
            result = super.compareByBetterScore(o1, o1Scores, o2, o2Scores, raceColumnsToConsider, nullScoresAreBetter, timePoint, leaderboard, discardedRaceColumnsPerCompetitor, totalPointsSupplier, cache);
        }
        return result;
    }
}

