/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.common.ScoringSchemeType;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.impl.LowPoint;
import com.sap.sailing.domain.leaderboard.meta.MetaLeaderboardColumn;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LowPointForLeagueOverallLeaderboard
extends LowPoint {
    private static final long serialVersionUID = -2767385186133743330L;

    @Override
    public ScoringSchemeType getType() {
        return ScoringSchemeType.LOW_POINT_LEAGUE_OVERALL;
    }

    @Override
    public int compareByBetterScore(Competitor o1, List<Util.Pair<RaceColumn, Double>> o1Scores, Competitor o2, List<Util.Pair<RaceColumn, Double>> o2Scores, Iterable<RaceColumn> raceColumnsToConsider, boolean nullScoresAreBetter, TimePoint timePoint, Leaderboard leaderboard, Map<Competitor, Set<RaceColumn>> discardedRaceColumnsPerCompetitor, BiFunction<Competitor, RaceColumn, Double> totalPointsSupplier, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Double o1ScoreSum = o1Scores.stream().collect(Collectors.summingDouble(rcAndScore -> (Double)rcAndScore.getB()));
        Double o2ScoreSum = o2Scores.stream().collect(Collectors.summingDouble(rcAndScore -> (Double)rcAndScore.getB()));
        assert (Math.abs(o1ScoreSum - o2ScoreSum) < 1.0E-5);
        assert (o1Scores.stream().allMatch(rcAndScore -> rcAndScore.getA() instanceof MetaLeaderboardColumn));
        assert (o2Scores.stream().allMatch(rcAndScore -> rcAndScore.getA() instanceof MetaLeaderboardColumn));
        double netPointsSumO1 = this.getNetPoints(o1, o1Scores.stream().map(rcAndScore -> (RaceColumn)rcAndScore.getA()), timePoint);
        double netPointsSumO2 = this.getNetPoints(o2, o1Scores.stream().map(rcAndScore -> (RaceColumn)rcAndScore.getA()), timePoint);
        return this.getScoreComparator(nullScoresAreBetter).compare(netPointsSumO1, netPointsSumO2);
    }

    private double getNetPoints(Competitor competitor, Stream<RaceColumn> raceColumns, TimePoint timePoint) {
        return raceColumns.collect(Collectors.summingDouble(rc -> ((MetaLeaderboardColumn)rc).getLeaderboard().getNetPoints(competitor, timePoint)));
    }
}

