/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard;

import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CourseArea;
import com.sap.sailing.domain.base.DomainFactory;
import com.sap.sailing.domain.base.EventBase;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.LeaderboardBase;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceColumnListener;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.common.LeaderboardType;
import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.RegattaName;
import com.sap.sailing.domain.common.RegattaScoreCorrections;
import com.sap.sailing.domain.common.dto.LeaderboardDTO;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.leaderboard.HasRaceColumns;
import com.sap.sailing.domain.leaderboard.NumberOfCompetitorsInLeaderboardFetcher;
import com.sap.sailing.domain.leaderboard.RankComparable;
import com.sap.sailing.domain.leaderboard.ResultDiscardingRule;
import com.sap.sailing.domain.leaderboard.ScoreCorrectionListener;
import com.sap.sailing.domain.leaderboard.ScoreCorrectionMapping;
import com.sap.sailing.domain.leaderboard.ScoringScheme;
import com.sap.sailing.domain.leaderboard.SettableScoreCorrection;
import com.sap.sailing.domain.leaderboard.ThresholdBasedResultDiscardingRule;
import com.sap.sailing.domain.leaderboard.caching.LeaderboardDTOCalculationReuseCache;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.TrackedRegattaRegistry;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.metering.HasCPUMeter;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Leaderboard
extends LeaderboardBase,
HasRaceColumns,
HasCPUMeter {
    public LeaderboardDTO computeDTO(TimePoint var1, Collection<String> var2, boolean var3, boolean var4, TrackedRegattaRegistry var5, DomainFactory var6, boolean var7) throws NoWindException;

    public Iterable<Competitor> getCompetitors();

    public Iterable<Competitor> getAllCompetitors();

    public Iterable<Boat> getAllBoats();

    public Util.Pair<Iterable<RaceDefinition>, Iterable<Competitor>> getAllCompetitorsWithRaceDefinitionsConsidered();

    public Iterable<Competitor> getAllCompetitors(RaceColumn var1, Fleet var2);

    public Iterable<Competitor> getCompetitors(RaceColumn var1, Fleet var2);

    public Iterable<Competitor> getSuppressedCompetitors();

    public boolean isSuppressed(Competitor var1);

    public void setSuppressed(Competitor var1, boolean var2);

    public Boat getBoatOfCompetitor(Competitor var1, RaceColumn var2, Fleet var3);

    public Fleet getFleet(String var1);

    public Entry getEntry(Competitor var1, RaceColumn var2, TimePoint var3) throws NoWindException;

    default public Entry getEntry(Competitor competitor, RaceColumn race, TimePoint timePoint, Set<RaceColumn> discardedRaceColumns) {
        return this.getEntry(competitor, race, timePoint, discardedRaceColumns, new LeaderboardDTOCalculationReuseCache(timePoint));
    }

    public Entry getEntry(Competitor var1, RaceColumn var2, TimePoint var3, Set<RaceColumn> var4, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var5);

    default public Map<RaceColumn, List<Competitor>> getRankedCompetitorsFromBestToWorstAfterEachRaceColumn(TimePoint timePoint) throws NoWindException {
        return this.getRankedCompetitorsFromBestToWorstAfterEachRaceColumn(timePoint, new LeaderboardDTOCalculationReuseCache(timePoint));
    }

    public Map<RaceColumn, List<Competitor>> getRankedCompetitorsFromBestToWorstAfterEachRaceColumn(TimePoint var1, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var2) throws NoWindException;

    public Map<RaceColumn, Map<Competitor, Double>> getNetPointsSumAfterRaceColumn(TimePoint var1) throws NoWindException;

    public double getCarriedPoints(Competitor var1);

    public Map<Competitor, Double> getCompetitorsForWhichThereAreCarriedPoints();

    default public int getTrackedRank(Competitor competitor, RaceColumn race, TimePoint timePoint) {
        return this.getTrackedRank(competitor, race, timePoint, new LeaderboardDTOCalculationReuseCache(timePoint));
    }

    public int getTrackedRank(Competitor var1, RaceColumn var2, TimePoint var3, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var4);

    default public Double getTotalPoints(Competitor competitor, RaceColumn raceColumn, TimePoint timePoint) {
        return this.getTotalPoints(competitor, raceColumn, timePoint, new LeaderboardDTOCalculationReuseCache(timePoint));
    }

    public Double getTotalPoints(Competitor var1, RaceColumn var2, TimePoint var3, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var4);

    public MaxPointsReason getMaxPointsReason(Competitor var1, RaceColumn var2, TimePoint var3);

    public Double getNetPoints(Competitor var1, RaceColumn var2, TimePoint var3);

    public boolean isDiscarded(Competitor var1, RaceColumn var2, TimePoint var3);

    public Double getNetPoints(Competitor var1, TimePoint var2);

    public Double getNetPoints(Competitor var1, Iterable<RaceColumn> var2, TimePoint var3);

    default public Iterable<Competitor> getCompetitorsFromBestToWorst(RaceColumn raceColumn, TimePoint timePoint) throws NoWindException {
        return this.getCompetitorsFromBestToWorst(raceColumn, timePoint, new LeaderboardDTOCalculationReuseCache(timePoint));
    }

    public Iterable<Competitor> getCompetitorsFromBestToWorst(RaceColumn var1, TimePoint var2, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var3);

    public Iterable<Competitor> getCompetitorsFromBestToWorst(RaceColumn var1, TimePoint var2, Function<Competitor, Double> var3, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var4);

    default public Iterable<Competitor> getCompetitorsFromBestToWorst(TimePoint timePoint) {
        return this.getCompetitorsFromBestToWorst(timePoint, new LeaderboardDTOCalculationReuseCache(timePoint));
    }

    public Iterable<Competitor> getCompetitorsFromBestToWorst(TimePoint var1, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var2);

    public int getTotalRankOfCompetitor(Competitor var1, TimePoint var2);

    public Map<Util.Pair<Competitor, RaceColumn>, Entry> getContent(TimePoint var1) throws NoWindException;

    public Iterable<RaceColumn> getRaceColumns();

    public RaceColumn getRaceColumnByName(String var1);

    public void setCarriedPoints(Competitor var1, double var2);

    public void unsetCarriedPoints(Competitor var1);

    public boolean hasCarriedPoints();

    public boolean hasCarriedPoints(Competitor var1);

    public SettableScoreCorrection getScoreCorrection();

    public void addScoreCorrectionListener(ScoreCorrectionListener var1);

    public void removeScoreCorrectionListener(ScoreCorrectionListener var1);

    public Competitor getCompetitorByName(String var1);

    public void setDisplayName(Competitor var1, String var2);

    public void setDisplayName(String var1);

    public String getDisplayName(Competitor var1);

    public boolean countRaceForComparisonWithDiscardingThresholds(Competitor var1, RaceColumn var2, TimePoint var3);

    public ResultDiscardingRule getResultDiscardingRule();

    public void setCrossLeaderboardResultDiscardingRule(ThresholdBasedResultDiscardingRule var1);

    public Competitor getCompetitorByIdAsString(String var1);

    @Override
    public void addRaceColumnListener(RaceColumnListener var1);

    @Override
    public void removeRaceColumnListener(RaceColumnListener var1);

    public Long getDelayToLiveInMillis();

    public Iterable<TrackedRace> getTrackedRaces();

    public ScoringScheme getScoringScheme();

    public TimePoint getTimePointOfLatestModification();

    public Util.Pair<GPSFixMoving, Speed> getMaximumSpeedOverGround(Competitor var1, TimePoint var2);

    public Speed getAverageSpeedOverGround(Competitor var1, TimePoint var2);

    public Duration getTotalTimeSailedInLegType(Competitor var1, LegType var2, TimePoint var3) throws NoWindException;

    public Duration getTotalTimeSailed(Competitor var1, TimePoint var2);

    public Distance getTotalDistanceTraveled(Competitor var1, TimePoint var2);

    public Distance getTotalDistanceFoiled(Competitor var1, TimePoint var2);

    public Duration getTotalDurationFoiled(Competitor var1, TimePoint var2);

    public Double getNetPoints(Competitor var1, RaceColumn var2, Iterable<RaceColumn> var3, TimePoint var4) throws NoWindException;

    public Double getNetPoints(Competitor var1, RaceColumn var2, TimePoint var3, Set<RaceColumn> var4);

    public Double getNetPoints(Competitor var1, RaceColumn var2, TimePoint var3, Set<RaceColumn> var4, Supplier<Double> var5);

    public TimePoint getNowMinusDelay();

    public Iterable<CourseArea> getCourseAreas();

    public void destroy();

    public LeaderboardDTO getLeaderboardDTO(TimePoint var1, Collection<String> var2, boolean var3, TrackedRegattaRegistry var4, DomainFactory var5, boolean var6) throws NoWindException, InterruptedException, ExecutionException;

    public NumberOfCompetitorsInLeaderboardFetcher getNumberOfCompetitorsInLeaderboardFetcher();

    public BoatClass getBoatClass();

    public LeaderboardType getLeaderboardType();

    public boolean hasScores(Competitor var1, TimePoint var2);

    default public boolean isWin(Competitor competitor, RaceColumn raceColumn, TimePoint timePoint) {
        LeaderboardDTOCalculationReuseCache cache = new LeaderboardDTOCalculationReuseCache(timePoint);
        return this.isWin(competitor, raceColumn, timePoint, cache);
    }

    default public boolean isWin(Competitor competitor, RaceColumn raceColumn, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return this.getScoringScheme().isWin(this, competitor, raceColumn, timePoint, c -> this.getTotalPoints((Competitor)c, raceColumn, timePoint, cache), cache);
    }

    default public QualifiedObjectIdentifier getIdentifier() {
        return this.getPermissionType().getQualifiedObjectIdentifier(this.getTypeRelativeObjectIdentifier());
    }

    default public TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier() {
        return Leaderboard.getTypeRelativeObjectIdentifier(this.getName());
    }

    public static TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier(String name) {
        return new TypeRelativeObjectIdentifier(new String[]{name});
    }

    public static TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier(RegattaName regattaName) {
        return new TypeRelativeObjectIdentifier(new String[]{regattaName.getRegattaName()});
    }

    default public HasPermissions getPermissionType() {
        return SecuredDomainType.LEADERBOARD;
    }

    default public boolean isPartOfEvent(EventBase event) {
        return Util.containsAny((Iterable)event.getVenue().getCourseAreas(), this.getCourseAreas());
    }

    public Map<Duration, Util.Pair<Duration, Integer>> getComputationTimeStatistics();

    public ScoreCorrectionMapping mapRegattaScoreCorrections(RegattaScoreCorrections var1, Map<String, RaceColumn> var2, Map<String, Competitor> var3, boolean var4, boolean var5);

    public boolean isResultsAreOfficial(RaceColumn var1, Fleet var2);

    public static interface Entry {
        public int getTrackedRank();

        public Double getTotalPoints();

        public Double getIncrementalScoreCorrectionInPoints();

        public Double getTotalPointsUncorrected();

        public Double getNetPoints();

        public MaxPointsReason getMaxPointsReason();

        public boolean isDiscarded();

        public boolean isTotalPointsCorrected();

        public Fleet getFleet();
    }

    public static class RankComparableRank
    implements RankComparable {
        private final Integer rank;

        public RankComparableRank(Integer rank) {
            assert (rank != null);
            if (rank == null) {
                throw new NullPointerException("rank must not be null");
            }
            this.rank = rank;
        }

        @Override
        public int compareTo(RankComparable o) {
            RankComparableRank otherRankComparableRank = (RankComparableRank)o;
            int result = this.rank == 0 ? 1 : (otherRankComparableRank.rank == 0 ? -1 : this.rank - otherRankComparableRank.rank);
            return result;
        }
    }
}

