/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.shared.util.impl;

import com.sap.sse.shared.util.impl.AbstractUnmodifiableNavigableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.SortedSet;

public class UnmodifiableNavigableSet<E>
extends AbstractUnmodifiableNavigableSet<E>
implements NavigableSet<E> {
    private static final long serialVersionUID = -2829360843200741699L;
    private final NavigableSet<E> set;

    public UnmodifiableNavigableSet(NavigableSet<E> delegate) {
        this.set = delegate;
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.set.comparator();
    }

    @Override
    public E first() {
        return this.set.first();
    }

    @Override
    public E last() {
        return this.set.last();
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.set.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.set.toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.set.containsAll(c);
    }

    @Override
    public E lower(E e) {
        return this.set.lower(e);
    }

    @Override
    public E floor(E e) {
        return this.set.floor(e);
    }

    @Override
    public E ceiling(E e) {
        return this.set.ceiling(e);
    }

    @Override
    public E higher(E e) {
        return this.set.higher(e);
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator<E> setIterator = this.set.iterator();
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return setIterator.hasNext();
            }

            @Override
            public E next() {
                return setIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public NavigableSet<E> descendingSet() {
        return new UnmodifiableNavigableSet<E>(this.set.descendingSet());
    }

    @Override
    public Iterator<E> descendingIterator() {
        final Iterator<E> setIterator = this.set.descendingIterator();
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return setIterator.hasNext();
            }

            @Override
            public E next() {
                return setIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return new UnmodifiableNavigableSet<E>(this.set.subSet(fromElement, fromInclusive, toElement, toInclusive));
    }

    @Override
    public NavigableSet<E> headSet(E toElement, boolean inclusive) {
        return new UnmodifiableNavigableSet<E>(this.set.headSet(toElement, inclusive));
    }

    @Override
    public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
        return new UnmodifiableNavigableSet<E>(this.set.tailSet(fromElement, inclusive));
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        return Collections.unmodifiableSortedSet(this.set.subSet(fromElement, toElement));
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        return Collections.unmodifiableSortedSet(this.set.headSet(toElement));
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        return Collections.unmodifiableSortedSet(this.set.tailSet(fromElement));
    }
}

