/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.shared.media;

import com.sap.sse.common.Util;
import com.sap.sse.common.media.MimeType;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class MediaUtils {
    private static final Logger logger = Logger.getLogger(MediaUtils.class.getName());
    private static final Pattern YOUTUBE_ID_REGEX = Pattern.compile("^.*(youtu.be/|v/|u/\\w/|embed/|watch\\?v=|\\&v=)([^#\\&\\?]+).*$");
    private static final Pattern VIMEO_REGEX = Pattern.compile("^.*(vimeo\\.com\\/).*");
    private static final ExecutorService executor = Executors.newCachedThreadPool();

    public static MimeType detectMimeTypeFromUrl(String url) {
        MimeType result = MimeType.unknown;
        if (YOUTUBE_ID_REGEX.matcher(url).matches()) {
            result = MimeType.youtube;
        } else if (VIMEO_REGEX.matcher(url).matches()) {
            result = MimeType.vimeo;
        } else if (url != null) {
            MimeType[] mimeTypeArray = MimeType.values();
            int n = mimeTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                String regex;
                MimeType mimeType = mimeTypeArray[n2];
                if (mimeType.endingPattern.length() > 0 && Pattern.compile(regex = "[a-z\\-_0-9\\/\\:\\.]*\\.(" + mimeType.getEndingPattern() + ")").matcher(url).matches()) {
                    result = mimeType;
                    break;
                }
                ++n2;
            }
        }
        return result;
    }

    public static Util.Pair<Integer, Integer> getImageDimensions(URL imageURL) {
        Future<Util.Pair<Integer, Integer>> imageSizeCalculator = MediaUtils.getOrCreateImageSizeCalculator(imageURL);
        try {
            return imageSizeCalculator.get();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Future<Util.Pair<Integer, Integer>> getOrCreateImageSizeCalculator(final URL imageURL) {
        Future<Util.Pair<Integer, Integer>> imageSizeFetcher = executor.submit(new Callable<Util.Pair<Integer, Integer>>(){

            @Override
            public Util.Pair<Integer, Integer> call() throws IOException {
                Util.Pair result;
                block9: {
                    result = null;
                    try (ImageInputStream in = null;){
                        try {
                            URLConnection conn = imageURL.openConnection();
                            in = ImageIO.createImageInputStream(conn.getInputStream());
                            Iterator<ImageReader> readers = ImageIO.getImageReaders(in);
                            if (!readers.hasNext()) break block9;
                            ImageReader reader = readers.next();
                            try {
                                reader.setInput(in);
                                result = new Util.Pair((Object)reader.getWidth(0), (Object)reader.getHeight(0));
                            }
                            finally {
                                reader.dispose();
                            }
                        }
                        catch (IOException ioe) {
                            logger.log(Level.SEVERE, "Stale image URL: " + imageURL, ioe);
                            throw ioe;
                        }
                    }
                }
                return result;
            }
        });
        return imageSizeFetcher;
    }

    public static Util.Pair<Integer, Integer> fitImageSizeToBox(int boxWidth, int boxHeight, int imageWidth, int imageHeight, boolean neverScaleUp) {
        double scale = Math.min((double)boxWidth / (double)imageWidth, (double)boxHeight / (double)imageHeight);
        int h = (int)(!neverScaleUp || scale < 1.0 ? scale * (double)imageHeight : (double)imageHeight);
        int w = (int)(!neverScaleUp || scale < 1.0 ? scale * (double)imageWidth : (double)imageWidth);
        return new Util.Pair((Object)w, (Object)h);
    }
}

