/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.concurrent;

import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.concurrent.ConcurrentWeakHashMap;
import com.sap.sse.concurrent.NamedReentrantReadWriteLock;
import com.sap.sse.concurrent.RunnableWithException;
import com.sap.sse.concurrent.RunnableWithResult;
import com.sap.sse.concurrent.RunnableWithResultAndException;
import com.sap.sse.shared.util.impl.ApproximateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LockUtil {
    private static final int NUMBER_OF_SECONDS_TO_WAIT_FOR_LOCK = 5;
    private static final Logger logger = Logger.getLogger(Util.class.getName());
    private static final Map<NamedReentrantReadWriteLock, TimePoint> lastTimeWriteLockWasObtained = new ConcurrentWeakHashMap<NamedReentrantReadWriteLock, TimePoint>();
    private static final Map<Thread, Map<Lock, Integer>> propagationCounts = new ConcurrentWeakHashMap<Thread, Map<Lock, Integer>>();
    private static final Map<Thread, Map<Lock, Integer>> virtualLockCounts = new ConcurrentWeakHashMap<Thread, Map<Lock, Integer>>();
    private static final Map<Thread, Map<Lock, Integer>> lockCounts = new ConcurrentWeakHashMap<Thread, Map<Lock, Integer>>();

    public static void lockForRead(NamedReentrantReadWriteLock lock) {
        LockUtil.acquireLockVirtuallyOrActually(lock, lock.readLock(), ReadOrWrite.READ);
    }

    public static void lockForWrite(NamedReentrantReadWriteLock lock) {
        LockUtil.acquireLockVirtuallyOrActually(lock, lock.writeLock(), ReadOrWrite.WRITE);
        lastTimeWriteLockWasObtained.put(lock, ApproximateTime.approximateNow());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void acquireLockVirtuallyOrActually(NamedReentrantReadWriteLock lock, Lock readOrWriteLock, ReadOrWrite readOrWrite) {
        boolean locked = false;
        while (!locked) {
            Map<Lock, Integer> currentThreadsPropagationCounts;
            Map<Lock, Integer> map = currentThreadsPropagationCounts = LockUtil.getCurrentThreadsPropagationCounts();
            synchronized (map) {
                if (currentThreadsPropagationCounts.containsKey(readOrWriteLock)) {
                    LockUtil.incrementVirtualLockCountForCurrentThread(readOrWriteLock);
                    locked = true;
                } else {
                    locked = LockUtil.lock(readOrWriteLock, readOrWrite == ReadOrWrite.READ ? lock.getReadLockName() : lock.getWriteLockName(), lock);
                    if (locked) {
                        LockUtil.incrementLockCountForCurrentThread(readOrWriteLock);
                    }
                }
            }
            if (locked) continue;
            Thread.yield();
        }
    }

    public static void unlockAfterRead(NamedReentrantReadWriteLock lock) {
        ReentrantReadWriteLock.ReadLock readOrWriteLock = lock.readLock();
        LockUtil.unlockVirtuallyOrActually(lock, readOrWriteLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unlockVirtuallyOrActually(NamedReentrantReadWriteLock lock, Lock readOrWriteLock) {
        Map<Lock, Integer> currentThreadPropagationCounts;
        Map<Lock, Integer> map = currentThreadPropagationCounts = LockUtil.getCurrentThreadsPropagationCounts();
        synchronized (map) {
            assert (LockUtil.isInCurrentThreadsLockSet(readOrWriteLock));
            Integer virtualLockCount = LockUtil.getCurrentThreadsVirtualLockCounts().get(readOrWriteLock);
            if (virtualLockCount != null) {
                LockUtil.decrementVirtualLockCountForCurrentThread(readOrWriteLock);
            } else {
                readOrWriteLock.unlock();
                LockUtil.decrementLockCountForCurrentThread(readOrWriteLock);
            }
        }
    }

    public static void unlockAfterWrite(NamedReentrantReadWriteLock lock) {
        LockUtil.unlockVirtuallyOrActually(lock, lock.writeLock());
        TimePoint timePointWriteLockWasObtained = lastTimeWriteLockWasObtained.get(lock);
        if (timePointWriteLockWasObtained == null) {
            logger.info("Internal error: write lock " + lock.getName() + " to be unlocked but no time recorded for when it was last obtained.\n" + "This is where the lock interaction happened:\n" + LockUtil.getCurrentStackTrace());
        } else {
            TimePoint now = ApproximateTime.approximateNow();
            Duration heldWriteLockForMillis = timePointWriteLockWasObtained.until(now);
            if (heldWriteLockForMillis.compareTo((Object)Duration.ONE_SECOND.times(10L)) > 0) {
                String stackTrace = LockUtil.getCurrentStackTrace();
                logger.info("write lock " + lock.getName() + " was approximately held for more than 10s (" + heldWriteLockForMillis + "). It got unlocked here: " + stackTrace);
            }
        }
    }

    public static void propagateLockSetFrom(Thread from) {
        Thread to = Thread.currentThread();
        LockUtil.propagateLockSet(from, to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void propagateLockSet(Thread from, Thread to) {
        Map<Lock, Integer> toMap;
        Set<Lock> locksToPropagate = LockUtil.getLocksHeldVirtuallyOrActuallyBy(from);
        Map<Lock, Integer> map = toMap = LockUtil.getPropagationCounts(to);
        synchronized (map) {
            for (Lock lockToPropagate : locksToPropagate) {
                LockUtil.increment(lockToPropagate, toMap);
            }
        }
    }

    public static void propagateLockSetTo(Thread to) {
        Thread from = Thread.currentThread();
        LockUtil.propagateLockSet(from, to);
    }

    public static void unpropagateLockSetFrom(Thread from) {
        Thread to = Thread.currentThread();
        LockUtil.unpropagateLockSet(from, to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unpropagateLockSet(Thread from, Thread to) {
        Map<Lock, Integer> toMap;
        Set<Lock> locksToPropagate = LockUtil.getLocksHeldVirtuallyOrActuallyBy(from);
        Map<Lock, Integer> map = toMap = LockUtil.getPropagationCounts(to);
        synchronized (map) {
            for (Lock lockToPropagate : locksToPropagate) {
                LockUtil.decrement(lockToPropagate, toMap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<Lock> getLocksHeldVirtuallyOrActuallyBy(Thread thread) {
        Map<Lock, Integer> lockMap;
        HashSet<Lock> locksToPropagate = new HashSet<Lock>();
        Map<Lock, Integer> propagationMap = propagationCounts.get(thread);
        if (propagationMap != null) {
            Map<Lock, Integer> map = propagationMap;
            synchronized (map) {
                for (Map.Entry<Lock, Integer> otherEntry : propagationMap.entrySet()) {
                    locksToPropagate.add(otherEntry.getKey());
                }
            }
        }
        if ((lockMap = lockCounts.get(thread)) != null) {
            for (Map.Entry<Lock, Integer> otherEntry : lockMap.entrySet()) {
                locksToPropagate.add(otherEntry.getKey());
            }
        }
        return locksToPropagate;
    }

    public static void unpropagateLockSetTo(Thread to) {
        Thread from = Thread.currentThread();
        LockUtil.unpropagateLockSet(from, to);
    }

    private static Map<Lock, Integer> getCurrentThreadsPropagationCounts() {
        Thread currentThread = Thread.currentThread();
        return LockUtil.getPropagationCounts(currentThread);
    }

    private static Map<Lock, Integer> getCurrentThreadsLockCounts() {
        Thread currentThread = Thread.currentThread();
        return LockUtil.getLockCounts(currentThread);
    }

    private static Map<Lock, Integer> getCurrentThreadsVirtualLockCounts() {
        Thread currentThread = Thread.currentThread();
        return LockUtil.getVirtualLockCounts(currentThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Lock, Integer> getOrCreateMapForThread(Thread thread, Map<Thread, Map<Lock, Integer>> map) {
        Map<Lock, Integer> result = map.get(thread);
        if (result == null) {
            Map<Thread, Map<Lock, Integer>> map2 = map;
            synchronized (map2) {
                result = map.get(thread);
                if (result == null) {
                    result = new ConcurrentHashMap<Lock, Integer>();
                    map.put(thread, result);
                }
            }
        }
        return result;
    }

    private static Map<Lock, Integer> getLockCounts(Thread thread) {
        return LockUtil.getOrCreateMapForThread(thread, lockCounts);
    }

    private static Map<Lock, Integer> getPropagationCounts(Thread thread) {
        return LockUtil.getOrCreateMapForThread(thread, propagationCounts);
    }

    private static Map<Lock, Integer> getVirtualLockCounts(Thread thread) {
        return LockUtil.getOrCreateMapForThread(thread, virtualLockCounts);
    }

    private static void incrementLockCountForCurrentThread(Lock lock) {
        Map<Lock, Integer> map = LockUtil.getCurrentThreadsLockCounts();
        LockUtil.increment(lock, map);
    }

    private static void decrementLockCountForCurrentThread(Lock lock) {
        LockUtil.decrement(lock, LockUtil.getCurrentThreadsLockCounts());
    }

    private static void incrementVirtualLockCountForCurrentThread(Lock lock) {
        LockUtil.increment(lock, LockUtil.getCurrentThreadsVirtualLockCounts());
    }

    private static void decrementVirtualLockCountForCurrentThread(Lock lock) {
        LockUtil.decrement(lock, LockUtil.getCurrentThreadsVirtualLockCounts());
    }

    private static void increment(Lock lock, Map<Lock, Integer> map) {
        int newValue = map.containsKey(lock) ? map.get(lock) + 1 : 1;
        map.put(lock, newValue);
    }

    private static void decrement(Lock lock, Map<Lock, Integer> map) {
        assert (map.containsKey(lock));
        int newValue = map.get(lock) - 1;
        if (newValue == 0) {
            map.remove(lock);
        } else {
            map.put(lock, newValue);
        }
    }

    private static boolean isInCurrentThreadsLockSet(Lock lock) {
        return LockUtil.getCurrentThreadsLockCounts().containsKey(lock) || LockUtil.getCurrentThreadsVirtualLockCounts().containsKey(lock);
    }

    private static String formatStackTrace(StackTraceElement[] stackTrace) {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = stackTrace;
        int n = stackTrace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement sf = stackTraceElementArray[n2];
            sb.append(sf.toString());
            sb.append('\n');
            ++n2;
        }
        return sb.toString();
    }

    private static String getCurrentStackTrace() {
        return LockUtil.formatStackTrace(Thread.currentThread().getStackTrace());
    }

    private static boolean lock(Lock lock, String lockDescriptionForTimeoutLogMessage, NamedReentrantReadWriteLock lockParent) {
        boolean locked = false;
        try {
            locked = lock.tryLock(5L, TimeUnit.SECONDS);
            if (!locked) {
                Thread writer = lockParent.getWriter();
                StackTraceElement[] writerStackTrace = writer != null ? writer.getStackTrace() : null;
                HashMap<Thread, StackTraceElement[]> readerStackTraces = new HashMap<Thread, StackTraceElement[]>();
                Iterable<Thread> readers = lockParent.getReaders();
                for (Thread reader : readers) {
                    readerStackTraces.put(reader, reader.getStackTrace());
                }
                StringBuilder message = new StringBuilder();
                message.append("Couldn't acquire lock ");
                message.append(lockDescriptionForTimeoutLogMessage);
                message.append(" in ");
                message.append(5);
                message.append("s in thread " + Thread.currentThread().getName() + " at ");
                message.append(LockUtil.getCurrentStackTrace());
                if (writer != null) {
                    message.append("\nThe current writer is:\n");
                    LockUtil.appendThreadData(message, writer, writerStackTrace);
                }
                if (readers != null && !Util.isEmpty(readers)) {
                    message.append("\nThe current readers are:\n");
                    for (Thread reader : readers) {
                        LockUtil.appendThreadData(message, reader, (StackTraceElement[])readerStackTraces.get(reader));
                    }
                }
                message.append("Trying again...");
                logger.info(message.toString());
            }
        }
        catch (InterruptedException ex) {
            logger.log(Level.WARNING, "Interrupted while waiting for lock " + lockDescriptionForTimeoutLogMessage, ex);
        }
        return locked;
    }

    private static void appendThreadData(StringBuilder message, Thread writer, StackTraceElement[] stackTrace) {
        message.append(writer);
        message.append('\n');
        message.append(LockUtil.formatStackTrace(stackTrace));
        message.append('\n');
    }

    public static void executeWithReadLock(NamedReentrantReadWriteLock lock, Runnable runnable) {
        LockUtil.lockForRead(lock);
        try {
            runnable.run();
        }
        finally {
            LockUtil.unlockAfterRead(lock);
        }
    }

    public static <T> T executeWithReadLockAndResult(NamedReentrantReadWriteLock lock, RunnableWithResult<T> runnable) {
        LockUtil.lockForRead(lock);
        try {
            T t = runnable.run();
            return t;
        }
        finally {
            LockUtil.unlockAfterRead(lock);
        }
    }

    public static void executeWithWriteLock(NamedReentrantReadWriteLock lock, Runnable runnable) {
        LockUtil.lockForWrite(lock);
        try {
            runnable.run();
        }
        finally {
            LockUtil.unlockAfterWrite(lock);
        }
    }

    public static <T> T executeWithWriteLockAndResult(NamedReentrantReadWriteLock lock, RunnableWithResult<T> runnable) {
        LockUtil.lockForWrite(lock);
        try {
            T t = runnable.run();
            return t;
        }
        finally {
            LockUtil.unlockAfterWrite(lock);
        }
    }

    public static <T, E extends Throwable> T executeWithWriteLockAndResultExpectException(NamedReentrantReadWriteLock lock, RunnableWithResultAndException<T, E> runnable) throws E {
        LockUtil.lockForWrite(lock);
        try {
            T t = runnable.run();
            return t;
        }
        finally {
            LockUtil.unlockAfterWrite(lock);
        }
    }

    public static <E extends Throwable> void executeWithWriteLockExpectException(NamedReentrantReadWriteLock lock, RunnableWithException<E> runnable) throws E {
        LockUtil.lockForWrite(lock);
        try {
            runnable.run();
        }
        finally {
            LockUtil.unlockAfterWrite(lock);
        }
    }

    public static <T, E extends Throwable> T executeWithReadLockAndResultExpectException(NamedReentrantReadWriteLock lock, RunnableWithResultAndException<T, E> runnable) throws E {
        LockUtil.lockForRead(lock);
        try {
            T t = runnable.run();
            return t;
        }
        finally {
            LockUtil.unlockAfterRead(lock);
        }
    }

    public static <E extends Throwable> void executeWithReadLockExpectException(NamedReentrantReadWriteLock lock, RunnableWithException<E> runnable) throws E {
        LockUtil.lockForRead(lock);
        try {
            runnable.run();
        }
        finally {
            LockUtil.unlockAfterRead(lock);
        }
    }

    private static enum ReadOrWrite {
        READ,
        WRITE;

    }
}

