/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.shared.subscription;

import com.sap.sse.common.TimePoint;
import java.io.Serializable;

public abstract class Subscription
implements Serializable {
    public static final String PAYMENT_STATUS_SUCCESS = "success";
    public static final String PAYMENT_STATUS_NO_SUCCESS = "no_success";
    private static final long serialVersionUID = 96845123954667808L;
    private final String subscriptionId;
    private final String planId;
    private final String customerId;
    private final TimePoint trialStart;
    private final TimePoint trialEnd;
    private final String subscriptionStatus;
    protected String paymentStatus;
    protected String invoiceId;
    protected String invoiceStatus;
    protected String transactionType;
    protected String transactionStatus;
    private final TimePoint subscriptionCreatedAt;
    private final Integer reoccuringPaymentValue;
    private final String currencyCode;
    private final TimePoint cancelledAt;
    private final TimePoint subscriptionActivatedAt;
    private final TimePoint nextBillingAt;
    private final TimePoint currentTermEnd;
    private final TimePoint subscriptionUpdatedAt;
    private final TimePoint latestEventTime;
    private final TimePoint manualUpdatedAt;
    private final String providerName;

    public static TimePoint emptyTime() {
        return Subscription.getTime(0L);
    }

    public static TimePoint getTime(long milisTimestamp) {
        return TimePoint.of((long)milisTimestamp);
    }

    public Subscription(String subscriptionId, String planId, String customerId, TimePoint trialStart, TimePoint trialEnd, String subscriptionStatus, String paymentStatus, String transactionType, String transactionStatus, String invoiceId, String invoiceStatus, Integer reoccuringPaymentValue, String currencyCode, TimePoint subscriptionCreatedAt, TimePoint subscriptionUpdatedAt, TimePoint subscriptionActivatedAt, TimePoint nextBillingAt, TimePoint currentTermEnd, TimePoint cancelledAt, TimePoint latestEventTime, TimePoint manualUpdatedAt, String providerName) {
        this.subscriptionId = subscriptionId;
        this.planId = planId;
        this.customerId = customerId;
        this.currencyCode = currencyCode;
        this.subscriptionActivatedAt = subscriptionActivatedAt;
        this.nextBillingAt = nextBillingAt;
        this.currentTermEnd = currentTermEnd;
        this.reoccuringPaymentValue = reoccuringPaymentValue;
        this.cancelledAt = cancelledAt;
        this.trialStart = trialStart == null ? Subscription.emptyTime() : trialStart;
        this.trialEnd = trialEnd == null ? Subscription.emptyTime() : trialEnd;
        this.subscriptionStatus = subscriptionStatus;
        this.paymentStatus = paymentStatus;
        this.transactionType = transactionType;
        this.transactionStatus = transactionStatus;
        this.invoiceId = invoiceId;
        this.invoiceStatus = invoiceStatus;
        this.subscriptionCreatedAt = subscriptionCreatedAt == null ? Subscription.emptyTime() : subscriptionCreatedAt;
        this.subscriptionUpdatedAt = subscriptionUpdatedAt == null ? Subscription.emptyTime() : subscriptionUpdatedAt;
        this.latestEventTime = latestEventTime == null ? Subscription.emptyTime() : latestEventTime;
        this.manualUpdatedAt = manualUpdatedAt == null ? Subscription.emptyTime() : manualUpdatedAt;
        this.providerName = providerName;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getPlanId() {
        return this.planId;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public TimePoint getTrialStart() {
        return this.trialStart;
    }

    public TimePoint getTrialEnd() {
        return this.trialEnd;
    }

    public String getSubscriptionStatus() {
        return this.subscriptionStatus;
    }

    public String getPaymentStatus() {
        return this.paymentStatus;
    }

    public String getTransactionType() {
        return this.transactionType;
    }

    public String getTransactionStatus() {
        return this.transactionStatus;
    }

    public String getInvoiceId() {
        return this.invoiceId;
    }

    public String getInvoiceStatus() {
        return this.invoiceStatus;
    }

    public TimePoint getSubscriptionCreatedAt() {
        return this.subscriptionCreatedAt;
    }

    public TimePoint getSubscriptionUpdatedAt() {
        return this.subscriptionUpdatedAt;
    }

    public TimePoint getLatestEventTime() {
        return this.latestEventTime;
    }

    public TimePoint getManualUpdatedAt() {
        return this.manualUpdatedAt;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public TimePoint getSubscriptionActivatedAt() {
        return this.subscriptionActivatedAt;
    }

    public TimePoint getNextBillingAt() {
        return this.nextBillingAt;
    }

    public TimePoint getCurrentTermEnd() {
        return this.currentTermEnd;
    }

    public boolean hasPlan() {
        return this.planId != null && !this.planId.isEmpty();
    }

    public boolean hasSubscriptionId() {
        return this.subscriptionId != null && !this.subscriptionId.isEmpty();
    }

    public abstract boolean isActiveSubscription();

    public boolean isUpdatedMoreRecently(Subscription otherSubscription) {
        return this.getManualUpdatedAt().asMillis() > otherSubscription.getManualUpdatedAt().asMillis() || this.getLatestEventTime().asMillis() > otherSubscription.getLatestEventTime().asMillis();
    }

    public TimePoint getCancelledAt() {
        return this.cancelledAt;
    }

    public Integer getReoccuringPaymentValue() {
        return this.reoccuringPaymentValue;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public abstract void patchTransactionData(Subscription var1);

    public abstract void patchInvoiceData(Subscription var1);

    public String toString() {
        return "Subscription [subscriptionId=" + this.subscriptionId + ", planId=" + this.planId + ", customerId=" + this.customerId + ", trialStart=" + this.trialStart + ", trialEnd=" + this.trialEnd + ", subscriptionStatus=" + this.subscriptionStatus + ", paymentStatus=" + this.paymentStatus + ", invoiceId=" + this.invoiceId + ", invoiceStatus=" + this.invoiceStatus + ", transactionType=" + this.transactionType + ", transactionStatus=" + this.transactionStatus + ", subscriptionCreatedAt=" + this.subscriptionCreatedAt + ", reoccuringPaymentValue=" + this.reoccuringPaymentValue + ", currencyCode=" + this.getCurrencyCode() + ", cancelledAt=" + this.cancelledAt + ", subscriptionActivatedAt=" + this.subscriptionActivatedAt + ", nextBillingAt=" + this.nextBillingAt + ", currentTermEnd=" + this.currentTermEnd + ", subscriptionUpdatedAt=" + this.subscriptionUpdatedAt + ", latestEventTime=" + this.latestEventTime + ", manualUpdatedAt=" + this.manualUpdatedAt + ", providerName=" + this.providerName + "]";
    }
}

