/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.shared;

import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.impl.QualifiedObjectIdentifierImpl;
import com.sap.sse.security.shared.impl.WildcardPermissionEncoder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class WildcardPermission
implements Serializable {
    private static final long serialVersionUID = -7136806951296823464L;
    public static final String WILDCARD_TOKEN = "*";
    public static final String PART_DIVIDER_TOKEN = ":";
    public static final String SUBPART_DIVIDER_TOKEN = ",";
    private List<Set<String>> parts;
    private transient Iterable<QualifiedObjectIdentifier> qualifiedObjectIdentifiers;

    @Deprecated
    protected WildcardPermission() {
    }

    public WildcardPermission(String wildcardString) {
        this(WildcardPermission.createPartsFromString(wildcardString));
    }

    private WildcardPermission(List<Set<String>> parts) {
        this.parts = parts;
    }

    protected static List<Set<String>> createPartsFromString(String wildcardString) {
        if (wildcardString == null || wildcardString.trim().length() == 0) {
            throw new IllegalArgumentException("Wildcard string cannot be null or empty. Make sure permission strings are properly formatted.");
        }
        wildcardString = wildcardString.trim();
        List<String> rawParts = Arrays.asList(wildcardString.split(PART_DIVIDER_TOKEN));
        ArrayList<Set<String>> parts = new ArrayList<Set<String>>();
        for (String part : rawParts) {
            HashSet<String> subparts = new HashSet<String>(Arrays.asList(part.split(SUBPART_DIVIDER_TOKEN)));
            if (subparts.isEmpty()) {
                throw new IllegalArgumentException("Wildcard string cannot contain parts with only dividers. Make sure permission strings are properly formatted.");
            }
            parts.add(subparts);
        }
        if (parts.isEmpty()) {
            throw new IllegalArgumentException("Wildcard string cannot contain only dividers. Make sure permission strings are properly formatted.");
        }
        return parts;
    }

    public List<Set<String>> getParts() {
        return this.parts;
    }

    public boolean implies(WildcardPermission wp) {
        return this.implies(wp, true);
    }

    private boolean implies(WildcardPermission wp, boolean checkWildcardPartsIfThisPermissionHasMoreParts) {
        List<Set<String>> otherParts = wp.getParts();
        int i = 0;
        for (Set<String> otherPart : otherParts) {
            if (this.getParts().size() - 1 < i) {
                return true;
            }
            Set<String> part = this.getParts().get(i);
            if (!part.contains(WILDCARD_TOKEN) && !part.containsAll(otherPart)) {
                return false;
            }
            ++i;
        }
        if (checkWildcardPartsIfThisPermissionHasMoreParts) {
            while (i < this.getParts().size()) {
                Set<String> part = this.getParts().get(i);
                if (!part.contains(WILDCARD_TOKEN)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public boolean impliesAny(WildcardPermission wp) {
        return this.implies(wp, false);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (Set<String> unsortedPart : this.parts) {
            TreeSet<String> sortedPart = new TreeSet<String>(unsortedPart);
            if (buffer.length() > 0) {
                buffer.append(PART_DIVIDER_TOKEN);
            }
            boolean first = true;
            for (String subpart : sortedPart) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(SUBPART_DIVIDER_TOKEN);
                }
                buffer.append(subpart);
            }
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof WildcardPermission) {
            WildcardPermission wp = (WildcardPermission)o;
            return this.parts.equals(wp.parts);
        }
        return false;
    }

    public int hashCode() {
        return this.parts.hashCode();
    }

    public Iterable<QualifiedObjectIdentifier> getQualifiedObjectIdentifiers() {
        if (this.qualifiedObjectIdentifiers == null) {
            ArrayList<QualifiedObjectIdentifier> result = new ArrayList<QualifiedObjectIdentifier>();
            WildcardPermissionEncoder encoder = new WildcardPermissionEncoder();
            if (this.getParts().size() >= 3) {
                for (String typeName : this.getParts().get(0)) {
                    for (String encodedRelativeObjectId : this.getParts().get(2)) {
                        result.add(new QualifiedObjectIdentifierImpl(typeName, new TypeRelativeObjectIdentifier(encoder.decodeStringList(encodedRelativeObjectId))));
                    }
                }
            }
            this.qualifiedObjectIdentifiers = result;
        }
        return this.qualifiedObjectIdentifiers;
    }

    public static WildcardPermissionBuilder builder() {
        return new WildcardPermissionBuilder();
    }

    /* synthetic */ WildcardPermission(List list, WildcardPermission wildcardPermission) {
        this(list);
    }

    public static class WildcardPermissionBuilder {
        private Set<String> typeNames = new HashSet<String>();
        private Set<String> actionNames = new HashSet<String>();
        private Set<String> ids = new HashSet<String>();

        public WildcardPermissionBuilder withTypes(HasPermissions ... types) {
            HasPermissions[] hasPermissionsArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                HasPermissions hasPermissions = hasPermissionsArray[n2];
                this.typeNames.add(hasPermissions.getName());
                ++n2;
            }
            return this;
        }

        public WildcardPermissionBuilder withTypeNames(String ... typeNames) {
            String[] stringArray = typeNames;
            int n = typeNames.length;
            int n2 = 0;
            while (n2 < n) {
                String typeName = stringArray[n2];
                this.typeNames.add(typeName);
                ++n2;
            }
            return this;
        }

        public WildcardPermissionBuilder withActions(HasPermissions.Action ... actions) {
            HasPermissions.Action[] actionArray = actions;
            int n = actions.length;
            int n2 = 0;
            while (n2 < n) {
                HasPermissions.Action action = actionArray[n2];
                this.actionNames.add(action.name());
                ++n2;
            }
            return this;
        }

        public WildcardPermissionBuilder withActionNames(String ... actionNames) {
            String[] stringArray = actionNames;
            int n = actionNames.length;
            int n2 = 0;
            while (n2 < n) {
                String actionName = stringArray[n2];
                this.actionNames.add(actionName);
                ++n2;
            }
            return this;
        }

        public WildcardPermissionBuilder withIds(String ... ids) {
            this.ids.addAll(Arrays.asList(ids));
            return this;
        }

        public WildcardPermissionBuilder withIds(TypeRelativeObjectIdentifier ... typeRelativeObjectIdentifiers) {
            TypeRelativeObjectIdentifier[] typeRelativeObjectIdentifierArray = typeRelativeObjectIdentifiers;
            int n = typeRelativeObjectIdentifiers.length;
            int n2 = 0;
            while (n2 < n) {
                TypeRelativeObjectIdentifier identifier = typeRelativeObjectIdentifierArray[n2];
                this.ids.add(identifier.toString());
                ++n2;
            }
            return this;
        }

        public WildcardPermission build() {
            ArrayList<Set<String>> parts = new ArrayList<Set<String>>(2);
            if (this.typeNames.isEmpty()) {
                parts.add(new HashSet<String>(Collections.singleton(WildcardPermission.WILDCARD_TOKEN)));
            } else {
                parts.add(this.typeNames);
            }
            if (!this.actionNames.isEmpty()) {
                parts.add(this.actionNames);
            } else if (!this.ids.isEmpty()) {
                parts.add(new HashSet<String>(Collections.singleton(WildcardPermission.WILDCARD_TOKEN)));
            }
            if (!this.ids.isEmpty()) {
                parts.add(this.ids);
            }
            return new WildcardPermission(parts, null);
        }
    }
}

