/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.data;

import com.sap.sailing.datamining.Activator;
import com.sap.sailing.datamining.SailingClusterGroups;
import com.sap.sailing.datamining.data.HasLeaderboardContext;
import com.sap.sailing.datamining.data.HasRaceResultOfCompetitorContext;
import com.sap.sailing.datamining.data.HasTrackedRaceContext;
import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Leg;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Tack;
import com.sap.sailing.domain.common.scalablevalue.impl.ScalableSpeed;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.caching.LeaderboardDTOCalculationReuseCache;
import com.sap.sailing.domain.polars.PolarDataService;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.TrackedLegOfCompetitor;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sailing.domain.tracking.WindWithConfidence;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.scalablevalue.ScalableValue;
import com.sap.sse.datamining.data.Cluster;
import com.sap.sse.datamining.shared.impl.dto.ClusterDTO;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RaceResultOfCompetitorWithContext
implements HasRaceResultOfCompetitorContext {
    private static final Logger logger = Logger.getLogger(RaceResultOfCompetitorWithContext.class.getName());
    private final HasLeaderboardContext leaderboardWithContext;
    private final RaceColumn raceColumn;
    private final Competitor competitor;
    private final PolarDataService polarDataService;
    private final HasTrackedRaceContext trackedRaceContext;

    public RaceResultOfCompetitorWithContext(HasLeaderboardContext leaderboardWithContext, RaceColumn raceColumn, Competitor competitor, PolarDataService polarDataService, HasTrackedRaceContext trackedRaceContext) {
        this.leaderboardWithContext = leaderboardWithContext;
        this.raceColumn = raceColumn;
        this.competitor = competitor;
        this.polarDataService = polarDataService;
        this.trackedRaceContext = trackedRaceContext;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.competitor == null ? 0 : this.competitor.hashCode());
        result = 31 * result + (this.leaderboardWithContext == null ? 0 : this.leaderboardWithContext.getLeaderboard().hashCode());
        result = 31 * result + (this.raceColumn == null ? 0 : this.raceColumn.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RaceResultOfCompetitorWithContext other = (RaceResultOfCompetitorWithContext)obj;
        if (this.competitor == null ? other.competitor != null : !this.competitor.equals(other.competitor)) {
            return false;
        }
        if (this.leaderboardWithContext == null ? other.leaderboardWithContext != null : !this.leaderboardWithContext.getLeaderboard().equals(other.leaderboardWithContext.getLeaderboard())) {
            return false;
        }
        return !(this.raceColumn == null ? other.raceColumn != null : !this.raceColumn.equals(other.raceColumn));
    }

    @Override
    public HasLeaderboardContext getLeaderboardContext() {
        return this.leaderboardWithContext;
    }

    @Override
    public HasTrackedRaceContext getTrackedRaceContext() {
        return this.trackedRaceContext;
    }

    private Leaderboard getLeaderboard() {
        return this.getLeaderboardContext().getLeaderboard();
    }

    @Override
    public Competitor getCompetitor() {
        return this.competitor;
    }

    @Override
    public Boat getBoat() {
        Boat boatOfCompetitor = this.getTrackedRaceContext().getTrackedRace().getBoatOfCompetitor(this.getCompetitor());
        return boatOfCompetitor;
    }

    @Override
    public String getRegattaName() {
        Leaderboard leaderboard = this.getLeaderboard();
        String result = leaderboard.getName();
        return result;
    }

    @Override
    public ClusterDTO getPercentageClusterForRelativeScore() {
        Double relativeScore = this.getRelativeRank();
        if (relativeScore == null) {
            return null;
        }
        SailingClusterGroups clusterGroups = Activator.getClusterGroups();
        Cluster cluster = clusterGroups.getPercentageClusterGroup().getClusterFor((Serializable)relativeScore);
        return new ClusterDTO(clusterGroups.getPercentageClusterFormatter().format(cluster));
    }

    @Override
    public int getAverageWindSpeedInRoundedBeaufort() {
        Speed exactResult = this.getAverageWindSpeed();
        return (int)Math.round(exactResult.getBeaufort());
    }

    private Speed getAverageWindSpeed() {
        Speed result;
        TrackedRace trackedRace = this.raceColumn.getTrackedRace(this.getCompetitor());
        if (trackedRace == null) {
            result = null;
        } else {
            ScalableSpeed[] windSpeedSum = new ScalableSpeed[]{new ScalableSpeed(Speed.NULL)};
            long[] count = new long[1];
            List legs = trackedRace.getRace().getCourse().getLegs();
            if (legs.isEmpty()) {
                result = null;
            } else {
                Leg firstLeg = (Leg)legs.get(0);
                Leg lastLeg = (Leg)legs.get(legs.size() - 1);
                GPSFixTrack track = trackedRace.getTrack(this.getCompetitor());
                TimePoint started = trackedRace.getTrackedLeg(this.getCompetitor(), firstLeg).getStartTime();
                TimePoint finished = trackedRace.getTrackedLeg(this.getCompetitor(), lastLeg).getFinishTime();
                TimePoint from = started == null ? trackedRace.getStartOfRace() : started;
                TimePoint to = finished == null ? trackedRace.getEndOfRace() : finished;
                TimePoint timePoint = from;
                while (!timePoint.after(to)) {
                    Position position = track != null ? track.getEstimatedPosition(timePoint, false) : trackedRace.getCenterOfCourse(timePoint);
                    WindWithConfidence wind = trackedRace.getWindWithConfidence(position, timePoint);
                    if (wind != null) {
                        if (wind.useSpeed()) {
                            windSpeedSum[0] = windSpeedSum[0].add((ScalableValue)new ScalableSpeed((Speed)wind.getObject()));
                            count[0] = count[0] + 1L;
                        } else if (!track.hasDirectionChange(timePoint, 10.0)) {
                            SpeedWithBearing cog = track.getEstimatedSpeed(timePoint);
                            TrackedLegOfCompetitor currentLeg = trackedRace.getCurrentLeg(this.competitor, timePoint);
                            if (currentLeg != null) {
                                try {
                                    Set estimatedWindSpeeds;
                                    LegType legType = trackedRace.getTrackedLeg(currentLeg.getLeg()).getLegType(timePoint);
                                    Tack tack = trackedRace.getTack(this.competitor, timePoint);
                                    if (tack != null && !(estimatedWindSpeeds = this.polarDataService.getAverageTrueWindSpeedAndAngleCandidates(trackedRace.getRace().getBoatClass(), (Speed)cog, legType, tack)).isEmpty()) {
                                        estimatedWindSpeeds.stream().max((a, b) -> (int)Math.signum(a.getConfidence() - b.getConfidence())).ifPresent(swbwc -> {
                                            scalableSpeedArray[0] = windSpeedSum[0].add((ScalableValue)new ScalableSpeed((Speed)swbwc.getObject()));
                                            lArray[0] = count[0] + 1L;
                                        });
                                    }
                                }
                                catch (NoWindException e) {
                                    logger.log(Level.FINEST, "Can't determine wind direction, so no tack nor leg type known", e);
                                }
                            }
                        }
                    }
                    timePoint = timePoint.plus(Duration.ONE_MINUTE);
                }
                result = count[0] > 0L ? windSpeedSum[0].divide((double)count[0]) : null;
            }
        }
        return result;
    }

    @Override
    public Double getRelativeRank() {
        double competitorCountInRace;
        Leaderboard leaderboard = this.getLeaderboard();
        TimePoint now = MillisecondsTimePoint.now();
        TrackedRace trackedRace = this.raceColumn.getTrackedRace(this.competitor);
        double highest = -1000.0;
        double lowest = 1000.0;
        if (trackedRace != null) {
            competitorCountInRace = Util.size((Iterable)trackedRace.getRace().getCompetitors());
        } else {
            double maxNonPenaltyScoreInColumn = 0.0;
            LeaderboardDTOCalculationReuseCache cache = new LeaderboardDTOCalculationReuseCache(now);
            for (Competitor c : leaderboard.getCompetitors()) {
                MaxPointsReason maxPointsReason = leaderboard.getMaxPointsReason(c, this.raceColumn, now);
                if (maxPointsReason == null || maxPointsReason != MaxPointsReason.NONE) continue;
                Double totalPoints = leaderboard.getTotalPoints(c, this.raceColumn, now, (WindLegTypeAndLegBearingAndORCPerformanceCurveCache)cache);
                if (leaderboard.getScoringScheme().isHigherBetter()) {
                    if (totalPoints > highest) {
                        highest = totalPoints;
                    }
                    if (totalPoints < lowest) {
                        lowest = totalPoints;
                    }
                    double diff = highest - lowest + 1.0;
                    if (totalPoints == null || !(maxNonPenaltyScoreInColumn < diff)) continue;
                    maxNonPenaltyScoreInColumn = diff;
                    continue;
                }
                if (totalPoints != null && maxNonPenaltyScoreInColumn < totalPoints) {
                    maxNonPenaltyScoreInColumn = totalPoints;
                }
                if (totalPoints != null) continue;
                maxNonPenaltyScoreInColumn += 1.0;
            }
            competitorCountInRace = maxNonPenaltyScoreInColumn;
        }
        Double points = leaderboard.getTotalPoints(this.competitor, this.raceColumn, now);
        if (points != null && competitorCountInRace != 0.0) {
            double relativeLowPoints = leaderboard.getScoringScheme().isHigherBetter() ? leaderboard.getScoringScheme().getScoreForRank(leaderboard, this.raceColumn, this.competitor, 1, () -> Util.size((Iterable)this.raceColumn.getAllCompetitors()), leaderboard.getNumberOfCompetitorsInLeaderboardFetcher(), now) - points : points;
            double result = relativeLowPoints / competitorCountInRace;
            return result;
        }
        return null;
    }

    @Override
    public Double getAbsoluteRank() {
        return this.getLeaderboard().getTotalPoints(this.competitor, this.raceColumn, MillisecondsTimePoint.now());
    }

    @Override
    public MaxPointsReason getMaxPointsReason() {
        return this.getLeaderboard().getMaxPointsReason(this.competitor, this.raceColumn, MillisecondsTimePoint.now());
    }

    @Override
    public boolean isDiscarded() {
        return this.getTrackedRaceContext().getLeaderboardContext().getLeaderboard().isDiscarded(this.competitor, this.getTrackedRaceContext().getRaceColumn(), MillisecondsTimePoint.now());
    }

    @Override
    public Boolean isPodiumFinish() {
        Leaderboard leaderboard = this.getLeaderboard();
        TimePoint now = MillisecondsTimePoint.now();
        double points = leaderboard.getTotalPoints(this.competitor, this.raceColumn, now);
        if (leaderboard.getScoringScheme().isHigherBetter()) {
            double competitorCount = Util.size((Iterable)leaderboard.getCompetitors());
            if (points >= competitorCount - 2.05) {
                return true;
            }
            return false;
        }
        if (points <= 3.05) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean isWin() {
        TimePoint now = MillisecondsTimePoint.now();
        return this.getLeaderboard().isWin(this.competitor, this.raceColumn, now);
    }
}

