/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.components.aggregators;

import com.sap.sailing.datamining.impl.components.aggregators.AbstractParallelSumAggregationProcessor;
import com.sap.sse.datamining.components.AggregationProcessorDefinition;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.GroupedDataEntry;
import com.sap.sse.datamining.impl.components.aggregators.AbstractParallelComparableMaxAggregationProcessor;
import com.sap.sse.datamining.impl.components.aggregators.AbstractParallelComparableMinAggregationProcessor;
import com.sap.sse.datamining.impl.components.aggregators.AbstractParallelGroupedDataStoringAggregationProcessor;
import com.sap.sse.datamining.shared.GroupKey;
import com.sap.sse.datamining.shared.data.AverageWithStats;
import com.sap.sse.datamining.shared.impl.AverageWithStatsImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public abstract class AbstractParallelAverageAggregationProcessor<T extends Comparable<T>>
extends AbstractParallelGroupedDataStoringAggregationProcessor<T, AverageWithStats<T>> {
    private final AbstractParallelSumAggregationProcessor<T> sumAggregationProcessor;
    private final AbstractParallelComparableMinAggregationProcessor<T> minAggregationProcessor;
    private final AbstractParallelComparableMaxAggregationProcessor<T> maxAggregationProcessor;
    private final Map<GroupKey, Integer> elementAmountPerKey = new HashMap<GroupKey, Integer>();

    public AbstractParallelAverageAggregationProcessor(ExecutorService executor, Collection<Processor<Map<GroupKey, AverageWithStats<T>>, ?>> resultReceivers, AbstractParallelSumAggregationProcessor<T> sumAggregationProcessor, AbstractParallelComparableMinAggregationProcessor<T> minAggregationProcessor, AbstractParallelComparableMaxAggregationProcessor<T> maxAggregationProcessor) {
        super(executor, resultReceivers, "Average");
        this.sumAggregationProcessor = sumAggregationProcessor;
        this.minAggregationProcessor = minAggregationProcessor;
        this.maxAggregationProcessor = maxAggregationProcessor;
    }

    public abstract AggregationProcessorDefinition<T, AverageWithStats<T>> getProcessorDefinition();

    protected void storeElement(GroupedDataEntry<T> element) {
        this.incrementElementAmount(element);
        this.sumAggregationProcessor.handleElement(element);
        this.minAggregationProcessor.handleElement(element);
        this.maxAggregationProcessor.handleElement(element);
    }

    private void incrementElementAmount(GroupedDataEntry<T> element) {
        GroupKey key = element.getKey();
        if (!this.elementAmountPerKey.containsKey(key)) {
            this.elementAmountPerKey.put(key, 0);
        }
        Integer currentAmount = this.elementAmountPerKey.get(key);
        this.elementAmountPerKey.put(key, currentAmount + 1);
    }

    protected abstract T divide(T var1, long var2);

    protected Map<GroupKey, AverageWithStats<T>> aggregateResult() {
        HashMap<GroupKey, AverageWithStats<T>> result = new HashMap<GroupKey, AverageWithStats<T>>();
        Object sumAggregation = this.sumAggregationProcessor.getResult();
        Map minAggregation = this.minAggregationProcessor.getResult();
        Map maxAggregation = this.maxAggregationProcessor.getResult();
        for (Map.Entry sumAggregationEntry : sumAggregation.entrySet()) {
            if (this.isAborted()) break;
            GroupKey key = (GroupKey)sumAggregationEntry.getKey();
            result.put(key, (AverageWithStats<T>)new AverageWithStatsImpl((Object)this.divide((Comparable)sumAggregationEntry.getValue(), this.elementAmountPerKey.get(key).longValue()), (Object)((Comparable)minAggregation.get(key)), (Object)((Comparable)maxAggregation.get(key)), null, null, this.elementAmountPerKey.get(key).longValue(), this.getProcessorDefinition().getExtractedType().getName()));
        }
        return result;
    }
}

