/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.components;

import com.sap.sailing.datamining.data.HasGPSFixContext;
import com.sap.sailing.datamining.data.HasTrackedLegOfCompetitorContext;
import com.sap.sailing.datamining.impl.data.GPSFixWithContext;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.TrackedLegOfCompetitor;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.AbstractRetrievalProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutorService;

public class GPSFixRetrievalProcessor
extends AbstractRetrievalProcessor<HasTrackedLegOfCompetitorContext, HasGPSFixContext> {
    public GPSFixRetrievalProcessor(ExecutorService executor, Collection<Processor<HasGPSFixContext, ?>> resultReceivers, int retrievalLevel, String retrievedDataTypeMessageKey) {
        super(HasTrackedLegOfCompetitorContext.class, HasGPSFixContext.class, executor, resultReceivers, retrievalLevel, retrievedDataTypeMessageKey);
    }

    protected Iterable<HasGPSFixContext> retrieveData(HasTrackedLegOfCompetitorContext element) {
        ArrayList<HasGPSFixContext> gpsFixesWithContext;
        block5: {
            gpsFixesWithContext = new ArrayList<HasGPSFixContext>();
            GPSFixTrack competitorTrack = element.getTrackedLegContext().getTrackedRaceContext().getTrackedRace().getTrack(element.getCompetitor());
            competitorTrack.lockForRead();
            try {
                TrackedLegOfCompetitor trackedLegOfCompetitor = element.getTrackedLegOfCompetitor();
                if (trackedLegOfCompetitor.getStartTime() == null || trackedLegOfCompetitor.getFinishTime() == null) break block5;
                for (GPSFixMoving gpsFix : competitorTrack.getFixes(trackedLegOfCompetitor.getStartTime(), true, trackedLegOfCompetitor.getFinishTime(), true)) {
                    if (this.isAborted()) {
                        break;
                    }
                    GPSFixWithContext gpsFixWithContext = new GPSFixWithContext(element, gpsFix);
                    gpsFixesWithContext.add(gpsFixWithContext);
                }
            }
            finally {
                competitorTrack.unlockAfterRead();
            }
        }
        return gpsFixesWithContext;
    }
}

