/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.impl;

import com.sap.sailing.domain.abstractlog.AbstractLogEvent;
import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogResolver;
import com.sap.sailing.domain.abstractlog.race.state.ReadonlyRaceState;
import com.sap.sailing.domain.abstractlog.race.state.impl.ReadonlyRaceStateImpl;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLog;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogCloseOpenEndedDeviceMappingEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogDefineMarkEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogDeviceMarkMappingEventImpl;
import com.sap.sailing.domain.base.ControlPoint;
import com.sap.sailing.domain.base.ControlPointWithTwoMarks;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.CourseBase;
import com.sap.sailing.domain.base.DomainFactory;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.base.impl.ControlPointWithTwoMarksImpl;
import com.sap.sailing.domain.base.impl.CourseDataImpl;
import com.sap.sailing.domain.base.impl.WaypointImpl;
import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.common.PassingInstruction;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.impl.GPSFixImpl;
import com.sap.sailing.domain.coursetemplate.CommonMarkProperties;
import com.sap.sailing.domain.coursetemplate.ControlPointTemplate;
import com.sap.sailing.domain.coursetemplate.ControlPointWithMarkConfiguration;
import com.sap.sailing.domain.coursetemplate.CourseConfiguration;
import com.sap.sailing.domain.coursetemplate.CourseTemplate;
import com.sap.sailing.domain.coursetemplate.CourseTemplateCompatibilityChecker;
import com.sap.sailing.domain.coursetemplate.FixedPositioning;
import com.sap.sailing.domain.coursetemplate.FreestyleMarkConfiguration;
import com.sap.sailing.domain.coursetemplate.FreestyleMarkProperties;
import com.sap.sailing.domain.coursetemplate.MarkConfiguration;
import com.sap.sailing.domain.coursetemplate.MarkConfigurationRequestAnnotation;
import com.sap.sailing.domain.coursetemplate.MarkConfigurationResponseAnnotation;
import com.sap.sailing.domain.coursetemplate.MarkConfigurationVisitor;
import com.sap.sailing.domain.coursetemplate.MarkPairWithConfiguration;
import com.sap.sailing.domain.coursetemplate.MarkProperties;
import com.sap.sailing.domain.coursetemplate.MarkPropertiesBasedMarkConfiguration;
import com.sap.sailing.domain.coursetemplate.MarkRole;
import com.sap.sailing.domain.coursetemplate.MarkRolePair;
import com.sap.sailing.domain.coursetemplate.MarkTemplate;
import com.sap.sailing.domain.coursetemplate.MarkTemplateBasedMarkConfiguration;
import com.sap.sailing.domain.coursetemplate.Positioning;
import com.sap.sailing.domain.coursetemplate.PositioningVisitor;
import com.sap.sailing.domain.coursetemplate.RegattaMarkConfiguration;
import com.sap.sailing.domain.coursetemplate.TrackingDeviceBasedPositioning;
import com.sap.sailing.domain.coursetemplate.WaypointTemplate;
import com.sap.sailing.domain.coursetemplate.WaypointWithMarkConfiguration;
import com.sap.sailing.domain.coursetemplate.impl.CourseConfigurationImpl;
import com.sap.sailing.domain.coursetemplate.impl.FreestyleMarkConfigurationImpl;
import com.sap.sailing.domain.coursetemplate.impl.FreestyleMarkPropertiesImpl;
import com.sap.sailing.domain.coursetemplate.impl.MarkConfigurationRequestAnnotationImpl;
import com.sap.sailing.domain.coursetemplate.impl.MarkPairWithConfigurationImpl;
import com.sap.sailing.domain.coursetemplate.impl.MarkPropertiesBasedMarkConfigurationImpl;
import com.sap.sailing.domain.coursetemplate.impl.MarkTemplateBasedMarkConfigurationImpl;
import com.sap.sailing.domain.coursetemplate.impl.RegattaMarkConfigurationImpl;
import com.sap.sailing.domain.coursetemplate.impl.WaypointTemplateImpl;
import com.sap.sailing.domain.coursetemplate.impl.WaypointWithMarkConfigurationImpl;
import com.sap.sailing.domain.racelog.tracking.SensorFixStore;
import com.sap.sailing.domain.racelogtracking.DeviceMappingWithRegattaLogEvent;
import com.sap.sailing.domain.racelogtracking.impl.PingDeviceIdentifierImpl;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.server.gateway.deserialization.impl.CourseConfigurationBuilder;
import com.sap.sailing.server.interfaces.CourseAndMarkConfigurationFactory;
import com.sap.sailing.shared.server.SharedSailingData;
import com.sap.sse.common.NoCorrespondingServiceRegisteredException;
import com.sap.sse.common.RepeatablePart;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Timed;
import com.sap.sse.common.TransformationException;
import com.sap.sse.common.Util;
import com.sap.sse.replication.FullyInitializedReplicableTracker;
import com.sap.sse.security.shared.impl.UserGroup;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.shiro.authz.AuthorizationException;

public class CourseAndMarkConfigurationFactoryImpl
implements CourseAndMarkConfigurationFactory {
    private static final Logger logger = Logger.getLogger(CourseAndMarkConfigurationFactoryImpl.class.getName());
    private final FullyInitializedReplicableTracker<SharedSailingData> sharedSailingDataTracker;
    private final SensorFixStore sensorFixStore;
    private final Function<DeviceIdentifier, GPSFix> lastKnownPositionResolver;
    private final RaceLogResolver raceLogResolver;
    private final DomainFactory domainFactory;

    public CourseAndMarkConfigurationFactoryImpl(FullyInitializedReplicableTracker<SharedSailingData> sharedSailingDataTracker, SensorFixStore sensorFixStore, RaceLogResolver raceLogResolver, DomainFactory domainFactory) {
        this.sharedSailingDataTracker = sharedSailingDataTracker;
        this.domainFactory = domainFactory;
        this.sensorFixStore = sensorFixStore;
        this.raceLogResolver = raceLogResolver;
        this.lastKnownPositionResolver = identifier -> {
            GPSFix lastPosition = null;
            try {
                Map lastFix = sensorFixStore.getFixLastReceived(Collections.singleton(identifier));
                Timed t = (Timed)lastFix.get(identifier);
                if (t instanceof GPSFix) {
                    lastPosition = (GPSFix)t;
                }
            }
            catch (NoCorrespondingServiceRegisteredException | TransformationException e) {
                logger.log(Level.WARNING, "Could not load associated fix for device " + identifier, e);
            }
            return lastPosition;
        };
    }

    private SharedSailingData getSharedSailingData() {
        SharedSailingData result;
        try {
            result = (SharedSailingData)this.sharedSailingDataTracker.getInitializedService(0L);
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, "Interrupted while waiting for a fully initialized SharedSailingData service; continuing with null, probably causing a NullPointerException along the way", e);
            result = null;
        }
        return result;
    }

    private CourseTemplate resolveCourseTemplateSafe(CourseBase course) {
        CourseTemplate courseTemplateOrNull;
        try {
            courseTemplateOrNull = this.resolveCourseTemplate(course);
        }
        catch (AuthorizationException e) {
            courseTemplateOrNull = null;
        }
        return courseTemplateOrNull;
    }

    public CourseTemplate resolveCourseTemplate(CourseBase course) {
        CourseTemplate result = course.getOriginatingCourseTemplateIdOrNull() == null ? null : this.getSharedSailingData().getCourseTemplateById(course.getOriginatingCourseTemplateIdOrNull());
        return result;
    }

    private CourseConfiguration<MarkConfigurationRequestAnnotation> handleSaveToInventory(CourseConfiguration<MarkConfigurationRequestAnnotation> courseConfiguration, Optional<UserGroup> optionalNonDefaultGroupOwnership) {
        HashMap effectiveConfigurations = new HashMap();
        for (MarkConfiguration markConfiguration : courseConfiguration.getAllMarks()) {
            if (((MarkConfigurationRequestAnnotation)markConfiguration.getAnnotationInfo()).isStoreToInventory()) {
                MarkPropertiesBasedMarkConfigurationImpl effectiveMarkConfiguration;
                MarkProperties markPropertiesInInventory;
                Iterable<Object> tags;
                CommonMarkProperties effectiveProperties;
                MarkProperties markPropertiesOrNull = markConfiguration.getOptionalMarkProperties();
                Positioning positioningOrNull = ((MarkConfigurationRequestAnnotation)markConfiguration.getAnnotationInfo()).getOptionalPositioning();
                if (markPropertiesOrNull == null) {
                    effectiveProperties = markConfiguration.getEffectiveProperties();
                    tags = Collections.emptySet();
                    tags = effectiveProperties instanceof FreestyleMarkProperties ? ((FreestyleMarkProperties)effectiveProperties).getTags() : Collections.emptySet();
                    markPropertiesInInventory = this.getSharedSailingData().createMarkProperties(effectiveProperties, tags, optionalNonDefaultGroupOwnership);
                } else {
                    effectiveProperties = markConfiguration.getEffectiveProperties();
                    tags = effectiveProperties instanceof FreestyleMarkProperties ? ((FreestyleMarkProperties)effectiveProperties).getTags() : Collections.emptySet();
                    markPropertiesInInventory = markPropertiesOrNull;
                    this.getSharedSailingData().updateMarkProperties(markPropertiesInInventory.getId(), effectiveProperties, positioningOrNull, tags);
                }
                if (positioningOrNull != null) {
                    positioningOrNull.accept((PositioningVisitor)new PositioningVisitor<Void>(){

                        public Void visit(FixedPositioning fixedPositioning) {
                            CourseAndMarkConfigurationFactoryImpl.this.getSharedSailingData().setFixedPositionForMarkProperties(markPropertiesInInventory, fixedPositioning.getFixedPosition());
                            return null;
                        }

                        public Void visit(TrackingDeviceBasedPositioning trackingDeviceBasedPositioning) {
                            CourseAndMarkConfigurationFactoryImpl.this.getSharedSailingData().setTrackingDeviceIdentifierForMarkProperties(markPropertiesInInventory, trackingDeviceBasedPositioning.getDeviceIdentifier());
                            return null;
                        }
                    });
                }
                if (markConfiguration instanceof RegattaMarkConfiguration) {
                    RegattaMarkConfiguration regattaMarkConfiguration = (RegattaMarkConfiguration)markConfiguration;
                    effectiveMarkConfiguration = new RegattaMarkConfigurationImpl(regattaMarkConfiguration.getMark(), (Object)new MarkConfigurationRequestAnnotationImpl(true, ((MarkConfigurationRequestAnnotation)regattaMarkConfiguration.getAnnotationInfo()).getOptionalPositioning(), null), regattaMarkConfiguration.getOptionalMarkTemplate(), markPropertiesInInventory);
                } else {
                    effectiveMarkConfiguration = new MarkPropertiesBasedMarkConfigurationImpl(markPropertiesInInventory, markConfiguration.getOptionalMarkTemplate(), (Object)new MarkConfigurationRequestAnnotationImpl(true, markPropertiesInInventory.getPositioningInformation(), null));
                }
                effectiveConfigurations.put(markConfiguration, effectiveMarkConfiguration);
                continue;
            }
            effectiveConfigurations.put(markConfiguration, markConfiguration);
        }
        CourseConfigurationToCourseConfigurationMapper waypointConfigurationMapper = new CourseConfigurationToCourseConfigurationMapper(courseConfiguration.getWaypoints(), courseConfiguration.getAssociatedRoles(), effectiveConfigurations);
        return new CourseConfigurationImpl(courseConfiguration.getOptionalCourseTemplate(), new HashSet(effectiveConfigurations.values()), waypointConfigurationMapper.explicitAssociatedRoles, waypointConfigurationMapper.effectiveWaypoints, courseConfiguration.getRepeatablePart(), courseConfiguration.getNumberOfLaps(), courseConfiguration.getName(), courseConfiguration.getShortName(), courseConfiguration.getOptionalImageURL());
    }

    private MarkRole resolveMarkRoleByID(UUID markRoleId, CourseTemplate optionalCourseTemplate) {
        MarkRole result;
        if (markRoleId == null) {
            result = null;
        } else {
            MarkRole markRole = null;
            if (optionalCourseTemplate != null) {
                markRole = optionalCourseTemplate.getMarkRoleByIdIfContainedInCourseTemplate(markRoleId);
            }
            if (markRole == null) {
                markRole = this.getSharedSailingData().getMarkRoleById(markRoleId);
            }
            result = markRole;
        }
        return result;
    }

    public CourseConfiguration<MarkConfigurationRequestAnnotation> createCourseTemplateAndUpdatedConfiguration(CourseConfiguration<MarkConfigurationRequestAnnotation> courseConfiguration, Iterable<String> tags, Optional<UserGroup> optionalNonDefaultGroupOwnership) {
        HashSet<MarkRole> allMarkRolesInNewCourseTemplate = new HashSet<MarkRole>(courseConfiguration.getAssociatedRoles().values());
        CourseConfiguration<MarkConfigurationRequestAnnotation> courseConfigurationAfterInventory = this.handleSaveToInventory(courseConfiguration, optionalNonDefaultGroupOwnership);
        HashMap<MarkConfiguration, MarkRole> markRolesByMarkConfigurations = new HashMap<MarkConfiguration, MarkRole>();
        HashMap marksConfigurationsMapping = new HashMap();
        HashSet<MarkTemplate> allMarkTemplatesInNewCourseTemplate = new HashSet<MarkTemplate>();
        HashMap<MarkTemplate, MarkRole> defaultMarkRolesForMarkTemplates = new HashMap<MarkTemplate, MarkRole>();
        HashMap<MarkRole, MarkTemplate> defaultMarkTemplatesForMarkRoles = new HashMap<MarkRole, MarkTemplate>();
        for (MarkConfiguration markConfiguration : courseConfigurationAfterInventory.getAllMarks()) {
            MarkConfigurationRequestAnnotation.MarkRoleCreationRequest optionalMarkRoleCreationRequest;
            Util.Pair effectiveConfigurationAndEffectiveMarkTemplate = (Util.Pair)markConfiguration.accept((MarkConfigurationVisitor)new MarkConfigurationVisitor<Util.Pair<MarkConfiguration<MarkConfigurationRequestAnnotation>, MarkTemplate>, MarkConfigurationRequestAnnotation>(){

                public Util.Pair<MarkConfiguration<MarkConfigurationRequestAnnotation>, MarkTemplate> visit(FreestyleMarkConfiguration<MarkConfigurationRequestAnnotation> markConfiguration) {
                    MarkTemplate effectiveMarkTemplate = CourseAndMarkConfigurationFactoryImpl.this.getEffectiveMarkTemplate((MarkConfiguration<MarkConfigurationRequestAnnotation>)markConfiguration);
                    MarkProperties markPropertiesOrNull = markConfiguration.getOptionalMarkProperties();
                    Object effectiveConfiguration = markPropertiesOrNull != null ? (markPropertiesOrNull.hasEqualAppeareanceWith((CommonMarkProperties)effectiveMarkTemplate) ? new MarkPropertiesBasedMarkConfigurationImpl(markPropertiesOrNull, effectiveMarkTemplate, (Object)((MarkConfigurationRequestAnnotation)markConfiguration.getAnnotationInfo())) : new FreestyleMarkConfigurationImpl(effectiveMarkTemplate, markPropertiesOrNull, (FreestyleMarkProperties)new FreestyleMarkPropertiesImpl((CommonMarkProperties)effectiveMarkTemplate, null), (Object)((MarkConfigurationRequestAnnotation)markConfiguration.getAnnotationInfo()))) : new MarkTemplateBasedMarkConfigurationImpl(effectiveMarkTemplate, (Object)((MarkConfigurationRequestAnnotation)markConfiguration.getAnnotationInfo()));
                    return new Util.Pair(effectiveConfiguration, (Object)effectiveMarkTemplate);
                }

                public Util.Pair<MarkConfiguration<MarkConfigurationRequestAnnotation>, MarkTemplate> visit(MarkPropertiesBasedMarkConfiguration<MarkConfigurationRequestAnnotation> markConfiguration) {
                    return new Util.Pair(markConfiguration, (Object)CourseAndMarkConfigurationFactoryImpl.this.getEffectiveMarkTemplate((MarkConfiguration<MarkConfigurationRequestAnnotation>)markConfiguration));
                }

                public Util.Pair<MarkConfiguration<MarkConfigurationRequestAnnotation>, MarkTemplate> visit(MarkTemplateBasedMarkConfiguration<MarkConfigurationRequestAnnotation> markConfiguration) {
                    MarkTemplateBasedMarkConfigurationImpl effectiveConfiguration = new MarkTemplateBasedMarkConfigurationImpl(markConfiguration.getOptionalMarkTemplate(), null);
                    MarkTemplate effectiveMarkTemplate = effectiveConfiguration.getOptionalMarkTemplate();
                    return new Util.Pair((Object)effectiveConfiguration, (Object)effectiveMarkTemplate);
                }

                public Util.Pair<MarkConfiguration<MarkConfigurationRequestAnnotation>, MarkTemplate> visit(RegattaMarkConfiguration<MarkConfigurationRequestAnnotation> markConfiguration) {
                    return new Util.Pair(markConfiguration, (Object)CourseAndMarkConfigurationFactoryImpl.this.getEffectiveMarkTemplate((MarkConfiguration<MarkConfigurationRequestAnnotation>)markConfiguration));
                }
            });
            MarkConfiguration effectiveConfiguration = (MarkConfiguration)effectiveConfigurationAndEffectiveMarkTemplate.getA();
            MarkTemplate effectiveMarkTemplate = (MarkTemplate)effectiveConfigurationAndEffectiveMarkTemplate.getB();
            allMarkTemplatesInNewCourseTemplate.add(effectiveMarkTemplate);
            MarkRole effectiveMarkRole = (MarkRole)courseConfigurationAfterInventory.getAssociatedRoles().get(markConfiguration);
            if (effectiveMarkRole == null && (optionalMarkRoleCreationRequest = ((MarkConfigurationRequestAnnotation)markConfiguration.getAnnotationInfo()).getOptionalMarkRoleCreationRequest()) != null) {
                effectiveMarkRole = this.getOrCreateMarkRole(allMarkRolesInNewCourseTemplate, optionalMarkRoleCreationRequest);
                allMarkRolesInNewCourseTemplate.add(effectiveMarkRole);
            }
            assert (effectiveMarkTemplate != null);
            if (effectiveMarkRole != null) {
                defaultMarkRolesForMarkTemplates.put(effectiveMarkTemplate, effectiveMarkRole);
                defaultMarkTemplatesForMarkRoles.put(effectiveMarkRole, effectiveMarkTemplate);
            }
            markRolesByMarkConfigurations.put(markConfiguration, effectiveMarkRole);
            marksConfigurationsMapping.put(markConfiguration, effectiveConfiguration);
        }
        final MarkRolePair.MarkRolePairFactory markRolePairFactory = new MarkRolePair.MarkRolePairFactory();
        CourseConfigurationToCourseConfigurationMapper waypointConfigurationMapper = new CourseConfigurationToCourseConfigurationMapper(courseConfigurationAfterInventory.getWaypoints(), courseConfigurationAfterInventory.getAssociatedRoles(), marksConfigurationsMapping);
        this.recordUsagesForMarkProperties(waypointConfigurationMapper.effectiveWaypoints, waypointConfigurationMapper.allAssociatedRoles);
        CourseSequenceMapper<ControlPointTemplate, MarkRole, WaypointTemplate, MarkConfigurationRequestAnnotation> waypointTemplateMapper = new CourseSequenceMapper<ControlPointTemplate, MarkRole, WaypointTemplate, MarkConfigurationRequestAnnotation>(this, courseConfigurationAfterInventory.getWaypoints(), courseConfigurationAfterInventory.getAssociatedRoles(), markRolesByMarkConfigurations){

            @Override
            protected ControlPointTemplate createMarkPair(MarkRole left, MarkRole right, String name, String shortName) {
                return markRolePairFactory.create(name, shortName, left, right);
            }

            @Override
            protected WaypointTemplate createWaypoint(ControlPointTemplate controlPoint, PassingInstruction passingInstruction) {
                return new WaypointTemplateImpl(controlPoint, passingInstruction);
            }
        };
        CourseTemplate newCourseTemplate = this.getSharedSailingData().createCourseTemplate(courseConfigurationAfterInventory.getName(), courseConfigurationAfterInventory.getShortName(), allMarkTemplatesInNewCourseTemplate, waypointTemplateMapper.effectiveWaypoints, defaultMarkRolesForMarkTemplates, defaultMarkTemplatesForMarkRoles, courseConfigurationAfterInventory.getRepeatablePart(), tags, courseConfigurationAfterInventory.getOptionalImageURL(), courseConfigurationAfterInventory.getNumberOfLaps());
        return new CourseConfigurationImpl(newCourseTemplate, new HashSet(marksConfigurationsMapping.values()), waypointConfigurationMapper.allAssociatedRoles, waypointConfigurationMapper.effectiveWaypoints, courseConfigurationAfterInventory.getRepeatablePart(), courseConfigurationAfterInventory.getNumberOfLaps(), courseConfigurationAfterInventory.getName(), courseConfigurationAfterInventory.getShortName(), courseConfigurationAfterInventory.getOptionalImageURL());
    }

    private MarkTemplate getEffectiveMarkTemplate(MarkConfiguration<MarkConfigurationRequestAnnotation> markConfiguration) {
        MarkTemplate markTemplateOrNull = markConfiguration.getOptionalMarkTemplate();
        MarkTemplate effectiveMarkTemplate = markTemplateOrNull != null && markTemplateOrNull.hasEqualAppeareanceWith(markConfiguration.getEffectiveProperties()) ? markTemplateOrNull : this.getSharedSailingData().createMarkTemplate(markConfiguration.getEffectiveProperties());
        return effectiveMarkTemplate;
    }

    private MarkRole getOrCreateMarkRole(Iterable<MarkRole> markRoles, MarkConfigurationRequestAnnotation.MarkRoleCreationRequest markRoleCreationRequest) {
        for (MarkRole markRole : markRoles) {
            if (!Util.equalsWithNull((Object)markRole.getName(), (Object)markRoleCreationRequest.getMarkRoleName()) || !Util.equalsWithNull((Object)markRole.getShortName(), (Object)markRoleCreationRequest.getMarkRoleShortName())) continue;
            return markRole;
        }
        return this.getSharedSailingData().createMarkRole(markRoleCreationRequest.getMarkRoleName(), markRoleCreationRequest.getMarkRoleShortName());
    }

    private <P> void recordUsagesForMarkProperties(Iterable<WaypointWithMarkConfiguration<P>> effectiveWaypoints, Map<MarkConfiguration<P>, MarkRole> allAssociatedRoles) {
        for (MarkConfiguration<P> markConfiguration : this.getAllMarkConfigurations(effectiveWaypoints)) {
            MarkTemplate markTemplateOrNull;
            MarkProperties markProperties = markConfiguration.getOptionalMarkProperties();
            if (markProperties == null) continue;
            MarkRole markRoleOrNull = allAssociatedRoles.get(markConfiguration);
            if (markRoleOrNull != null) {
                try {
                    this.getSharedSailingData().recordUsage(markProperties, markRoleOrNull);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Could not record usage for mark properties " + markProperties + " and role " + markRoleOrNull, e);
                }
            }
            if ((markTemplateOrNull = markConfiguration.getOptionalMarkTemplate()) == null) continue;
            try {
                this.getSharedSailingData().recordUsage(markTemplateOrNull, markProperties);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not record usage for mark properties " + markProperties + " and mark template " + markTemplateOrNull, e);
            }
        }
    }

    private <P> Iterable<MarkConfiguration<P>> getAllMarkConfigurations(Iterable<WaypointWithMarkConfiguration<P>> waypoints) {
        HashSet<MarkConfiguration<P>> result = new HashSet<MarkConfiguration<P>>();
        for (WaypointWithMarkConfiguration<P> waypoint : waypoints) {
            Util.addAll((Iterable)waypoint.getControlPoint().getMarkConfigurations(), result);
        }
        return result;
    }

    private void savePositioningToMark(Regatta regatta, Mark mark, Positioning optionalExplicitPositioning, MarkProperties optionalAssociatedMarkProperties, TimePoint timePointForDefinitionOfMarksAndDeviceMappings, AbstractLogEventAuthor author) {
        final Position[] position = new Position[1];
        final DeviceIdentifier[] deviceIdentifier = new DeviceIdentifier[1];
        Object effectivePositioning = optionalExplicitPositioning != null ? optionalExplicitPositioning : (optionalAssociatedMarkProperties != null && optionalAssociatedMarkProperties.getPositioningInformation() != null ? optionalAssociatedMarkProperties.getPositioningInformation() : null);
        if (effectivePositioning != null) {
            effectivePositioning.accept((PositioningVisitor)new PositioningVisitor<Void>(){

                public Void visit(FixedPositioning fixedPositioning) {
                    position[0] = fixedPositioning.getFixedPosition();
                    return null;
                }

                public Void visit(TrackingDeviceBasedPositioning trackingDeviceBasedPositioning) {
                    deviceIdentifier[0] = trackingDeviceBasedPositioning.getDeviceIdentifier();
                    return null;
                }
            });
        }
        if (position[0] != null ^ deviceIdentifier[0] != null) {
            DeviceMappingWithRegattaLogEvent existingDeviceMapping = CourseConfigurationBuilder.findMostRecentOrOngoingMapping((Regatta)regatta, (Mark)mark);
            boolean terminateOpenEndedDeviceMapping = false;
            if (deviceIdentifier[0] != null) {
                if (existingDeviceMapping == null || !deviceIdentifier[0].equals(existingDeviceMapping.getDevice()) || !existingDeviceMapping.getTimeRange().hasOpenEnd()) {
                    regatta.getRegattaLog().add((AbstractLogEvent)new RegattaLogDeviceMarkMappingEventImpl(timePointForDefinitionOfMarksAndDeviceMappings, author, mark, deviceIdentifier[0], timePointForDefinitionOfMarksAndDeviceMappings, null));
                    terminateOpenEndedDeviceMapping = true;
                }
            } else if (position[0] != null) {
                boolean update;
                if (existingDeviceMapping != null) {
                    if (!"PING".equals(existingDeviceMapping.getDevice().getIdentifierType())) {
                        update = true;
                        terminateOpenEndedDeviceMapping = true;
                    } else {
                        GPSFix lastFixOrNull = this.lastKnownPositionResolver.apply(existingDeviceMapping.getDevice());
                        Position lastPingedPositionOrNull = lastFixOrNull == null ? null : lastFixOrNull.getPosition();
                        update = lastPingedPositionOrNull == null || !lastPingedPositionOrNull.equals(position[0]);
                    }
                } else {
                    update = true;
                }
                if (update) {
                    PingDeviceIdentifierImpl pingIdentifier = new PingDeviceIdentifierImpl(UUID.randomUUID());
                    this.sensorFixStore.storeFix((DeviceIdentifier)pingIdentifier, (Timed)new GPSFixImpl(position[0], timePointForDefinitionOfMarksAndDeviceMappings));
                    regatta.getRegattaLog().add((AbstractLogEvent)new RegattaLogDeviceMarkMappingEventImpl(timePointForDefinitionOfMarksAndDeviceMappings, author, mark, (DeviceIdentifier)pingIdentifier, timePointForDefinitionOfMarksAndDeviceMappings, timePointForDefinitionOfMarksAndDeviceMappings));
                }
            }
            if (terminateOpenEndedDeviceMapping && existingDeviceMapping != null && existingDeviceMapping.getTimeRange().hasOpenEnd()) {
                regatta.getRegattaLog().add((AbstractLogEvent)new RegattaLogCloseOpenEndedDeviceMappingEventImpl(timePointForDefinitionOfMarksAndDeviceMappings, author, existingDeviceMapping.getRegattaLogEvent().getId(), timePointForDefinitionOfMarksAndDeviceMappings.minus(1L)));
            }
        }
    }

    public CourseBase createCourseFromConfigurationAndDefineMarksAsNeeded(Regatta regatta, CourseConfiguration<MarkConfigurationRequestAnnotation> courseConfiguration, TimePoint timePointForDefinitionOfMarksAndDeviceMappings, AbstractLogEventAuthor author, Optional<UserGroup> optionalNonDefaultGroupOwnership) {
        Iterable waypoints;
        CourseConfiguration<MarkConfigurationRequestAnnotation> courseConfigurationAfterInventory = this.handleSaveToInventory(courseConfiguration, optionalNonDefaultGroupOwnership);
        this.recordUsagesForMarkProperties(courseConfiguration.getWaypoints(), courseConfiguration.getAssociatedRoles());
        HashMap<MarkConfiguration, Mark> marksByMarkConfigurations = new HashMap<MarkConfiguration, Mark>();
        RegattaLog regattaLog = regatta.getRegattaLog();
        for (MarkConfiguration markConfiguration : courseConfigurationAfterInventory.getAllMarks()) {
            if (markConfiguration instanceof RegattaMarkConfiguration) {
                Mark mark = ((RegattaMarkConfiguration)markConfiguration).getMark();
                marksByMarkConfigurations.put(markConfiguration, mark);
                this.savePositioningToMark(regatta, mark, ((MarkConfigurationRequestAnnotation)markConfiguration.getAnnotationInfo()).getOptionalPositioning(), null, timePointForDefinitionOfMarksAndDeviceMappings, author);
                continue;
            }
            MarkTemplate optionalMarkTemplate = markConfiguration.getOptionalMarkTemplate();
            MarkProperties optionalMarkProperties = markConfiguration.getOptionalMarkProperties();
            CommonMarkProperties effectiveProperties = markConfiguration.getEffectiveProperties();
            Mark markToCreate = this.domainFactory.getOrCreateMark((Serializable)UUID.randomUUID(), effectiveProperties.getName(), effectiveProperties.getShortName(), effectiveProperties.getType(), effectiveProperties.getColor(), effectiveProperties.getShape(), effectiveProperties.getPattern(), optionalMarkTemplate == null ? null : optionalMarkTemplate.getId(), optionalMarkProperties == null ? null : optionalMarkProperties.getId());
            regattaLog.add((AbstractLogEvent)new RegattaLogDefineMarkEventImpl(timePointForDefinitionOfMarksAndDeviceMappings, author, timePointForDefinitionOfMarksAndDeviceMappings, (Serializable)UUID.randomUUID(), markToCreate));
            marksByMarkConfigurations.put(markConfiguration, markToCreate);
            this.savePositioningToMark(regatta, markToCreate, ((MarkConfigurationRequestAnnotation)markConfiguration.getAnnotationInfo()).getOptionalPositioning(), optionalMarkProperties, timePointForDefinitionOfMarksAndDeviceMappings, author);
        }
        CourseDataImpl course = new CourseDataImpl(courseConfigurationAfterInventory.getName(), courseConfigurationAfterInventory.getOptionalCourseTemplate() == null ? null : courseConfigurationAfterInventory.getOptionalCourseTemplate().getId());
        if (courseConfigurationAfterInventory.hasRepeatablePart()) {
            if (courseConfigurationAfterInventory.getNumberOfLaps() == null) {
                throw new IllegalStateException("A course with repeatable part requires a lap count");
            }
            waypoints = courseConfigurationAfterInventory.getWaypoints(courseConfigurationAfterInventory.getNumberOfLaps().intValue());
        } else {
            waypoints = courseConfigurationAfterInventory.getWaypoints();
        }
        CourseSequenceMapper<ControlPoint, Mark, Waypoint, MarkConfigurationRequestAnnotation> courseSequenceMapper = new CourseSequenceMapper<ControlPoint, Mark, Waypoint, MarkConfigurationRequestAnnotation>(this, waypoints, courseConfigurationAfterInventory.getAssociatedRoles(), marksByMarkConfigurations){

            @Override
            protected ControlPointWithTwoMarks createMarkPair(Mark left, Mark right, String name, String shortName) {
                return new ControlPointWithTwoMarksImpl((Serializable)UUID.randomUUID(), left, right, name, shortName);
            }

            @Override
            protected Waypoint createWaypoint(ControlPoint controlPoint, PassingInstruction passingInstruction) {
                return new WaypointImpl(controlPoint, passingInstruction);
            }
        };
        courseSequenceMapper.effectiveWaypoints.forEach(wp -> course.addWaypoint(Util.size((Iterable)course.getWaypoints()), wp));
        courseSequenceMapper.explicitAssociatedRoles.forEach((m, mr) -> course.addRoleMapping(m, mr.getId()));
        return course;
    }

    public CourseConfiguration<MarkConfigurationResponseAnnotation> createCourseConfigurationFromTemplate(CourseTemplate courseTemplate, Regatta optionalRegatta, Iterable<String> tagsToFilterMarkProperties, Integer optionalNumberOfLaps) {
        HashMap<MarkTemplate, MarkConfiguration<MarkConfigurationResponseAnnotation>> markTemplatesToMarkConfigurations = new HashMap<MarkTemplate, MarkConfiguration<MarkConfigurationResponseAnnotation>>();
        if (optionalRegatta != null) {
            HashMap<MarkTemplate, RegattaMarkConfiguration> markConfigurationsByMarkTemplate = new HashMap<MarkTemplate, RegattaMarkConfiguration>();
            Iterator markUsagesForRoles = this.getMarkUsagesForRoles(optionalRegatta, courseTemplate);
            Map lastUsages = (Map)markUsagesForRoles.getA();
            LastUsageBasedAssociater usagesForRole = (LastUsageBasedAssociater)markUsagesForRoles.getB();
            HashSet markTemplatesToAssociate = new HashSet();
            Util.addAll((Iterable)courseTemplate.getMarkTemplates(), markTemplatesToAssociate);
            Iterator iterator = markTemplatesToAssociate.iterator();
            while (iterator.hasNext()) {
                RegattaMarkConfiguration bestMatchForRole;
                MarkTemplate mt2 = (MarkTemplate)iterator.next();
                MarkRole roleOrNull = (MarkRole)courseTemplate.getDefaultMarkRolesForMarkTemplates().get(mt2);
                if (roleOrNull == null || (bestMatchForRole = (RegattaMarkConfiguration)usagesForRole.getBestMatchForT2(roleOrNull)) == null) continue;
                iterator.remove();
                markConfigurationsByMarkTemplate.put(mt2, bestMatchForRole);
                usagesForRole.removeT1(bestMatchForRole);
                usagesForRole.removeT2(roleOrNull);
            }
            for (RegattaMarkConfiguration regattaMarkConfiguration : usagesForRole.usagesByT1.keySet()) {
                MarkTemplate associatedMarkTemplateOrNull = regattaMarkConfiguration.getOptionalMarkTemplate();
                if (associatedMarkTemplateOrNull == null) continue;
                markConfigurationsByMarkTemplate.compute(associatedMarkTemplateOrNull, (mt, rmc) -> {
                    TimePoint lastUsageOfExistingOrNull;
                    TimePoint lastUsageOrNull;
                    RegattaMarkConfiguration result = rmc == null ? regattaMarkConfiguration : ((lastUsageOrNull = (TimePoint)lastUsages.get(regattaMarkConfiguration)) == null ? rmc : ((lastUsageOfExistingOrNull = (TimePoint)lastUsages.get(rmc)) == null ? regattaMarkConfiguration : (lastUsageOrNull.after(lastUsageOfExistingOrNull) ? regattaMarkConfiguration : rmc)));
                    return result;
                });
            }
            markTemplatesToMarkConfigurations.putAll(markConfigurationsByMarkTemplate);
        }
        for (MarkTemplate markTemplate : courseTemplate.getMarkTemplates()) {
            markTemplatesToMarkConfigurations.computeIfAbsent(markTemplate, mt -> {
                MarkTemplateBasedMarkConfigurationImpl markConfiguration = new MarkTemplateBasedMarkConfigurationImpl(markTemplate, null);
                return markConfiguration;
            });
        }
        this.replaceTemplateBasedConfigurationCandidatesBySuggestedPropertiesInPlace(markTemplatesToMarkConfigurations, tagsToFilterMarkProperties, courseTemplate.getDefaultMarkRolesForMarkTemplates());
        Map<MarkConfiguration<MarkConfigurationResponseAnnotation>, MarkRole> resultingRoleMapping = this.createRoleMappingWithMarkTemplateMapping(courseTemplate, markTemplatesToMarkConfigurations);
        List<WaypointWithMarkConfiguration<MarkConfigurationResponseAnnotation>> resultingWaypoints = this.createWaypointConfigurationsWithMarkTemplateMapping(courseTemplate, markTemplatesToMarkConfigurations, optionalNumberOfLaps == null ? (courseTemplate.getDefaultNumberOfLaps() == null ? 0 : courseTemplate.getDefaultNumberOfLaps()) : optionalNumberOfLaps);
        return new CourseConfigurationImpl(courseTemplate, markTemplatesToMarkConfigurations.values(), resultingRoleMapping, resultingWaypoints, courseTemplate.getRepeatablePart(), optionalNumberOfLaps == null ? courseTemplate.getDefaultNumberOfLaps() : optionalNumberOfLaps, courseTemplate.getName(), courseTemplate.getShortName(), courseTemplate.getOptionalImageURL());
    }

    private Util.Pair<Map<RegattaMarkConfiguration<MarkConfigurationResponseAnnotation>, TimePoint>, LastUsageBasedAssociater<RegattaMarkConfiguration<MarkConfigurationResponseAnnotation>, MarkRole>> getMarkUsagesForRoles(Regatta regatta, CourseTemplate courseTemplate) {
        LastUsageBasedAssociater usagesForRole = new LastUsageBasedAssociater(new HashSet(courseTemplate.getDefaultMarkRolesForMarkTemplates().values()));
        HashMap<RegattaMarkConfiguration, TimePoint> lastUsages = new HashMap<RegattaMarkConfiguration, TimePoint>();
        HashMap<Mark, RegattaMarkConfiguration> markConfigurationsByMark = new HashMap<Mark, RegattaMarkConfiguration>();
        for (RaceColumn raceColumn : regatta.getRaceColumns()) {
            for (Mark mark : raceColumn.getAvailableMarks()) {
                markConfigurationsByMark.computeIfAbsent(mark, m -> this.createMarkConfigurationForRegattaMark(courseTemplate, regatta, null, (Mark)m));
            }
        }
        for (RaceColumn raceColumn : regatta.getRaceColumns()) {
            for (Fleet fleet : raceColumn.getFleets()) {
                TrackedRace trackedRaceOrNull = raceColumn.getTrackedRace(fleet);
                TimePoint usage = null;
                if (trackedRaceOrNull != null && (usage = trackedRaceOrNull.getStartOfRace()) == null) {
                    usage = trackedRaceOrNull.getStartOfTracking();
                }
                Course courseOrNull = null;
                RaceDefinition raceDefinition = raceColumn.getRaceDefinition(fleet);
                if (raceDefinition != null) {
                    courseOrNull = raceDefinition.getCourse();
                }
                if (courseOrNull == null || usage == null) {
                    ReadonlyRaceState raceState = ReadonlyRaceStateImpl.getOrCreate((RaceLogResolver)this.raceLogResolver, (RaceLog)raceColumn.getRaceLog(fleet));
                    if (courseOrNull == null) {
                        courseOrNull = raceState.getCourseDesign();
                    }
                    if (usage == null) {
                        usage = raceState.getStartTime();
                    }
                }
                if (usage == null) {
                    usage = TimePoint.BeginningOfTime;
                }
                if (courseOrNull == null) continue;
                TimePoint effectiveUsageTP = usage;
                for (Waypoint waypoint : courseOrNull.getWaypoints()) {
                    for (Mark mark : waypoint.getMarks()) {
                        RegattaMarkConfiguration regattaMarkConfiguration = (RegattaMarkConfiguration)markConfigurationsByMark.get(mark);
                        assert (regattaMarkConfiguration != null);
                        lastUsages.compute(regattaMarkConfiguration, (mc, existingTP) -> existingTP == null || existingTP.before(effectiveUsageTP) ? effectiveUsageTP : existingTP);
                        MarkRole markRole = this.resolveMarkRoleByID((UUID)courseOrNull.getAssociatedRoles().get(mark), courseTemplate);
                        if (markRole == null) continue;
                        usagesForRole.addUsage(regattaMarkConfiguration, markRole, effectiveUsageTP);
                    }
                }
            }
        }
        return new Util.Pair(lastUsages, usagesForRole);
    }

    private Map<MarkConfiguration<MarkConfigurationResponseAnnotation>, MarkRole> createRoleMappingWithMarkTemplateMapping(CourseTemplate courseTemplate, Map<MarkTemplate, MarkConfiguration<MarkConfigurationResponseAnnotation>> markTemplatesToMarkConfigurations) {
        HashMap<MarkConfiguration<MarkConfigurationResponseAnnotation>, MarkRole> resultingRoleMapping = new HashMap<MarkConfiguration<MarkConfigurationResponseAnnotation>, MarkRole>();
        for (Map.Entry markTemplateWithRole : courseTemplate.getDefaultMarkRolesForMarkTemplates().entrySet()) {
            resultingRoleMapping.put(markTemplatesToMarkConfigurations.get(markTemplateWithRole.getKey()), (MarkRole)markTemplateWithRole.getValue());
        }
        return resultingRoleMapping;
    }

    private List<WaypointWithMarkConfiguration<MarkConfigurationResponseAnnotation>> createWaypointConfigurationsWithMarkTemplateMapping(CourseTemplate courseTemplate, Map<MarkTemplate, MarkConfiguration<MarkConfigurationResponseAnnotation>> markTemplatesToMarkConfigurations, int numberOfLaps) {
        return this.createWaypointConfigurationsWithMarkTemplateMapping(courseTemplate, (MarkRole markRole) -> (MarkConfiguration)markTemplatesToMarkConfigurations.get(courseTemplate.getDefaultMarkTemplateForMarkRole(markRole)), numberOfLaps);
    }

    private List<WaypointWithMarkConfiguration<MarkConfigurationResponseAnnotation>> createWaypointConfigurationsWithMarkTemplateMapping(CourseTemplate courseTemplate, Function<MarkRole, MarkConfiguration<MarkConfigurationResponseAnnotation>> getMarkConfigurationForMarkRole, int numberOfLaps) {
        ArrayList<WaypointWithMarkConfiguration<MarkConfigurationResponseAnnotation>> resultingWaypoints = new ArrayList<WaypointWithMarkConfiguration<MarkConfigurationResponseAnnotation>>();
        for (WaypointTemplate waypointTemplate : numberOfLaps < 2 ? courseTemplate.getWaypointTemplates() : courseTemplate.getWaypointTemplates(numberOfLaps)) {
            ControlPointTemplate controlPointTemplate = waypointTemplate.getControlPointTemplate();
            ControlPointWithMarkConfiguration<MarkConfigurationResponseAnnotation> resultingControlPoint = this.getOrCreateMarkConfigurationForControlPointTemplate(getMarkConfigurationForMarkRole, controlPointTemplate);
            resultingWaypoints.add((WaypointWithMarkConfiguration<MarkConfigurationResponseAnnotation>)new WaypointWithMarkConfigurationImpl(resultingControlPoint, waypointTemplate.getPassingInstruction()));
        }
        return resultingWaypoints;
    }

    private ControlPointWithMarkConfiguration<MarkConfigurationResponseAnnotation> getOrCreateMarkConfigurationForControlPointTemplate(Function<MarkRole, MarkConfiguration<MarkConfigurationResponseAnnotation>> getMarkConfigurationForMarkRole, ControlPointTemplate controlPointTemplate) {
        ControlPointWithMarkConfiguration resultingControlPoint;
        if (controlPointTemplate instanceof MarkRole) {
            MarkRole markRole = (MarkRole)controlPointTemplate;
            resultingControlPoint = (ControlPointWithMarkConfiguration)getMarkConfigurationForMarkRole.apply(markRole);
            assert (resultingControlPoint != null);
        } else {
            MarkRolePair markPairTemplate = (MarkRolePair)controlPointTemplate;
            MarkConfiguration<MarkConfigurationResponseAnnotation> left = getMarkConfigurationForMarkRole.apply(markPairTemplate.getLeft());
            assert (left != null);
            MarkConfiguration<MarkConfigurationResponseAnnotation> right = getMarkConfigurationForMarkRole.apply(markPairTemplate.getRight());
            assert (right != null);
            resultingControlPoint = new MarkPairWithConfigurationImpl(markPairTemplate.getName(), left, right, markPairTemplate.getShortName());
        }
        return resultingControlPoint;
    }

    public CourseConfiguration<MarkConfigurationResponseAnnotation> createCourseConfigurationFromRegatta(CourseBase course, Regatta regatta, TrackedRace optionalRace, Iterable<String> tagsToFilterMarkProperties) {
        Integer numberOfLapsOrNullIfNoValidCourseTemplateInstance;
        assert (regatta != null);
        HashSet<Object> allMarkConfigurations = new HashSet<Object>();
        CourseTemplate courseTemplateOrNull = course == null ? null : this.resolveCourseTemplateSafe(course);
        Map<Mark, RegattaMarkConfiguration<MarkConfigurationResponseAnnotation>> markConfigurationsByMark = this.createMarkConfigurationsForRegatta(regatta, optionalRace, courseTemplateOrNull);
        allMarkConfigurations.addAll(markConfigurationsByMark.values());
        HashMap<Object, MarkRole> resultingRoleMapping = new HashMap<Object, MarkRole>();
        HashMap<MarkRole, Object> resultingRoleToMarkConfigurationMapping = new HashMap<MarkRole, Object>();
        if (course != null) {
            for (Map.Entry markWithRole : course.getAssociatedRoles().entrySet()) {
                MarkRole markRoleForMark = this.resolveMarkRoleByID((UUID)markWithRole.getValue(), courseTemplateOrNull);
                if (markRoleForMark == null) continue;
                RegattaMarkConfiguration<MarkConfigurationResponseAnnotation> markConfigurationForRole = markConfigurationsByMark.get(markWithRole.getKey());
                resultingRoleMapping.put(markConfigurationForRole, markRoleForMark);
                resultingRoleToMarkConfigurationMapping.put(markRoleForMark, markConfigurationForRole);
            }
        }
        String name = null;
        String shortName = null;
        URL optionalImageURL = null;
        ArrayList<WaypointWithMarkConfigurationImpl> resultingWaypoints = new ArrayList<WaypointWithMarkConfigurationImpl>();
        RepeatablePart optionalRepeatablePart = null;
        if (courseTemplateOrNull != null && course != null) {
            numberOfLapsOrNullIfNoValidCourseTemplateInstance = this.isCourseInstanceOfCourseTemplate(course, courseTemplateOrNull);
            if (numberOfLapsOrNullIfNoValidCourseTemplateInstance != null) {
                name = courseTemplateOrNull.getName();
                shortName = courseTemplateOrNull.getShortName();
                optionalImageURL = courseTemplateOrNull.getOptionalImageURL();
                optionalRepeatablePart = courseTemplateOrNull.getRepeatablePart();
                HashMap<MarkTemplate, MarkTemplateBasedMarkConfiguration<MarkConfigurationResponseAnnotation>> markConfigurationsForUnusedMarkRoles = new HashMap<MarkTemplate, MarkTemplateBasedMarkConfiguration<MarkConfigurationResponseAnnotation>>();
                for (Map.Entry e : courseTemplateOrNull.getDefaultMarkTemplatesForMarkRoles().entrySet()) {
                    if (resultingRoleToMarkConfigurationMapping.containsKey(e.getKey())) continue;
                    MarkTemplate markTemplateForMarkRoleWithoutMarkConfigurationSoFar = (MarkTemplate)e.getValue();
                    MarkTemplateBasedMarkConfigurationImpl markConfiguration = new MarkTemplateBasedMarkConfigurationImpl(markTemplateForMarkRoleWithoutMarkConfigurationSoFar, null);
                    markConfigurationsForUnusedMarkRoles.put(markTemplateForMarkRoleWithoutMarkConfigurationSoFar, (MarkTemplateBasedMarkConfiguration<MarkConfigurationResponseAnnotation>)markConfiguration);
                }
                Map<MarkTemplate, MarkConfiguration<MarkConfigurationResponseAnnotation>> markConfigurationsForUnusedMarkRolesWithMatchingMarkProperties = this.replaceTemplateBasedConfigurationCandidatesBySuggestedProperties(markConfigurationsForUnusedMarkRoles, tagsToFilterMarkProperties, courseTemplateOrNull.getDefaultMarkRolesForMarkTemplates());
                allMarkConfigurations.addAll(markConfigurationsForUnusedMarkRolesWithMatchingMarkProperties.values());
                for (Map.Entry entry : courseTemplateOrNull.getDefaultMarkTemplatesForMarkRoles().entrySet()) {
                    MarkConfiguration<MarkConfigurationResponseAnnotation> markConfigForUnusedRole = markConfigurationsForUnusedMarkRolesWithMatchingMarkProperties.get(entry.getValue());
                    if (markConfigForUnusedRole == null) continue;
                    resultingRoleMapping.put(markConfigForUnusedRole, (MarkRole)entry.getKey());
                    resultingRoleToMarkConfigurationMapping.put((MarkRole)entry.getKey(), markConfigForUnusedRole);
                }
            }
        } else {
            numberOfLapsOrNullIfNoValidCourseTemplateInstance = null;
        }
        if (course != null) {
            int waypointIndex = 0;
            Iterator waypointTemplateIterator = numberOfLapsOrNullIfNoValidCourseTemplateInstance != null && numberOfLapsOrNullIfNoValidCourseTemplateInstance == 1 ? courseTemplateOrNull.getWaypointTemplates().iterator() : null;
            for (Waypoint waypoint : course.getWaypoints()) {
                ControlPoint controlPoint;
                MarkPairWithConfigurationImpl resultingControlPoint;
                if (waypointTemplateIterator != null) {
                    WaypointTemplate waypointTemplate = (WaypointTemplate)waypointTemplateIterator.next();
                    while (waypointIndex >= courseTemplateOrNull.getRepeatablePart().getZeroBasedIndexOfRepeatablePartStart() && waypointIndex < courseTemplateOrNull.getRepeatablePart().getZeroBasedIndexOfRepeatablePartEnd()) {
                        resultingControlPoint = this.getOrCreateMarkConfigurationForControlPointTemplate(resultingRoleToMarkConfigurationMapping::get, waypointTemplate.getControlPointTemplate());
                        resultingWaypoints.add(new WaypointWithMarkConfigurationImpl((ControlPointWithMarkConfiguration)resultingControlPoint, waypointTemplate.getPassingInstruction()));
                        ++waypointIndex;
                        if (!waypointTemplateIterator.hasNext()) continue;
                        waypointTemplate = (WaypointTemplate)waypointTemplateIterator.next();
                    }
                }
                if ((controlPoint = waypoint.getControlPoint()) instanceof Mark) {
                    Mark mark = (Mark)controlPoint;
                    resultingControlPoint = (MarkPairWithConfigurationImpl)markConfigurationsByMark.get(mark);
                } else {
                    ControlPointWithTwoMarks markPair = (ControlPointWithTwoMarks)controlPoint;
                    MarkConfiguration left = (MarkConfiguration)markConfigurationsByMark.get(markPair.getLeft());
                    MarkConfiguration right = (MarkConfiguration)markConfigurationsByMark.get(markPair.getRight());
                    resultingControlPoint = new MarkPairWithConfigurationImpl(markPair.getName(), left, right, markPair.getShortName());
                }
                resultingWaypoints.add(new WaypointWithMarkConfigurationImpl((ControlPointWithMarkConfiguration)resultingControlPoint, waypoint.getPassingInstructions()));
                ++waypointIndex;
            }
        }
        return new CourseConfigurationImpl(courseTemplateOrNull, allMarkConfigurations, resultingRoleMapping, resultingWaypoints, optionalRepeatablePart, numberOfLapsOrNullIfNoValidCourseTemplateInstance, name, shortName, optionalImageURL);
    }

    private Map<Mark, RegattaMarkConfiguration<MarkConfigurationResponseAnnotation>> createMarkConfigurationsForRegatta(Regatta regatta, TrackedRace optionalRace, CourseTemplate courseTemplate) {
        HashMap<Mark, RegattaMarkConfiguration<MarkConfigurationResponseAnnotation>> result = new HashMap<Mark, RegattaMarkConfiguration<MarkConfigurationResponseAnnotation>>();
        for (RaceColumn raceColumn : regatta.getRaceColumns()) {
            for (Mark mark : raceColumn.getAvailableMarks()) {
                result.computeIfAbsent(mark, m -> this.createMarkConfigurationForRegattaMark(courseTemplate, regatta, optionalRace, (Mark)m));
            }
        }
        return result;
    }

    private Integer isCourseInstanceOfCourseTemplate(CourseBase course, CourseTemplate courseTemplate) {
        return new CourseTemplateCompatibilityCheckerForCourseBase(course, courseTemplate).isCourseInstanceOfCourseTemplate();
    }

    private void replaceTemplateBasedConfigurationCandidatesBySuggestedPropertiesInPlace(Map<MarkTemplate, MarkConfiguration<MarkConfigurationResponseAnnotation>> markTemplatesToMarkConfigurationsToReplace, Iterable<String> tagsToFilterMarkProperties, Map<MarkTemplate, MarkRole> associatedRoles) {
        Map<MarkTemplate, MarkTemplateBasedMarkConfiguration<MarkConfigurationResponseAnnotation>> replacementCandidates = markTemplatesToMarkConfigurationsToReplace.entrySet().stream().filter(e -> e.getValue() instanceof MarkTemplateBasedMarkConfiguration).collect(Collectors.toMap(s -> (MarkTemplate)s.getKey(), s -> (MarkTemplateBasedMarkConfiguration)s.getValue()));
        Map<MarkTemplate, MarkConfiguration<MarkConfigurationResponseAnnotation>> mapWithReplacements = this.replaceTemplateBasedConfigurationCandidatesBySuggestedProperties(replacementCandidates, tagsToFilterMarkProperties, associatedRoles);
        for (Map.Entry<MarkTemplate, MarkConfiguration<MarkConfigurationResponseAnnotation>> e2 : mapWithReplacements.entrySet()) {
            markTemplatesToMarkConfigurationsToReplace.put(e2.getKey(), e2.getValue());
        }
    }

    private Map<MarkTemplate, MarkConfiguration<MarkConfigurationResponseAnnotation>> replaceTemplateBasedConfigurationCandidatesBySuggestedProperties(Map<MarkTemplate, MarkTemplateBasedMarkConfiguration<MarkConfigurationResponseAnnotation>> replacementCandidates, Iterable<String> tagsToFilterMarkProperties, Map<MarkTemplate, MarkRole> associatedRoles) {
        MarkProperties bestMatchOrNull;
        HashMap<MarkTemplate, MarkConfiguration<MarkConfigurationResponseAnnotation>> result = new HashMap<MarkTemplate, MarkConfiguration<MarkConfigurationResponseAnnotation>>();
        result.putAll(replacementCandidates);
        HashSet markPropertiesCandidates = new HashSet();
        Util.addAll((Iterable)this.getSharedSailingData().getAllMarkProperties(tagsToFilterMarkProperties), markPropertiesCandidates);
        markPropertiesCandidates.removeAll(replacementCandidates.values().stream().map(mp -> mp.getOptionalMarkProperties()).filter(v -> v != null).collect(Collectors.toSet()));
        LastUsageBasedAssociater<MarkProperties, MarkRole> roleBasedAssociater = new LastUsageBasedAssociater<MarkProperties, MarkRole>(replacementCandidates.keySet().stream().map(associatedRoles::get).filter(v -> v != null).collect(Collectors.toSet()));
        for (MarkProperties mp2 : markPropertiesCandidates) {
            roleBasedAssociater.addUsages(mp2, mp2.getLastUsedMarkRole());
        }
        HashMap<MarkTemplate, MarkProperties> suggestedMappings = new HashMap<MarkTemplate, MarkProperties>();
        Iterator<Map.Entry<MarkTemplate, MarkTemplateBasedMarkConfiguration<MarkConfigurationResponseAnnotation>>> iterator = replacementCandidates.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<MarkTemplate, MarkTemplateBasedMarkConfiguration<MarkConfigurationResponseAnnotation>> entry = iterator.next();
            MarkRole markRole = associatedRoles.get(entry.getKey());
            if (markRole == null || (bestMatchOrNull = (MarkProperties)roleBasedAssociater.getBestMatchForT2(markRole)) == null) continue;
            suggestedMappings.put(entry.getKey(), bestMatchOrNull);
            iterator.remove();
            markPropertiesCandidates.remove(bestMatchOrNull);
        }
        LastUsageBasedAssociater<MarkProperties, MarkTemplate> templateBasedAssociater = new LastUsageBasedAssociater<MarkProperties, MarkTemplate>(new HashSet<MarkTemplate>(replacementCandidates.keySet()));
        for (MarkProperties markProperties : markPropertiesCandidates) {
            templateBasedAssociater.addUsages(markProperties, markProperties.getLastUsedMarkTemplate());
        }
        for (Map.Entry entry : replacementCandidates.entrySet()) {
            bestMatchOrNull = (MarkProperties)templateBasedAssociater.getBestMatchForT2((MarkTemplate)entry.getKey());
            if (bestMatchOrNull == null) continue;
            suggestedMappings.put((MarkTemplate)entry.getKey(), bestMatchOrNull);
        }
        for (Map.Entry entry : replacementCandidates.entrySet()) {
            MarkTemplate keyTemplate = (MarkTemplate)entry.getKey();
            if (!suggestedMappings.containsKey(keyTemplate)) continue;
            MarkProperties suggestedPropertiesMapping = (MarkProperties)suggestedMappings.get(keyTemplate);
            MarkPropertiesBasedMarkConfigurationImpl newMarkPropertiesBasedConfiguration = new MarkPropertiesBasedMarkConfigurationImpl(suggestedPropertiesMapping, keyTemplate, (Object)this.getPositioningIfAvailable(suggestedPropertiesMapping));
            result.put(keyTemplate, (MarkConfiguration<MarkConfigurationResponseAnnotation>)newMarkPropertiesBasedConfiguration);
        }
        return result;
    }

    private MarkConfigurationResponseAnnotation getPositioningIfAvailable(Regatta regatta, TrackedRace optionalRace, Mark mark) {
        return CourseConfigurationBuilder.getPositioningIfAvailable((Regatta)regatta, (TrackedRace)optionalRace, (Mark)mark, this.lastKnownPositionResolver);
    }

    private MarkConfigurationResponseAnnotation getPositioningIfAvailable(MarkProperties markProperties) {
        return CourseConfigurationBuilder.getPositioningIfAvailable((Positioning)markProperties.getPositioningInformation(), this.lastKnownPositionResolver);
    }

    public List<MarkProperties> createMarkPropertiesSuggestionsForMarkConfiguration(Regatta optionalRegatta, MarkConfiguration<MarkConfigurationRequestAnnotation> markConfiguration, Iterable<String> tagsToFilterMarkProperties) {
        return null;
    }

    private MarkTemplate resolveMarkTemplateByID(UUID markTemplateID, CourseTemplate courseTemplate) {
        MarkTemplate resolvedMarkTemplate = null;
        if (courseTemplate != null) {
            resolvedMarkTemplate = courseTemplate.getMarkTemplateByIdIfContainedInCourseTemplate(markTemplateID);
        }
        if (resolvedMarkTemplate == null) {
            try {
                resolvedMarkTemplate = this.getSharedSailingData().getMarkTemplateById(markTemplateID);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return resolvedMarkTemplate;
    }

    private RegattaMarkConfiguration<MarkConfigurationResponseAnnotation> createMarkConfigurationForRegattaMark(CourseTemplate courseTemplate, Regatta regatta, TrackedRace optionalRace, Mark mark) {
        UUID markTemplateIdOrNull = mark.getOriginatingMarkTemplateIdOrNull();
        MarkTemplate markTemplateOrNull = markTemplateIdOrNull == null ? null : this.resolveMarkTemplateByID(markTemplateIdOrNull, courseTemplate);
        UUID markPropertiesIdOrNull = mark.getOriginatingMarkPropertiesIdOrNull();
        MarkProperties markPropertiesOrNull = markPropertiesIdOrNull == null ? null : this.getSharedSailingData().getMarkPropertiesById(markPropertiesIdOrNull);
        RegattaMarkConfigurationImpl regattaMarkConfiguration = new RegattaMarkConfigurationImpl(mark, (Object)this.getPositioningIfAvailable(regatta, optionalRace, mark), markTemplateOrNull, markPropertiesOrNull);
        return regattaMarkConfiguration;
    }

    private class CourseConfigurationToCourseConfigurationMapper<P>
    extends CourseSequenceMapper<ControlPointWithMarkConfiguration<P>, MarkConfiguration<P>, WaypointWithMarkConfiguration<P>, P> {
        public CourseConfigurationToCourseConfigurationMapper(Iterable<WaypointWithMarkConfiguration<P>> waypoints, Map<MarkConfiguration<P>, ? extends MarkRole> existingRoleMapping, Map<MarkConfiguration<P>, MarkConfiguration<P>> existingMapping) {
            super(waypoints, existingRoleMapping, existingMapping);
        }

        @Override
        protected MarkPairWithConfiguration<P> createMarkPair(MarkConfiguration<P> left, MarkConfiguration<P> right, String name, String shortName) {
            return new MarkPairWithConfigurationImpl(name, left, right, shortName);
        }

        @Override
        protected WaypointWithMarkConfiguration<P> createWaypoint(ControlPointWithMarkConfiguration<P> controlPoint, PassingInstruction passingInstruction) {
            return new WaypointWithMarkConfigurationImpl(controlPoint, passingInstruction);
        }
    }

    private abstract class CourseSequenceMapper<CP, M extends CP, W, P> {
        final Map<M, MarkRole> explicitAssociatedRoles = new HashMap<M, MarkRole>();
        final Map<M, MarkRole> allAssociatedRoles = new HashMap<M, MarkRole>();
        final List<W> effectiveWaypoints = new ArrayList<W>();
        private final Map<MarkConfiguration<P>, ? extends MarkRole> existingRoleMapping;
        private final Map<MarkConfiguration<P>, M> existingMapping;

        public CourseSequenceMapper(Iterable<WaypointWithMarkConfiguration<P>> waypoints, Map<MarkConfiguration<P>, ? extends MarkRole> existingRoleMapping, Map<MarkConfiguration<P>, M> existingMapping) {
            this.existingRoleMapping = existingRoleMapping;
            this.existingMapping = existingMapping;
            for (Map.Entry<MarkConfiguration<P>, MarkRole> entry : existingRoleMapping.entrySet()) {
                this.explicitAssociatedRoles.put(this.mapMarkConfiguration(entry.getKey()), entry.getValue());
            }
            this.allAssociatedRoles.putAll(this.explicitAssociatedRoles);
            HashMap<MarkPairWithConfiguration, Object> markPairCache = new HashMap<MarkPairWithConfiguration, Object>();
            for (WaypointWithMarkConfiguration<P> waypointWithMarkConfiguration : waypoints) {
                ControlPointWithMarkConfiguration controlPointWithMarkConfiguration = waypointWithMarkConfiguration.getControlPoint();
                if (controlPointWithMarkConfiguration instanceof MarkConfiguration) {
                    MarkConfiguration markConfiguration = (MarkConfiguration)controlPointWithMarkConfiguration;
                    this.effectiveWaypoints.add(this.createWaypoint(this.mapMarkConfiguration(markConfiguration), waypointWithMarkConfiguration.getPassingInstruction()));
                    continue;
                }
                Object controlPoint = markPairCache.computeIfAbsent((MarkPairWithConfiguration)controlPointWithMarkConfiguration, mpwc -> {
                    M left = this.mapMarkConfiguration(mpwc.getLeft());
                    M right = this.mapMarkConfiguration(mpwc.getRight());
                    return this.createMarkPair(left, right, mpwc.getName(), mpwc.getShortName());
                });
                this.effectiveWaypoints.add(this.createWaypoint(controlPoint, waypointWithMarkConfiguration.getPassingInstruction()));
            }
        }

        private M mapMarkConfiguration(MarkConfiguration<P> markConfiguration) {
            M mark = this.getOrCreateMarkReplacement(markConfiguration);
            if (mark == null) {
                throw new IllegalStateException("Non declared mark " + markConfiguration.getName() + " found in waypoint sequence");
            }
            this.allAssociatedRoles.computeIfAbsent(mark, m -> this.existingRoleMapping.get(markConfiguration));
            return mark;
        }

        private M getOrCreateMarkReplacement(MarkConfiguration<P> markConfiguration) {
            return this.existingMapping.get(markConfiguration);
        }

        protected abstract CP createMarkPair(M var1, M var2, String var3, String var4);

        protected abstract W createWaypoint(CP var1, PassingInstruction var2);
    }

    class CourseTemplateCompatibilityCheckerForCourseBase
    extends CourseTemplateCompatibilityChecker<CourseBase, Mark, Waypoint> {
        public CourseTemplateCompatibilityCheckerForCourseBase(CourseBase course, CourseTemplate courseTemplate) {
            super((Object)course, courseTemplate);
        }

        protected MarkRole getMarkRole(Mark markFromRegatta) {
            return CourseAndMarkConfigurationFactoryImpl.this.resolveMarkRoleByID((UUID)((CourseBase)this.getCourse()).getAssociatedRoles().get(markFromRegatta), this.getCourseTemplate());
        }

        protected Iterable<Mark> getMarks(Waypoint waypoint) {
            return waypoint.getMarks();
        }

        protected Iterable<Waypoint> getWaypoints(CourseBase course) {
            return course.getWaypoints();
        }
    }

    private class LastUsageBasedAssociater<T1, T2> {
        private final Map<T1, Map<T2, TimePoint>> usagesByT1 = new HashMap<T1, Map<T2, TimePoint>>();
        private final Map<T2, Map<T1, TimePoint>> usagesByT2 = new HashMap<T2, Map<T1, TimePoint>>();
        private final Predicate<T2> t2Filter = t2 -> Util.contains((Iterable)t2Whitelist, (Object)t2);

        public LastUsageBasedAssociater(Iterable<T2> t2Whitelist) {
        }

        public void addUsage(T1 t1, T2 t2, TimePoint lastUsage) {
            if (this.t2Filter.test(t2)) {
                this.insertOrUpdateUsage(this.usagesByT1, t1, t2, lastUsage);
                this.insertOrUpdateUsage(this.usagesByT2, t2, t1, lastUsage);
            }
        }

        public void addUsages(T1 t1, Map<T2, TimePoint> lastUsages) {
            for (Map.Entry<T2, TimePoint> entry : lastUsages.entrySet()) {
                this.addUsage(t1, entry.getKey(), entry.getValue());
            }
        }

        private <K, V> void insertOrUpdateUsage(Map<K, Map<V, TimePoint>> usages, K key, V value, TimePoint timePoint) {
            Map usagesForKey = usages.computeIfAbsent(key, k -> new HashMap());
            usagesForKey.compute(value, (k, currentValue) -> currentValue == null || timePoint.after(currentValue) ? timePoint : currentValue);
        }

        private <K, V> V getBestMatch(Map<K, Map<V, TimePoint>> forwardUsages, Map<V, Map<K, TimePoint>> backwardUsages, K keyToSearch) {
            V bestMatch = this.getBestMatchCandidate(forwardUsages, keyToSearch);
            if (bestMatch != null && !keyToSearch.equals(this.getBestMatchCandidate(backwardUsages, bestMatch))) {
                bestMatch = null;
            }
            return bestMatch;
        }

        private <K, V> V getBestMatchCandidate(Map<K, Map<V, TimePoint>> usages, K keyToSearch) {
            Object result;
            Map<V, TimePoint> usagesForT1 = usages.get(keyToSearch);
            if (usagesForT1 == null) {
                result = null;
            } else {
                TimePoint bestMatchTP = null;
                Object bestMatch = null;
                for (Map.Entry<V, TimePoint> entry : usagesForT1.entrySet()) {
                    if (bestMatchTP == null || bestMatchTP.after(entry.getValue())) {
                        bestMatchTP = entry.getValue();
                        bestMatch = entry.getKey();
                        continue;
                    }
                    if (bestMatchTP.compareTo((Object)entry.getValue()) != 0) continue;
                    bestMatch = null;
                }
                result = bestMatch;
            }
            return result;
        }

        public T1 getBestMatchForT2(T2 t2) {
            return this.getBestMatch(this.usagesByT2, this.usagesByT1, t2);
        }

        private <K, V> void removeT1(T1 t1) {
            this.remove(this.usagesByT1, this.usagesByT2, t1);
        }

        private <K, V> void removeT2(T2 t2) {
            this.remove(this.usagesByT2, this.usagesByT1, t2);
        }

        private <K, V> void remove(Map<K, Map<V, TimePoint>> forwardUsages, Map<V, Map<K, TimePoint>> backwardUsages, K keyToRemove) {
            Map<V, TimePoint> associatedUses = forwardUsages.remove(keyToRemove);
            if (associatedUses != null) {
                for (V associatedValue : associatedUses.keySet()) {
                    Map<K, TimePoint> usesForValue = backwardUsages.get(associatedValue);
                    if (usesForValue == null) continue;
                    usesForValue.remove(keyToRemove);
                    if (!usesForValue.isEmpty()) continue;
                    backwardUsages.remove(associatedValue);
                }
            }
        }
    }
}

