/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.landscape.procedures;

import com.sap.sailing.landscape.SailingAnalyticsHost;
import com.sap.sailing.landscape.SailingAnalyticsMetrics;
import com.sap.sailing.landscape.SailingAnalyticsProcess;
import com.sap.sailing.landscape.impl.SailingAnalyticsProcessImpl;
import com.sap.sailing.landscape.procedures.SailingProcessConfigurationVariables;
import com.sap.sse.landscape.application.ProcessFactory;
import com.sap.sse.landscape.aws.AwsLandscape;
import java.util.Map;
import java.util.function.Supplier;

public class SailingAnalyticsProcessFactory
implements ProcessFactory<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>, SailingAnalyticsHost<String>> {
    private final Supplier<AwsLandscape<String>> landscapeSupplier;

    public SailingAnalyticsProcessFactory(Supplier<AwsLandscape<String>> landscapeSupplier) {
        this.landscapeSupplier = landscapeSupplier;
    }

    public SailingAnalyticsProcess<String> createProcess(SailingAnalyticsHost<String> host, int port, String serverDirectory, Integer telnetPort, String serverName, Map<String, Object> additionalProperties) {
        try {
            Number expeditionUdpPort = (Number)additionalProperties.get(SailingProcessConfigurationVariables.EXPEDITION_PORT.name());
            Number igtimiRiotPort = (Number)additionalProperties.get(SailingProcessConfigurationVariables.IGTIMI_RIOT_PORT.name());
            return new SailingAnalyticsProcessImpl<String>(port, host, serverDirectory, telnetPort, serverName, expeditionUdpPort == null ? null : Integer.valueOf(expeditionUdpPort.intValue()), igtimiRiotPort == null ? null : Integer.valueOf(igtimiRiotPort.intValue()), this.landscapeSupplier.get());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

