/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogResolver;
import com.sap.sailing.domain.abstractlog.race.state.ReadonlyRaceState;
import com.sap.sailing.domain.abstractlog.race.state.impl.ReadonlyRaceStateImpl;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.Series;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.shared.json.JsonSerializer;
import java.util.UUID;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class SeriesJsonSerializer
implements JsonSerializer<Series> {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_FLEETS = "fleets";
    public static final String FIELD_RACES = "races";
    public static final String FIELD_TRACKED_RACES = "trackedRaces";
    public static final String FIELD_STARTS_WITH_ZERO_SCORE = "startsWithZeroScore";
    public static final String FIELD_HAS_SPLIT_FLEET_CONTIGUOUS_SCORING = "hasSplitFleetContiguousScoring";
    public static final String FIELD_IS_MEDAL_SERIES = "isMedalSeries";
    public static final String FIELD_FLEETS_CAN_RUN_IN_PARALLEL = "fleetsCanRunInParallel";
    public static final String FIELD_MAXIMUM_NUMBER_OF_DISCARDS = "maximumNumberOfDiscards";
    public static final String FIELD_FIRST_COLUMS_IS_NON_DISCARDABLE_CARRY_FORWARD = "firstColumnIsNonDiscardableCarryForward";
    private final JsonSerializer<Fleet> fleetSerializer;
    private final RaceLogResolver raceLogResolver;

    public SeriesJsonSerializer(JsonSerializer<Fleet> fleetSerializer, RaceLogResolver raceLogResolver) {
        this.fleetSerializer = fleetSerializer;
        this.raceLogResolver = raceLogResolver;
    }

    public JSONObject serialize(Series series) {
        JSONObject result = new JSONObject();
        result.put((Object)FIELD_NAME, (Object)series.getName());
        result.put((Object)FIELD_IS_MEDAL_SERIES, (Object)series.isMedal());
        result.put((Object)FIELD_FLEETS_CAN_RUN_IN_PARALLEL, (Object)series.isFleetsCanRunInParallel());
        result.put((Object)FIELD_STARTS_WITH_ZERO_SCORE, (Object)series.isStartsWithZeroScore());
        result.put((Object)FIELD_HAS_SPLIT_FLEET_CONTIGUOUS_SCORING, (Object)series.hasSplitFleetContiguousScoring());
        result.put((Object)FIELD_MAXIMUM_NUMBER_OF_DISCARDS, (Object)series.getMaximumNumberOfDiscards());
        result.put((Object)FIELD_FIRST_COLUMS_IS_NON_DISCARDABLE_CARRY_FORWARD, (Object)series.isFirstColumnNonDiscardableCarryForward());
        JSONArray fleetsJson = new JSONArray();
        for (Fleet fleet : series.getFleets()) {
            fleetsJson.add((Object)this.fleetSerializer.serialize((Object)fleet));
        }
        result.put((Object)FIELD_FLEETS, (Object)fleetsJson);
        JSONArray racesJson = new JSONArray();
        for (RaceColumn raceColumn : series.getRaceColumns()) {
            racesJson.add((Object)raceColumn.getName());
        }
        result.put((Object)FIELD_RACES, (Object)racesJson);
        JSONObject trackedRacesJson = new JSONObject();
        JSONArray trackedFleetsJson = new JSONArray();
        for (Fleet fleet : series.getFleets()) {
            JSONObject trackedFleetJson = new JSONObject();
            trackedFleetJson.put((Object)FIELD_NAME, (Object)fleet.getName());
            JSONArray racesPerFleetJson = new JSONArray();
            for (RaceColumn raceColumn : series.getRaceColumns()) {
                UUID courseAreaId;
                RaceLog raceLog = raceColumn.getRaceLog(fleet);
                if (raceLog != null) {
                    ReadonlyRaceState raceState = ReadonlyRaceStateImpl.getOrCreate((RaceLogResolver)this.raceLogResolver, (RaceLog)raceLog);
                    courseAreaId = raceState.getCourseAreaId();
                } else {
                    courseAreaId = null;
                }
                TrackedRace trackedRace = raceColumn.getTrackedRace(fleet);
                JSONObject raceColumnJson = new JSONObject();
                raceColumnJson.put((Object)FIELD_NAME, (Object)raceColumn.getName());
                raceColumnJson.put((Object)"isMedalRace", (Object)raceColumn.isMedalRace());
                raceColumnJson.put((Object)"courseAreaId", (Object)(courseAreaId == null ? null : courseAreaId.toString()));
                if (trackedRace != null) {
                    raceColumnJson.put((Object)"isLive", (Object)trackedRace.isLive(MillisecondsTimePoint.now()));
                    raceColumnJson.put((Object)"isTracked", (Object)true);
                    raceColumnJson.put((Object)"trackedRaceName", (Object)trackedRace.getRace().getName());
                    raceColumnJson.put((Object)"raceId", (Object)trackedRace.getRace().getId().toString());
                    raceColumnJson.put((Object)"hasGpsData", (Object)trackedRace.hasGPSData());
                    raceColumnJson.put((Object)"hasWindData", (Object)trackedRace.hasWindData());
                } else {
                    raceColumnJson.put((Object)"isLive", (Object)false);
                    raceColumnJson.put((Object)"isTracked", (Object)false);
                    raceColumnJson.put((Object)"trackedRaceName", null);
                    raceColumnJson.put((Object)"hasGpsData", (Object)false);
                    raceColumnJson.put((Object)"hasWindData", (Object)false);
                }
                racesPerFleetJson.add((Object)raceColumnJson);
            }
            trackedFleetJson.put((Object)FIELD_RACES, (Object)racesPerFleetJson);
            trackedFleetsJson.add((Object)trackedFleetJson);
        }
        trackedRacesJson.put((Object)FIELD_FLEETS, (Object)trackedFleetsJson);
        result.put((Object)FIELD_TRACKED_RACES, (Object)trackedRacesJson);
        return result;
    }
}

