/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.impl.DynamicBoat;
import com.sap.sailing.server.gateway.serialization.impl.CompetitorAndBoatJsonSerializer;
import com.sap.sse.common.Util;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.shared.json.JsonSerializer;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class RaceEntriesJsonSerializer
implements JsonSerializer<RaceDefinition> {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_COMPETITORS = "competitors";
    private final SecurityService securityService;

    public RaceEntriesJsonSerializer(SecurityService securityService) {
        this.securityService = securityService;
    }

    public JSONObject serialize(RaceDefinition race) {
        JSONObject result = new JSONObject();
        result.put((Object)FIELD_NAME, (Object)race.getName());
        JSONArray competitorsJson = new JSONArray();
        for (Map.Entry competitorAndBoatEntry : race.getCompetitorsAndTheirBoats().entrySet()) {
            Competitor competitor = (Competitor)competitorAndBoatEntry.getKey();
            DynamicBoat boat = (DynamicBoat)competitorAndBoatEntry.getValue();
            this.securityService.checkCurrentUserExplicitPermissions((WithQualifiedObjectIdentifier)competitor, new HasPermissions.Action[]{SecuredSecurityTypes.PublicReadableActions.READ_PUBLIC});
            this.securityService.checkCurrentUserExplicitPermissions((WithQualifiedObjectIdentifier)boat, new HasPermissions.Action[]{SecuredSecurityTypes.PublicReadableActions.READ_PUBLIC});
            CompetitorAndBoatJsonSerializer competitorAndBoatJsonSerializer = CompetitorAndBoatJsonSerializer.create((boolean)this.securityService.hasCurrentUserExplicitPermissions((WithQualifiedObjectIdentifier)competitor, new HasPermissions.Action[]{HasPermissions.DefaultActions.READ}));
            competitorsJson.add((Object)competitorAndBoatJsonSerializer.serialize(new Util.Pair((Object)competitor, (Object)boat)));
        }
        result.put((Object)FIELD_COMPETITORS, (Object)competitorsJson);
        return result;
    }
}

