/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.EventBase;
import com.sap.sailing.domain.base.LeaderboardGroupBase;
import com.sap.sailing.domain.base.LeaderboardSearchResult;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sse.shared.json.JsonSerializer;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class LeaderboardSearchResultJsonSerializer
implements JsonSerializer<LeaderboardSearchResult> {
    public static final String FIELD_SERVER_BASE_URL = "serverBaseURL";
    public static final String FIELD_EVENTS = "events";
    public static final String FIELD_LEADERBOARD = "leaderboard";
    public static final String FIELD_LEADERBOARD_NAME = "name";
    public static final String FIELD_LEADERBOARD_DISPLAY_NAME = "displayName";
    public static final String FIELD_LEADERBOARD_BOAT_CLASS_NAME = "boatClassName";
    public static final String FIELD_LEADERBOARD_REGATTA_NAME = "regattaName";
    public static final String FIELD_LEADERBOARD_IN_LEADERBOARD_GROUPS = "inLeaderboardGroups";
    private final JsonSerializer<EventBase> eventBaseJsonSerializer;
    private final JsonSerializer<LeaderboardGroupBase> leaderboardGroupBaseJsonSerializer;

    public LeaderboardSearchResultJsonSerializer(JsonSerializer<EventBase> eventBaseJsonSerializer, JsonSerializer<LeaderboardGroupBase> leaderboardGroupBaseJsonSerializer) {
        this.eventBaseJsonSerializer = eventBaseJsonSerializer;
        this.leaderboardGroupBaseJsonSerializer = leaderboardGroupBaseJsonSerializer;
    }

    public JSONObject serialize(LeaderboardSearchResult leaderboardSearchResult) {
        String boatClassName;
        Regatta regatta;
        JSONObject result = new JSONObject();
        JSONArray eventsJson = new JSONArray();
        for (Event e : leaderboardSearchResult.getEvents()) {
            eventsJson.add((Object)this.eventBaseJsonSerializer.serialize((Object)e));
        }
        result.put((Object)FIELD_EVENTS, (Object)eventsJson);
        JSONObject leaderboardJson = new JSONObject();
        result.put((Object)FIELD_LEADERBOARD, (Object)leaderboardJson);
        Leaderboard leaderboard = leaderboardSearchResult.getLeaderboard();
        leaderboardJson.put((Object)FIELD_LEADERBOARD_NAME, (Object)leaderboard.getName());
        leaderboardJson.put((Object)FIELD_LEADERBOARD_DISPLAY_NAME, (Object)leaderboard.getDisplayName());
        if (leaderboard instanceof RegattaLeaderboard) {
            regatta = ((RegattaLeaderboard)leaderboard).getRegatta();
            boatClassName = regatta.getBoatClass().getName();
        } else {
            regatta = null;
            boatClassName = leaderboardSearchResult.getBoatClassName();
        }
        leaderboardJson.put((Object)FIELD_LEADERBOARD_BOAT_CLASS_NAME, (Object)boatClassName);
        leaderboardJson.put((Object)FIELD_LEADERBOARD_REGATTA_NAME, (Object)(regatta == null ? null : regatta.getName()));
        JSONArray leaderboardGroupsJson = new JSONArray();
        leaderboardJson.put((Object)FIELD_LEADERBOARD_IN_LEADERBOARD_GROUPS, (Object)leaderboardGroupsJson);
        for (LeaderboardGroup lg : leaderboardSearchResult.getLeaderboardGroups()) {
            leaderboardGroupsJson.add((Object)this.leaderboardGroupBaseJsonSerializer.serialize((Object)lg));
        }
        return result;
    }
}

