/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.impl;

import com.sap.sailing.domain.base.EventBase;
import com.sap.sailing.domain.base.LeaderboardBase;
import com.sap.sailing.domain.base.LeaderboardGroupBase;
import com.sap.sailing.domain.base.LeaderboardSearchResultBase;
import com.sap.sailing.domain.base.impl.LeaderboardBaseImpl;
import com.sap.sailing.domain.base.impl.LeaderboardSearchResultBaseImpl;
import com.sap.sailing.server.gateway.deserialization.impl.EventBaseJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.Helpers;
import com.sap.sailing.server.gateway.deserialization.impl.LeaderboardGroupBaseJsonDeserializer;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class LeaderboardSearchResultBaseJsonDeserializer
implements JsonDeserializer<LeaderboardSearchResultBase> {
    private final EventBaseJsonDeserializer eventDeserializer;
    private final LeaderboardGroupBaseJsonDeserializer leaderboardGroupDeserializer;

    public LeaderboardSearchResultBaseJsonDeserializer(EventBaseJsonDeserializer eventDeserializer, LeaderboardGroupBaseJsonDeserializer leaderboardGroupDeserializer) {
        this.eventDeserializer = eventDeserializer;
        this.leaderboardGroupDeserializer = leaderboardGroupDeserializer;
    }

    public LeaderboardSearchResultBase deserialize(JSONObject object) throws JsonDeserializationException {
        JSONArray eventsJson = (JSONArray)object.get((Object)"events");
        Collection<Object> events = new ArrayList();
        if (eventsJson != null) {
            for (Object eventJson : eventsJson) {
                EventBase event = this.eventDeserializer.deserialize((JSONObject)eventJson);
                events.add(event);
            }
        } else {
            JSONObject deprecatedEventJson = (JSONObject)object.get((Object)"event");
            events = deprecatedEventJson == null ? Collections.emptySet() : Collections.singleton(this.eventDeserializer.deserialize(deprecatedEventJson));
        }
        JSONObject leaderboardJson = Helpers.getNestedObjectSafe((JSONObject)object, (String)"leaderboard");
        String leaderboardName = (String)leaderboardJson.get((Object)"name");
        String leaderboardDisplayName = (String)leaderboardJson.get((Object)"displayName");
        String boatClassName = (String)leaderboardJson.get((Object)"boatClassName");
        String regattaName = (String)leaderboardJson.get((Object)"regattaName");
        JSONArray leaderboardGroupsJson = Helpers.getNestedArraySafe((JSONObject)leaderboardJson, (String)"inLeaderboardGroups");
        ArrayList<LeaderboardGroupBase> leaderboardGroups = new ArrayList<LeaderboardGroupBase>();
        for (Object leaderboardGroupJson : leaderboardGroupsJson) {
            leaderboardGroups.add(this.leaderboardGroupDeserializer.deserialize((JSONObject)leaderboardGroupJson));
        }
        return new LeaderboardSearchResultBaseImpl((LeaderboardBase)new LeaderboardBaseImpl(leaderboardName, leaderboardDisplayName), regattaName, boatClassName, leaderboardGroups, events);
    }
}

