/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.impl;

import com.sap.sailing.declination.DeclinationService;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.domain.common.impl.MeterPerSecondSpeedImpl;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.common.tracking.impl.GPSFixMovingImpl;
import com.sap.sailing.server.gateway.deserialization.impl.Helpers;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import java.io.IOException;
import java.text.ParseException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class FlatSmartphoneUuidAndGPSFixMovingJsonDeserializer
implements JsonDeserializer<Util.Pair<UUID, List<GPSFixMoving>>> {
    private static final Logger logger = Logger.getLogger(FlatSmartphoneUuidAndGPSFixMovingJsonDeserializer.class.getName());
    public static final String ACCURACY = "accuracy";

    public Util.Pair<UUID, List<GPSFixMoving>> deserialize(JSONObject object) throws JsonDeserializationException {
        UUID device = UUID.fromString(object.get((Object)"deviceUuid").toString());
        JSONArray jsonFixes = Helpers.getNestedArraySafe((JSONObject)object, (String)"fixes");
        ArrayList<GPSFixMovingImpl> fixes = new ArrayList<GPSFixMovingImpl>();
        int i = 0;
        while (i < jsonFixes.size()) {
            Double optionalTrueHeadingDeg;
            JSONObject fixObject = Helpers.toJSONObjectSafe((Object)jsonFixes.get(i));
            double lonDeg = Double.parseDouble(fixObject.get((Object)"longitude").toString());
            double latDeg = Double.parseDouble(fixObject.get((Object)"latitude").toString());
            long timeMillis = this.deserializeTimestamp(fixObject);
            double speedMperS = Double.parseDouble(fixObject.get((Object)"speed").toString());
            double speedKnots = new MeterPerSecondSpeedImpl(speedMperS).getKnots();
            double bearingDeg = Double.parseDouble(fixObject.get((Object)"course").toString());
            if (fixObject.containsKey((Object)"hdt")) {
                optionalTrueHeadingDeg = Double.parseDouble(fixObject.get((Object)"hdt").toString());
            } else if (fixObject.containsKey((Object)"hdg")) {
                TimePoint timePoint = TimePoint.of((long)timeMillis);
                try {
                    optionalTrueHeadingDeg = new DegreeBearingImpl(Double.parseDouble(fixObject.get((Object)"hdg").toString())).add(DeclinationService.INSTANCE.getDeclination(timePoint, (Position)new DegreePosition(latDeg, lonDeg), 1000L).getBearingCorrectedTo(timePoint)).getDegrees();
                }
                catch (IOException | NumberFormatException | ParseException e) {
                    logger.log(Level.WARNING, "Problem obtaining magnetic declination for heading provided in JSON fix", e);
                    optionalTrueHeadingDeg = null;
                }
            } else {
                optionalTrueHeadingDeg = null;
            }
            GPSFixMovingImpl fix = GPSFixMovingImpl.create((double)lonDeg, (double)latDeg, (long)timeMillis, (double)speedKnots, (double)bearingDeg, (Double)optionalTrueHeadingDeg);
            fixes.add(fix);
            ++i;
        }
        return new Util.Pair((Object)device, fixes);
    }

    private long deserializeTimestamp(JSONObject fixObject) throws JsonDeserializationException {
        long timeMillis;
        Object timeMillisObj = fixObject.get((Object)"timestamp");
        Object timeIsoObj = fixObject.get((Object)"timestamp-iso");
        if (timeMillisObj != null && timeIsoObj != null) {
            throw new JsonDeserializationException("two timestamp fields are filled. Please use only one of both.");
        }
        if (timeMillisObj != null) {
            timeMillis = Long.parseLong(timeMillisObj.toString());
        } else if (timeIsoObj != null) {
            String strIsoTimestamp = timeIsoObj.toString();
            DateTimeFormatter timeFormatter = DateTimeFormatter.ISO_DATE_TIME;
            OffsetDateTime offsetDateTime = OffsetDateTime.parse(strIsoTimestamp, timeFormatter);
            timeMillis = offsetDateTime.toInstant().toEpochMilli();
        } else {
            throw new JsonDeserializationException("no timestamp field provided. Please provide one of these fields: timestamp, timestamp-iso");
        }
        return timeMillis;
    }
}

