/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.declination.impl;

import com.sap.sailing.declination.Declination;
import com.sap.sailing.declination.impl.DeclinationImporter;
import com.sap.sailing.declination.impl.DeclinationRecordImpl;
import com.sap.sailing.domain.common.Position;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.util.XmlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class NOAAImporter
extends DeclinationImporter {
    private static final String QUERY_URL = "https://www.ngdc.noaa.gov/geomag-web/calculators/calculateDeclination";
    private static final String REGEXP_DECLINATION = "<p class=\"indent\"><b>Declination</b> = ([0-9]*)&deg; ([0-9]*)' *([EW])";
    private static final String REGEXP_ANNUAL_CHANGE = "changing by *([0-9]*)&deg; *([0-9]*)' ([EW])/year *</p>";
    private final Pattern declinationPattern = Pattern.compile("<p class=\"indent\"><b>Declination</b> = ([0-9]*)&deg; ([0-9]*)' *([EW])");
    private final Pattern annualChangePattern = Pattern.compile("changing by *([0-9]*)&deg; *([0-9]*)' ([EW])/year *</p>");

    protected Pattern getDeclinationPattern() {
        return this.declinationPattern;
    }

    protected Pattern getAnnualChangePattern() {
        return this.annualChangePattern;
    }

    @Override
    public Declination importRecord(Position position, TimePoint timePoint) throws IOException, ParserConfigurationException, SAXException {
        DeclinationRecordImpl result = null;
        Date date = timePoint.asDate();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int year = calendar.get(1);
        URL url = new URL("https://www.ngdc.noaa.gov/geomag-web/calculators/calculateDeclination?key=zNEw7&lon1=" + position.getLngDeg() + "&lat1=" + position.getLatDeg() + "&startYear=" + calendar.get(1) + "&startMonth=" + (calendar.get(2) + 1) + "&startDay=" + calendar.get(5) + "&resultFormat=xml" + (year < 2024 ? "&model=IGRF" : ""));
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        conn.setRequestProperty("Accept-Language", "en-US,en;q=0.8");
        conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/29.0.1547.66 Safari/537.36");
        DocumentBuilder builder = XmlUtil.getSecureDocumentBuilderFactory().newDocumentBuilder();
        InputStream inputStream = conn.getInputStream();
        Document doc = builder.parse(inputStream);
        Element maggridresultNode = (Element)doc.getFirstChild();
        Element resultNode = (Element)maggridresultNode.getElementsByTagName("result").item(0);
        String declination = resultNode.getElementsByTagName("declination").item(0).getTextContent().trim();
        String declinationAnnualChangeInMinutes = resultNode.getElementsByTagName("declination_sv").item(0).getTextContent().trim();
        inputStream.close();
        double declinationAsDouble = declination.equals("nan") ? Double.NaN : Double.valueOf(declination);
        double declinationAnnualChangeInDegreesAsDouble = declinationAnnualChangeInMinutes.equals("nan") ? Double.NaN : Double.valueOf(declinationAnnualChangeInMinutes);
        result = new DeclinationRecordImpl(position, timePoint, (Bearing)new DegreeBearingImpl(declinationAsDouble), (Bearing)new DegreeBearingImpl(declinationAnnualChangeInDegreesAsDouble));
        return result;
    }
}

