/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.deckmanadapter.impl;

import com.sap.sailing.domain.deckmanadapter.LogFile;
import com.sap.sailing.domain.deckmanadapter.Record;
import com.sap.sailing.domain.deckmanadapter.impl.FieldType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.HashMap;

public class LogFileImpl
implements LogFile {
    private final FieldType[] fieldTypes;
    private final BufferedReader bufferedReader;
    private String nextLine;

    public LogFileImpl(Reader r) throws IOException {
        this.bufferedReader = new BufferedReader(r);
        String header = this.bufferedReader.readLine();
        String[] fieldNames = header.split(",");
        this.fieldTypes = new FieldType[fieldNames.length];
        int i = 0;
        while (i < fieldNames.length) {
            this.fieldTypes[i] = FieldType.valueOf(fieldNames[i]);
            ++i;
        }
        this.nextLine = this.bufferedReader.readLine();
    }

    @Override
    public boolean hasNext() {
        return this.nextLine != null;
    }

    @Override
    public Record next() {
        HashMap<FieldType, String> fieldsAsStrings = new HashMap<FieldType, String>();
        String[] fieldValues = this.nextLine.split(",");
        try {
            this.nextLine = this.bufferedReader.readLine();
            int i = 0;
            while (i < fieldValues.length) {
                fieldsAsStrings.put(this.fieldTypes[i], fieldValues[i]);
                ++i;
            }
            Record result = new Record(fieldsAsStrings);
            return result;
        }
        catch (IOException | ParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() is not supported on a Deckman log file");
    }
}

