/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.igtimiadapter.websocket;

import com.sap.sailing.domain.igtimiadapter.BulkFixReceiver;
import com.sap.sailing.domain.igtimiadapter.LiveDataConnection;
import com.sap.sailing.domain.igtimiadapter.websocket.LiveDataConnectionFactoryImpl;
import java.net.InetSocketAddress;

public class LiveDataConnectionWrapper
implements LiveDataConnection {
    private final LiveDataConnectionFactoryImpl factory;
    private final LiveDataConnection actualConnection;
    private boolean stopCalled;

    protected LiveDataConnectionWrapper(LiveDataConnectionFactoryImpl factory, LiveDataConnection actualConnection) {
        this.factory = factory;
        this.actualConnection = actualConnection;
    }

    @Override
    public synchronized void stop() throws Exception {
        if (!this.stopCalled) {
            this.factory.stop(this.actualConnection);
            this.stopCalled = true;
        }
    }

    @Override
    public boolean waitForConnection(long timeoutInMillis) throws InterruptedException {
        return this.actualConnection.waitForConnection(timeoutInMillis);
    }

    @Override
    public void addListener(BulkFixReceiver listener) {
        this.actualConnection.addListener(listener);
    }

    @Override
    public void removeListener(BulkFixReceiver listener) {
        this.actualConnection.removeListener(listener);
    }

    public LiveDataConnection getActualConnection() {
        return this.actualConnection;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.actualConnection.getRemoteAddress();
    }
}

