/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the protection behavior for a field type. This is part of the data protection configuration for a web ACL.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataProtection implements SdkPojo, Serializable, ToCopyableBuilder<DataProtection.Builder, DataProtection> {
    private static final SdkField<FieldToProtect> FIELD_FIELD = SdkField.<FieldToProtect> builder(MarshallingType.SDK_POJO)
            .memberName("Field").getter(getter(DataProtection::field)).setter(setter(Builder::field))
            .constructor(FieldToProtect::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Field").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(DataProtection::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<Boolean> EXCLUDE_RULE_MATCH_DETAILS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ExcludeRuleMatchDetails").getter(getter(DataProtection::excludeRuleMatchDetails))
            .setter(setter(Builder::excludeRuleMatchDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeRuleMatchDetails").build())
            .build();

    private static final SdkField<Boolean> EXCLUDE_RATE_BASED_DETAILS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ExcludeRateBasedDetails").getter(getter(DataProtection::excludeRateBasedDetails))
            .setter(setter(Builder::excludeRateBasedDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeRateBasedDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_FIELD, ACTION_FIELD,
            EXCLUDE_RULE_MATCH_DETAILS_FIELD, EXCLUDE_RATE_BASED_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FieldToProtect field;

    private final String action;

    private final Boolean excludeRuleMatchDetails;

    private final Boolean excludeRateBasedDetails;

    private DataProtection(BuilderImpl builder) {
        this.field = builder.field;
        this.action = builder.action;
        this.excludeRuleMatchDetails = builder.excludeRuleMatchDetails;
        this.excludeRateBasedDetails = builder.excludeRateBasedDetails;
    }

    /**
     * <p>
     * Specifies the field type and optional keys to apply the protection behavior to.
     * </p>
     * 
     * @return Specifies the field type and optional keys to apply the protection behavior to.
     */
    public final FieldToProtect field() {
        return field;
    }

    /**
     * <p>
     * Specifies how to protect the field. WAF can apply a one-way hash to the field or hard code a string substitution.
     * </p>
     * <ul>
     * <li>
     * <p>
     * One-way hash example: <code>ade099751dEXAMPLEHASH2ea9f3393f80dd5d3bEXAMPLEHASH966ae0d3cd5a1e</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Substitution example: <code>REDACTED</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link DataProtectionAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionAsString}.
     * </p>
     * 
     * @return Specifies how to protect the field. WAF can apply a one-way hash to the field or hard code a string
     *         substitution. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         One-way hash example: <code>ade099751dEXAMPLEHASH2ea9f3393f80dd5d3bEXAMPLEHASH966ae0d3cd5a1e</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Substitution example: <code>REDACTED</code>
     *         </p>
     *         </li>
     * @see DataProtectionAction
     */
    public final DataProtectionAction action() {
        return DataProtectionAction.fromValue(action);
    }

    /**
     * <p>
     * Specifies how to protect the field. WAF can apply a one-way hash to the field or hard code a string substitution.
     * </p>
     * <ul>
     * <li>
     * <p>
     * One-way hash example: <code>ade099751dEXAMPLEHASH2ea9f3393f80dd5d3bEXAMPLEHASH966ae0d3cd5a1e</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Substitution example: <code>REDACTED</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link DataProtectionAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionAsString}.
     * </p>
     * 
     * @return Specifies how to protect the field. WAF can apply a one-way hash to the field or hard code a string
     *         substitution. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         One-way hash example: <code>ade099751dEXAMPLEHASH2ea9f3393f80dd5d3bEXAMPLEHASH966ae0d3cd5a1e</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Substitution example: <code>REDACTED</code>
     *         </p>
     *         </li>
     * @see DataProtectionAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * Specifies whether to also exclude any rule match details from the data protection you have enabled for a given
     * field. WAF logs these details for non-terminating matching rules and for the terminating matching rule. For
     * additional information, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html">Log fields for web ACL
     * traffic</a> in the <i>WAF Developer Guide</i>.
     * </p>
     * <p>
     * Default: <code>FALSE</code>
     * </p>
     * 
     * @return Specifies whether to also exclude any rule match details from the data protection you have enabled for a
     *         given field. WAF logs these details for non-terminating matching rules and for the terminating matching
     *         rule. For additional information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html">Log fields for web ACL
     *         traffic</a> in the <i>WAF Developer Guide</i>.</p>
     *         <p>
     *         Default: <code>FALSE</code>
     */
    public final Boolean excludeRuleMatchDetails() {
        return excludeRuleMatchDetails;
    }

    /**
     * <p>
     * Specifies whether to also exclude any rate-based rule details from the data protection you have enabled for a
     * given field. If you specify this exception, RateBasedDetails will show the value of the field. For additional
     * information, see the log field <code>rateBasedRuleList</code> at <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html">Log fields for web ACL
     * traffic</a> in the <i>WAF Developer Guide</i>.
     * </p>
     * <p>
     * Default: <code>FALSE</code>
     * </p>
     * 
     * @return Specifies whether to also exclude any rate-based rule details from the data protection you have enabled
     *         for a given field. If you specify this exception, RateBasedDetails will show the value of the field. For
     *         additional information, see the log field <code>rateBasedRuleList</code> at <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html">Log fields for web ACL
     *         traffic</a> in the <i>WAF Developer Guide</i>.</p>
     *         <p>
     *         Default: <code>FALSE</code>
     */
    public final Boolean excludeRateBasedDetails() {
        return excludeRateBasedDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(field());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(excludeRuleMatchDetails());
        hashCode = 31 * hashCode + Objects.hashCode(excludeRateBasedDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataProtection)) {
            return false;
        }
        DataProtection other = (DataProtection) obj;
        return Objects.equals(field(), other.field()) && Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(excludeRuleMatchDetails(), other.excludeRuleMatchDetails())
                && Objects.equals(excludeRateBasedDetails(), other.excludeRateBasedDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataProtection").add("Field", field()).add("Action", actionAsString())
                .add("ExcludeRuleMatchDetails", excludeRuleMatchDetails())
                .add("ExcludeRateBasedDetails", excludeRateBasedDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Field":
            return Optional.ofNullable(clazz.cast(field()));
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "ExcludeRuleMatchDetails":
            return Optional.ofNullable(clazz.cast(excludeRuleMatchDetails()));
        case "ExcludeRateBasedDetails":
            return Optional.ofNullable(clazz.cast(excludeRateBasedDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Field", FIELD_FIELD);
        map.put("Action", ACTION_FIELD);
        map.put("ExcludeRuleMatchDetails", EXCLUDE_RULE_MATCH_DETAILS_FIELD);
        map.put("ExcludeRateBasedDetails", EXCLUDE_RATE_BASED_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataProtection, T> g) {
        return obj -> g.apply((DataProtection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataProtection> {
        /**
         * <p>
         * Specifies the field type and optional keys to apply the protection behavior to.
         * </p>
         * 
         * @param field
         *        Specifies the field type and optional keys to apply the protection behavior to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder field(FieldToProtect field);

        /**
         * <p>
         * Specifies the field type and optional keys to apply the protection behavior to.
         * </p>
         * This is a convenience method that creates an instance of the {@link FieldToProtect.Builder} avoiding the need
         * to create one manually via {@link FieldToProtect#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FieldToProtect.Builder#build()} is called immediately and its
         * result is passed to {@link #field(FieldToProtect)}.
         * 
         * @param field
         *        a consumer that will call methods on {@link FieldToProtect.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #field(FieldToProtect)
         */
        default Builder field(Consumer<FieldToProtect.Builder> field) {
            return field(FieldToProtect.builder().applyMutation(field).build());
        }

        /**
         * <p>
         * Specifies how to protect the field. WAF can apply a one-way hash to the field or hard code a string
         * substitution.
         * </p>
         * <ul>
         * <li>
         * <p>
         * One-way hash example: <code>ade099751dEXAMPLEHASH2ea9f3393f80dd5d3bEXAMPLEHASH966ae0d3cd5a1e</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Substitution example: <code>REDACTED</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param action
         *        Specifies how to protect the field. WAF can apply a one-way hash to the field or hard code a string
         *        substitution. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        One-way hash example: <code>ade099751dEXAMPLEHASH2ea9f3393f80dd5d3bEXAMPLEHASH966ae0d3cd5a1e</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Substitution example: <code>REDACTED</code>
         *        </p>
         *        </li>
         * @see DataProtectionAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataProtectionAction
         */
        Builder action(String action);

        /**
         * <p>
         * Specifies how to protect the field. WAF can apply a one-way hash to the field or hard code a string
         * substitution.
         * </p>
         * <ul>
         * <li>
         * <p>
         * One-way hash example: <code>ade099751dEXAMPLEHASH2ea9f3393f80dd5d3bEXAMPLEHASH966ae0d3cd5a1e</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Substitution example: <code>REDACTED</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param action
         *        Specifies how to protect the field. WAF can apply a one-way hash to the field or hard code a string
         *        substitution. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        One-way hash example: <code>ade099751dEXAMPLEHASH2ea9f3393f80dd5d3bEXAMPLEHASH966ae0d3cd5a1e</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Substitution example: <code>REDACTED</code>
         *        </p>
         *        </li>
         * @see DataProtectionAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataProtectionAction
         */
        Builder action(DataProtectionAction action);

        /**
         * <p>
         * Specifies whether to also exclude any rule match details from the data protection you have enabled for a
         * given field. WAF logs these details for non-terminating matching rules and for the terminating matching rule.
         * For additional information, see <a
         * href="https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html">Log fields for web ACL
         * traffic</a> in the <i>WAF Developer Guide</i>.
         * </p>
         * <p>
         * Default: <code>FALSE</code>
         * </p>
         * 
         * @param excludeRuleMatchDetails
         *        Specifies whether to also exclude any rule match details from the data protection you have enabled for
         *        a given field. WAF logs these details for non-terminating matching rules and for the terminating
         *        matching rule. For additional information, see <a
         *        href="https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html">Log fields for web
         *        ACL traffic</a> in the <i>WAF Developer Guide</i>.</p>
         *        <p>
         *        Default: <code>FALSE</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeRuleMatchDetails(Boolean excludeRuleMatchDetails);

        /**
         * <p>
         * Specifies whether to also exclude any rate-based rule details from the data protection you have enabled for a
         * given field. If you specify this exception, RateBasedDetails will show the value of the field. For additional
         * information, see the log field <code>rateBasedRuleList</code> at <a
         * href="https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html">Log fields for web ACL
         * traffic</a> in the <i>WAF Developer Guide</i>.
         * </p>
         * <p>
         * Default: <code>FALSE</code>
         * </p>
         * 
         * @param excludeRateBasedDetails
         *        Specifies whether to also exclude any rate-based rule details from the data protection you have
         *        enabled for a given field. If you specify this exception, RateBasedDetails will show the value of the
         *        field. For additional information, see the log field <code>rateBasedRuleList</code> at <a
         *        href="https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html">Log fields for web
         *        ACL traffic</a> in the <i>WAF Developer Guide</i>.</p>
         *        <p>
         *        Default: <code>FALSE</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeRateBasedDetails(Boolean excludeRateBasedDetails);
    }

    static final class BuilderImpl implements Builder {
        private FieldToProtect field;

        private String action;

        private Boolean excludeRuleMatchDetails;

        private Boolean excludeRateBasedDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(DataProtection model) {
            field(model.field);
            action(model.action);
            excludeRuleMatchDetails(model.excludeRuleMatchDetails);
            excludeRateBasedDetails(model.excludeRateBasedDetails);
        }

        public final FieldToProtect.Builder getField() {
            return field != null ? field.toBuilder() : null;
        }

        public final void setField(FieldToProtect.BuilderImpl field) {
            this.field = field != null ? field.build() : null;
        }

        @Override
        public final Builder field(FieldToProtect field) {
            this.field = field;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(DataProtectionAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final Boolean getExcludeRuleMatchDetails() {
            return excludeRuleMatchDetails;
        }

        public final void setExcludeRuleMatchDetails(Boolean excludeRuleMatchDetails) {
            this.excludeRuleMatchDetails = excludeRuleMatchDetails;
        }

        @Override
        public final Builder excludeRuleMatchDetails(Boolean excludeRuleMatchDetails) {
            this.excludeRuleMatchDetails = excludeRuleMatchDetails;
            return this;
        }

        public final Boolean getExcludeRateBasedDetails() {
            return excludeRateBasedDetails;
        }

        public final void setExcludeRateBasedDetails(Boolean excludeRateBasedDetails) {
            this.excludeRateBasedDetails = excludeRateBasedDetails;
        }

        @Override
        public final Builder excludeRateBasedDetails(Boolean excludeRateBasedDetails) {
            this.excludeRateBasedDetails = excludeRateBasedDetails;
            return this;
        }

        @Override
        public DataProtection build() {
            return new DataProtection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
