/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyIpamResourceCidrResponse extends Ec2Response implements
        ToCopyableBuilder<ModifyIpamResourceCidrResponse.Builder, ModifyIpamResourceCidrResponse> {
    private static final SdkField<IpamResourceCidr> IPAM_RESOURCE_CIDR_FIELD = SdkField
            .<IpamResourceCidr> builder(MarshallingType.SDK_POJO)
            .memberName("IpamResourceCidr")
            .getter(getter(ModifyIpamResourceCidrResponse::ipamResourceCidr))
            .setter(setter(Builder::ipamResourceCidr))
            .constructor(IpamResourceCidr::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamResourceCidr")
                    .unmarshallLocationName("ipamResourceCidr").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPAM_RESOURCE_CIDR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final IpamResourceCidr ipamResourceCidr;

    private ModifyIpamResourceCidrResponse(BuilderImpl builder) {
        super(builder);
        this.ipamResourceCidr = builder.ipamResourceCidr;
    }

    /**
     * <p>
     * The CIDR of the resource.
     * </p>
     * 
     * @return The CIDR of the resource.
     */
    public final IpamResourceCidr ipamResourceCidr() {
        return ipamResourceCidr;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ipamResourceCidr());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyIpamResourceCidrResponse)) {
            return false;
        }
        ModifyIpamResourceCidrResponse other = (ModifyIpamResourceCidrResponse) obj;
        return Objects.equals(ipamResourceCidr(), other.ipamResourceCidr());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyIpamResourceCidrResponse").add("IpamResourceCidr", ipamResourceCidr()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpamResourceCidr":
            return Optional.ofNullable(clazz.cast(ipamResourceCidr()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IpamResourceCidr", IPAM_RESOURCE_CIDR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyIpamResourceCidrResponse, T> g) {
        return obj -> g.apply((ModifyIpamResourceCidrResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, ModifyIpamResourceCidrResponse> {
        /**
         * <p>
         * The CIDR of the resource.
         * </p>
         * 
         * @param ipamResourceCidr
         *        The CIDR of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamResourceCidr(IpamResourceCidr ipamResourceCidr);

        /**
         * <p>
         * The CIDR of the resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link IpamResourceCidr.Builder} avoiding the
         * need to create one manually via {@link IpamResourceCidr#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IpamResourceCidr.Builder#build()} is called immediately and its
         * result is passed to {@link #ipamResourceCidr(IpamResourceCidr)}.
         * 
         * @param ipamResourceCidr
         *        a consumer that will call methods on {@link IpamResourceCidr.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipamResourceCidr(IpamResourceCidr)
         */
        default Builder ipamResourceCidr(Consumer<IpamResourceCidr.Builder> ipamResourceCidr) {
            return ipamResourceCidr(IpamResourceCidr.builder().applyMutation(ipamResourceCidr).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private IpamResourceCidr ipamResourceCidr;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyIpamResourceCidrResponse model) {
            super(model);
            ipamResourceCidr(model.ipamResourceCidr);
        }

        public final IpamResourceCidr.Builder getIpamResourceCidr() {
            return ipamResourceCidr != null ? ipamResourceCidr.toBuilder() : null;
        }

        public final void setIpamResourceCidr(IpamResourceCidr.BuilderImpl ipamResourceCidr) {
            this.ipamResourceCidr = ipamResourceCidr != null ? ipamResourceCidr.build() : null;
        }

        @Override
        public final Builder ipamResourceCidr(IpamResourceCidr ipamResourceCidr) {
            this.ipamResourceCidr = ipamResourceCidr;
            return this;
        }

        @Override
        public ModifyIpamResourceCidrResponse build() {
            return new ModifyIpamResourceCidrResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
