/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyInstanceConnectEndpointRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyInstanceConnectEndpointRequest.Builder, ModifyInstanceConnectEndpointRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ModifyInstanceConnectEndpointRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> INSTANCE_CONNECT_ENDPOINT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceConnectEndpointId")
            .getter(getter(ModifyInstanceConnectEndpointRequest::instanceConnectEndpointId))
            .setter(setter(Builder::instanceConnectEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceConnectEndpointId")
                    .unmarshallLocationName("InstanceConnectEndpointId").build()).build();

    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpAddressType")
            .getter(getter(ModifyInstanceConnectEndpointRequest::ipAddressTypeAsString))
            .setter(setter(Builder::ipAddressType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddressType")
                    .unmarshallLocationName("IpAddressType").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(ModifyInstanceConnectEndpointRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId")
                    .unmarshallLocationName("SecurityGroupId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SecurityGroupId").unmarshallLocationName("SecurityGroupId")
                                                    .build()).build()).build()).build();

    private static final SdkField<Boolean> PRESERVE_CLIENT_IP_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PreserveClientIp")
            .getter(getter(ModifyInstanceConnectEndpointRequest::preserveClientIp))
            .setter(setter(Builder::preserveClientIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreserveClientIp")
                    .unmarshallLocationName("PreserveClientIp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD,
            INSTANCE_CONNECT_ENDPOINT_ID_FIELD, IP_ADDRESS_TYPE_FIELD, SECURITY_GROUP_IDS_FIELD, PRESERVE_CLIENT_IP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean dryRun;

    private final String instanceConnectEndpointId;

    private final String ipAddressType;

    private final List<String> securityGroupIds;

    private final Boolean preserveClientIp;

    private ModifyInstanceConnectEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.instanceConnectEndpointId = builder.instanceConnectEndpointId;
        this.ipAddressType = builder.ipAddressType;
        this.securityGroupIds = builder.securityGroupIds;
        this.preserveClientIp = builder.preserveClientIp;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the operation, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the operation, without actually making the request,
     *         and provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The ID of the EC2 Instance Connect Endpoint to modify.
     * </p>
     * 
     * @return The ID of the EC2 Instance Connect Endpoint to modify.
     */
    public final String instanceConnectEndpointId() {
        return instanceConnectEndpointId;
    }

    /**
     * <p>
     * The new IP address type for the EC2 Instance Connect Endpoint.
     * </p>
     * <note>
     * <p>
     * <code>PreserveClientIp</code> is only supported on IPv4 EC2 Instance Connect Endpoints. To use
     * <code>PreserveClientIp</code>, the value for <code>IpAddressType</code> must be <code>ipv4</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The new IP address type for the EC2 Instance Connect Endpoint.</p> <note>
     *         <p>
     *         <code>PreserveClientIp</code> is only supported on IPv4 EC2 Instance Connect Endpoints. To use
     *         <code>PreserveClientIp</code>, the value for <code>IpAddressType</code> must be <code>ipv4</code>.
     *         </p>
     * @see IpAddressType
     */
    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(ipAddressType);
    }

    /**
     * <p>
     * The new IP address type for the EC2 Instance Connect Endpoint.
     * </p>
     * <note>
     * <p>
     * <code>PreserveClientIp</code> is only supported on IPv4 EC2 Instance Connect Endpoints. To use
     * <code>PreserveClientIp</code>, the value for <code>IpAddressType</code> must be <code>ipv4</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The new IP address type for the EC2 Instance Connect Endpoint.</p> <note>
     *         <p>
     *         <code>PreserveClientIp</code> is only supported on IPv4 EC2 Instance Connect Endpoints. To use
     *         <code>PreserveClientIp</code>, the value for <code>IpAddressType</code> must be <code>ipv4</code>.
     *         </p>
     * @see IpAddressType
     */
    public final String ipAddressTypeAsString() {
        return ipAddressType;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Changes the security groups for the EC2 Instance Connect Endpoint. The new set of groups you specify replaces the
     * current set. You must specify at least one group, even if it's just the default security group in the VPC. You
     * must specify the ID of the security group, not the name.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return Changes the security groups for the EC2 Instance Connect Endpoint. The new set of groups you specify
     *         replaces the current set. You must specify at least one group, even if it's just the default security
     *         group in the VPC. You must specify the ID of the security group, not the name.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * Indicates whether the client IP address is preserved as the source. The following are the possible values.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>true</code> - Use the client IP address as the source.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>false</code> - Use the network interface IP address as the source.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * <code>PreserveClientIp=true</code> is only supported on IPv4 EC2 Instance Connect Endpoints. If modifying
     * <code>PreserveClientIp</code> to <code>true</code>, either the endpoint's existing <code>IpAddressType</code>
     * must be <code>ipv4</code>, or if modifying <code>IpAddressType</code> in the same request, the new value must be
     * <code>ipv4</code>.
     * </p>
     * </note>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return Indicates whether the client IP address is preserved as the source. The following are the possible
     *         values.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>true</code> - Use the client IP address as the source.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>false</code> - Use the network interface IP address as the source.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         <code>PreserveClientIp=true</code> is only supported on IPv4 EC2 Instance Connect Endpoints. If modifying
     *         <code>PreserveClientIp</code> to <code>true</code>, either the endpoint's existing
     *         <code>IpAddressType</code> must be <code>ipv4</code>, or if modifying <code>IpAddressType</code> in the
     *         same request, the new value must be <code>ipv4</code>.
     *         </p>
     *         </note>
     *         <p>
     *         Default: <code>false</code>
     */
    public final Boolean preserveClientIp() {
        return preserveClientIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(instanceConnectEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(preserveClientIp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceConnectEndpointRequest)) {
            return false;
        }
        ModifyInstanceConnectEndpointRequest other = (ModifyInstanceConnectEndpointRequest) obj;
        return Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(instanceConnectEndpointId(), other.instanceConnectEndpointId())
                && Objects.equals(ipAddressTypeAsString(), other.ipAddressTypeAsString())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && Objects.equals(preserveClientIp(), other.preserveClientIp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyInstanceConnectEndpointRequest").add("DryRun", dryRun())
                .add("InstanceConnectEndpointId", instanceConnectEndpointId()).add("IpAddressType", ipAddressTypeAsString())
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("PreserveClientIp", preserveClientIp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "InstanceConnectEndpointId":
            return Optional.ofNullable(clazz.cast(instanceConnectEndpointId()));
        case "IpAddressType":
            return Optional.ofNullable(clazz.cast(ipAddressTypeAsString()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "PreserveClientIp":
            return Optional.ofNullable(clazz.cast(preserveClientIp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("InstanceConnectEndpointId", INSTANCE_CONNECT_ENDPOINT_ID_FIELD);
        map.put("IpAddressType", IP_ADDRESS_TYPE_FIELD);
        map.put("SecurityGroupId", SECURITY_GROUP_IDS_FIELD);
        map.put("PreserveClientIp", PRESERVE_CLIENT_IP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyInstanceConnectEndpointRequest, T> g) {
        return obj -> g.apply((ModifyInstanceConnectEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyInstanceConnectEndpointRequest> {
        /**
         * <p>
         * Checks whether you have the required permissions for the operation, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the operation, without actually making the
         *        request, and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The ID of the EC2 Instance Connect Endpoint to modify.
         * </p>
         * 
         * @param instanceConnectEndpointId
         *        The ID of the EC2 Instance Connect Endpoint to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceConnectEndpointId(String instanceConnectEndpointId);

        /**
         * <p>
         * The new IP address type for the EC2 Instance Connect Endpoint.
         * </p>
         * <note>
         * <p>
         * <code>PreserveClientIp</code> is only supported on IPv4 EC2 Instance Connect Endpoints. To use
         * <code>PreserveClientIp</code>, the value for <code>IpAddressType</code> must be <code>ipv4</code>.
         * </p>
         * </note>
         * 
         * @param ipAddressType
         *        The new IP address type for the EC2 Instance Connect Endpoint.</p> <note>
         *        <p>
         *        <code>PreserveClientIp</code> is only supported on IPv4 EC2 Instance Connect Endpoints. To use
         *        <code>PreserveClientIp</code>, the value for <code>IpAddressType</code> must be <code>ipv4</code>.
         *        </p>
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(String ipAddressType);

        /**
         * <p>
         * The new IP address type for the EC2 Instance Connect Endpoint.
         * </p>
         * <note>
         * <p>
         * <code>PreserveClientIp</code> is only supported on IPv4 EC2 Instance Connect Endpoints. To use
         * <code>PreserveClientIp</code>, the value for <code>IpAddressType</code> must be <code>ipv4</code>.
         * </p>
         * </note>
         * 
         * @param ipAddressType
         *        The new IP address type for the EC2 Instance Connect Endpoint.</p> <note>
         *        <p>
         *        <code>PreserveClientIp</code> is only supported on IPv4 EC2 Instance Connect Endpoints. To use
         *        <code>PreserveClientIp</code>, the value for <code>IpAddressType</code> must be <code>ipv4</code>.
         *        </p>
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(IpAddressType ipAddressType);

        /**
         * <p>
         * Changes the security groups for the EC2 Instance Connect Endpoint. The new set of groups you specify replaces
         * the current set. You must specify at least one group, even if it's just the default security group in the
         * VPC. You must specify the ID of the security group, not the name.
         * </p>
         * 
         * @param securityGroupIds
         *        Changes the security groups for the EC2 Instance Connect Endpoint. The new set of groups you specify
         *        replaces the current set. You must specify at least one group, even if it's just the default security
         *        group in the VPC. You must specify the ID of the security group, not the name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * Changes the security groups for the EC2 Instance Connect Endpoint. The new set of groups you specify replaces
         * the current set. You must specify at least one group, even if it's just the default security group in the
         * VPC. You must specify the ID of the security group, not the name.
         * </p>
         * 
         * @param securityGroupIds
         *        Changes the security groups for the EC2 Instance Connect Endpoint. The new set of groups you specify
         *        replaces the current set. You must specify at least one group, even if it's just the default security
         *        group in the VPC. You must specify the ID of the security group, not the name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * Indicates whether the client IP address is preserved as the source. The following are the possible values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>true</code> - Use the client IP address as the source.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>false</code> - Use the network interface IP address as the source.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * <code>PreserveClientIp=true</code> is only supported on IPv4 EC2 Instance Connect Endpoints. If modifying
         * <code>PreserveClientIp</code> to <code>true</code>, either the endpoint's existing <code>IpAddressType</code>
         * must be <code>ipv4</code>, or if modifying <code>IpAddressType</code> in the same request, the new value must
         * be <code>ipv4</code>.
         * </p>
         * </note>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param preserveClientIp
         *        Indicates whether the client IP address is preserved as the source. The following are the possible
         *        values.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>true</code> - Use the client IP address as the source.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>false</code> - Use the network interface IP address as the source.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        <code>PreserveClientIp=true</code> is only supported on IPv4 EC2 Instance Connect Endpoints. If
         *        modifying <code>PreserveClientIp</code> to <code>true</code>, either the endpoint's existing
         *        <code>IpAddressType</code> must be <code>ipv4</code>, or if modifying <code>IpAddressType</code> in
         *        the same request, the new value must be <code>ipv4</code>.
         *        </p>
         *        </note>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preserveClientIp(Boolean preserveClientIp);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean dryRun;

        private String instanceConnectEndpointId;

        private String ipAddressType;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private Boolean preserveClientIp;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceConnectEndpointRequest model) {
            super(model);
            dryRun(model.dryRun);
            instanceConnectEndpointId(model.instanceConnectEndpointId);
            ipAddressType(model.ipAddressType);
            securityGroupIds(model.securityGroupIds);
            preserveClientIp(model.preserveClientIp);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getInstanceConnectEndpointId() {
            return instanceConnectEndpointId;
        }

        public final void setInstanceConnectEndpointId(String instanceConnectEndpointId) {
            this.instanceConnectEndpointId = instanceConnectEndpointId;
        }

        @Override
        public final Builder instanceConnectEndpointId(String instanceConnectEndpointId) {
            this.instanceConnectEndpointId = instanceConnectEndpointId;
            return this;
        }

        public final String getIpAddressType() {
            return ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdStringListRequestCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdStringListRequestCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final Boolean getPreserveClientIp() {
            return preserveClientIp;
        }

        public final void setPreserveClientIp(Boolean preserveClientIp) {
            this.preserveClientIp = preserveClientIp;
        }

        @Override
        public final Builder preserveClientIp(Boolean preserveClientIp) {
            this.preserveClientIp = preserveClientIp;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyInstanceConnectEndpointRequest build() {
            return new ModifyInstanceConnectEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
