/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.impl;

import com.sap.sailing.server.gateway.AbstractJsonHttpServlet;
import com.sap.sailing.server.gateway.impl.ProgressListener;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public abstract class AbstractFileUploadServlet
extends AbstractJsonHttpServlet {
    public static final String PREFERRED_IMPORTER = "preferredImporter";
    public static final String PROGRESS_LISTENER_SESSION_ATTRIBUTE_NAME = "progressListener";
    private static final long serialVersionUID = 1120226743039934620L;

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
            resp.sendError(400);
            return;
        }
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        HttpSession session = req.getSession(true);
        if (session != null) {
            ProgressListener progressListener = new ProgressListener();
            upload.setProgressListener((org.apache.commons.fileupload.ProgressListener)progressListener);
            session.setAttribute(PROGRESS_LISTENER_SESSION_ATTRIBUTE_NAME, (Object)progressListener);
        }
        try {
            List items = upload.parseRequest(req);
            this.setJsonEncodedInHtmlResponseHeader(resp);
            this.process(items, req, resp);
        }
        catch (FileUploadException e) {
            throw new IOException("Could not parse request");
        }
    }

    protected abstract void process(List<FileItem> var1, HttpServletRequest var2, HttpServletResponse var3) throws IOException;
}

