/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws.orchestration;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.landscape.SecurityGroup;
import com.sap.sse.landscape.application.ApplicationProcess;
import com.sap.sse.landscape.application.ApplicationProcessMetrics;
import com.sap.sse.landscape.aws.ApplicationLoadBalancer;
import com.sap.sse.landscape.aws.AwsInstance;
import com.sap.sse.landscape.aws.AwsLandscape;
import com.sap.sse.landscape.aws.TargetGroup;
import com.sap.sse.landscape.aws.orchestration.ProcedureCreatingLoadBalancerMapping;
import com.sap.sse.landscape.aws.orchestration.ProcedureWithTargetGroup;
import com.sap.sse.shared.util.Wait;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import software.amazon.awssdk.services.ec2.model.InstanceStateName;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerStateEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Rule;

public abstract class CreateLoadBalancerMapping<ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>>
extends ProcedureWithTargetGroup<ShardingKey>
implements ProcedureCreatingLoadBalancerMapping<ShardingKey> {
    protected static final int MAX_RULES_PER_ALB = 100;
    protected static final int MAX_ALBS_PER_REGION = 20;
    private final ProcessT process;
    private final String hostname;
    private final Optional<Duration> optionalTimeout;
    private TargetGroup<ShardingKey> masterTargetGroupCreated;
    private TargetGroup<ShardingKey> publicTargetGroupCreated;
    private Iterable<Rule> rulesAdded;

    protected CreateLoadBalancerMapping(BuilderImpl<?, ?, ShardingKey, MetricsT, ProcessT> builder) throws Exception {
        super(builder);
        this.optionalTimeout = builder.getOptionalTimeout();
        this.process = builder.getProcess();
        this.hostname = builder.getHostname();
    }

    @Override
    public AwsLandscape<ShardingKey> getLandscape() {
        return super.getLandscape();
    }

    public void run() throws JSchException, IOException, InterruptedException, SftpException {
        this.masterTargetGroupCreated = this.createTargetGroup(this.getLoadBalancerUsed().getRegion(), this.getMasterTargetGroupName(), this.getProcess());
        this.publicTargetGroupCreated = this.createTargetGroup(this.getLoadBalancerUsed().getRegion(), this.getPublicTargetGroupName(), this.getProcess());
        try {
            Wait.wait(() -> this.getLandscape().getInstance(this.getHost().getId(), this.getHost().getRegion()).state().name() == InstanceStateName.RUNNING, this.optionalTimeout, (Duration)Duration.ONE_SECOND.times(5L), (Level)Level.INFO, (String)("Waiting for instance " + this.getHost().getId() + " to be in state RUNNING"));
            this.getLandscape().addTargetsToTargetGroup(this.masterTargetGroupCreated, Collections.singleton(this.getHost()));
            this.getLandscape().addTargetsToTargetGroup(this.publicTargetGroupCreated, Collections.singleton(this.getHost()));
            this.getLoadBalancerUsed().addRulesAssigningUnusedPriorities(true, Optional.empty(), this.createRules(this.getLoadBalancerUsed(), this.getHostName(), this.masterTargetGroupCreated, this.publicTargetGroupCreated));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getHostName() {
        return this.hostname;
    }

    private AwsInstance<ShardingKey> getHost() {
        AwsInstance result = (AwsInstance)this.getProcess().getHost();
        return result;
    }

    public TargetGroup<ShardingKey> getMasterTargetGroupCreated() {
        return this.masterTargetGroupCreated;
    }

    public TargetGroup<ShardingKey> getPublicTargetGroupCreated() {
        return this.publicTargetGroupCreated;
    }

    public Iterable<Rule> getRulesAdded() {
        return this.rulesAdded;
    }

    public ProcessT getProcess() {
        return this.process;
    }

    public static interface Builder<BuilderT extends Builder<BuilderT, T, ShardingKey, MetricsT, ProcessT>, T extends CreateLoadBalancerMapping<ShardingKey, MetricsT, ProcessT>, ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>>
    extends ProcedureWithTargetGroup.Builder<BuilderT, T, ShardingKey> {
        public BuilderT setProcess(ProcessT var1);

        public BuilderT setHostname(String var1);

        public BuilderT setTimeout(Duration var1);

        public BuilderT setKeyName(String var1);

        public BuilderT setPrivateKeyEncryptionPassphrase(byte[] var1);

        public BuilderT setSecurityGroupForVpc(SecurityGroup var1);
    }

    protected static abstract class BuilderImpl<BuilderT extends Builder<BuilderT, T, ShardingKey, MetricsT, ProcessT>, T extends CreateLoadBalancerMapping<ShardingKey, MetricsT, ProcessT>, ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>>
    extends ProcedureWithTargetGroup.BuilderImpl<BuilderT, T, ShardingKey>
    implements Builder<BuilderT, T, ShardingKey, MetricsT, ProcessT> {
        private static final Logger logger = Logger.getLogger(BuilderImpl.class.getName());
        private String hostname;
        private ProcessT process;
        private Optional<Duration> optionalTimeout = Optional.empty();
        private Optional<String> optionalKeyName = Optional.empty();
        private byte[] privateKeyEncryptionPassphrase;
        private SecurityGroup securityGroupForVpc;

        protected BuilderImpl() {
        }

        @Override
        public BuilderT setProcess(ProcessT process) {
            this.process = process;
            return (BuilderT)((Builder)this.self());
        }

        protected SecurityGroup getSecurityGroupForVpc() {
            return this.securityGroupForVpc;
        }

        @Override
        public BuilderT setSecurityGroupForVpc(SecurityGroup securityGroupForVpc) {
            this.securityGroupForVpc = securityGroupForVpc;
            return (BuilderT)((Builder)this.self());
        }

        @Override
        public BuilderT setKeyName(String keyName) {
            this.optionalKeyName = Optional.ofNullable(keyName);
            return (BuilderT)((Builder)this.self());
        }

        protected Optional<String> getOptionalKeyName() {
            return this.optionalKeyName;
        }

        @Override
        public BuilderT setHostname(String hostname) {
            this.hostname = hostname;
            return (BuilderT)((Builder)this.self());
        }

        protected String getHostname() {
            return this.hostname;
        }

        protected ProcessT getProcess() {
            return this.process;
        }

        @Override
        public BuilderT setTimeout(Duration timeout) {
            this.optionalTimeout = Optional.of(timeout);
            return (BuilderT)((Builder)this.self());
        }

        protected Optional<Duration> getOptionalTimeout() {
            return this.optionalTimeout;
        }

        @Override
        public BuilderT setPrivateKeyEncryptionPassphrase(byte[] privateKeyEncryptionPassphrase) {
            this.privateKeyEncryptionPassphrase = privateKeyEncryptionPassphrase;
            return (BuilderT)((Builder)this.self());
        }

        @Override
        protected String getServerName() throws Exception {
            String result = super.getServerName() != null ? super.getServerName() : this.getProcess().getServerName(this.getOptionalTimeout(), this.getOptionalKeyName(), this.privateKeyEncryptionPassphrase);
            return result;
        }

        protected void waitUntilLoadBalancerProvisioned(AwsLandscape<ShardingKey> landscape, ApplicationLoadBalancer<ShardingKey> loadBalancer) throws InterruptedException {
            TimePoint startingToPollForReady = TimePoint.now();
            while (!(landscape.getApplicationLoadBalancerStatus(loadBalancer).code() != LoadBalancerStateEnum.PROVISIONING || this.getOptionalTimeout().isPresent() && startingToPollForReady.until(TimePoint.now()).compareTo((Object)this.getOptionalTimeout().get()) > 0)) {
                logger.info("Application load balancer " + loadBalancer.getName() + " still PROVISIONING. Waiting...");
                Thread.sleep(5000L);
            }
        }
    }
}

