/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws.impl;

import com.sap.sse.ServerInfo;
import com.sap.sse.common.Duration;
import com.sap.sse.common.HttpRequestHeaderConstants;
import com.sap.sse.common.Util;
import com.sap.sse.landscape.Landscape;
import com.sap.sse.landscape.application.ApplicationProcessMetrics;
import com.sap.sse.landscape.application.impl.ApplicationReplicaSetImpl;
import com.sap.sse.landscape.aws.ApplicationLoadBalancer;
import com.sap.sse.landscape.aws.AwsApplicationProcess;
import com.sap.sse.landscape.aws.AwsApplicationReplicaSet;
import com.sap.sse.landscape.aws.AwsAutoScalingGroup;
import com.sap.sse.landscape.aws.AwsInstance;
import com.sap.sse.landscape.aws.AwsLandscape;
import com.sap.sse.landscape.aws.AwsShard;
import com.sap.sse.landscape.aws.TargetGroup;
import com.sap.sse.landscape.aws.common.shared.ShardTargetGroupName;
import com.sap.sse.landscape.aws.impl.AwsAutoScalingGroupImpl;
import com.sap.sse.landscape.aws.impl.AwsShardImpl;
import com.sap.sse.landscape.aws.impl.DNSCache;
import com.sap.sse.landscape.aws.orchestration.ShardProcedure;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingGroup;
import software.amazon.awssdk.services.ec2.model.LaunchTemplate;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateVersion;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Action;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionTypeEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Listener;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Rule;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleCondition;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Tag;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TagDescription;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupTuple;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthDescription;
import software.amazon.awssdk.services.route53.model.RRType;
import software.amazon.awssdk.services.route53.model.ResourceRecordSet;

public class AwsApplicationReplicaSetImpl<ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends AwsApplicationProcess<ShardingKey, MetricsT, ProcessT>>
extends ApplicationReplicaSetImpl<ShardingKey, MetricsT, ProcessT>
implements AwsApplicationReplicaSet<ShardingKey, MetricsT, ProcessT> {
    private static final Logger logger = Logger.getLogger(AwsApplicationReplicaSetImpl.class.getName());
    private static final String ARCHIVE_SERVER_NAME = "ARCHIVE";
    private static final long serialVersionUID = 6895927683667795173L;
    private final Map<AwsShard<ShardingKey>, Iterable<ShardingKey>> shards;
    private final CompletableFuture<AwsAutoScalingGroup> autoScalingGroup;
    private final CompletableFuture<Rule> defaultRedirectRule;
    private final CompletableFuture<String> hostedZoneId;
    private final CompletableFuture<ApplicationLoadBalancer<ShardingKey>> loadBalancer;
    private final CompletableFuture<Iterable<Rule>> loadBalancerRules;
    private final CompletableFuture<TargetGroup<ShardingKey>> masterTargetGroup;
    private final CompletableFuture<TargetGroup<ShardingKey>> publicTargetGroup;
    private final CompletableFuture<Iterable<TargetGroup<ShardingKey>>> otherTargetGroups;
    private final CompletableFuture<ResourceRecordSet> resourceRecordSet;
    private final String pathPrefixForShardingKey;

    public AwsApplicationReplicaSetImpl(String replicaSetAndServerName, String hostname, ProcessT master, Optional<Iterable<ProcessT>> replicas, CompletableFuture<Iterable<ApplicationLoadBalancer<ShardingKey>>> allLoadBalancersInRegion, CompletableFuture<Map<TargetGroup<ShardingKey>, Iterable<TargetHealthDescription>>> allTargetGroupsInRegion, CompletableFuture<Map<Listener, Iterable<Rule>>> allLoadBalancerRulesInRegion, CompletableFuture<Iterable<AutoScalingGroup>> allAutoScalingGroups, CompletableFuture<Iterable<LaunchTemplate>> allLaunchTemplates, CompletableFuture<Iterable<LaunchTemplateVersion>> allLaunchTemplateDefaultVersions, DNSCache dnsCache, String pathPrefixForShardingKey, Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws InterruptedException, ExecutionException, TimeoutException {
        super(replicaSetAndServerName, hostname, master, replicas);
        this.pathPrefixForShardingKey = pathPrefixForShardingKey;
        this.autoScalingGroup = new CompletableFuture();
        this.defaultRedirectRule = new CompletableFuture();
        this.hostedZoneId = new CompletableFuture();
        this.loadBalancer = new CompletableFuture();
        this.loadBalancerRules = new CompletableFuture();
        this.masterTargetGroup = new CompletableFuture();
        this.publicTargetGroup = new CompletableFuture();
        this.otherTargetGroups = new CompletableFuture();
        this.resourceRecordSet = new CompletableFuture();
        this.shards = new HashMap<AwsShard<ShardingKey>, Iterable<ShardingKey>>();
        try {
            ((CompletableFuture)((CompletableFuture)allLoadBalancersInRegion.thenCompose(loadBalancers -> allTargetGroupsInRegion.thenCompose(targetGroupsAndTheirTargetHealthDescriptions -> allLoadBalancerRulesInRegion.thenCompose(listenersAndTheirRules -> allAutoScalingGroups.thenCompose(autoScalingGroups -> allLaunchTemplates.thenCompose(launchTemplates -> allLaunchTemplateDefaultVersions.handle((launchTemplateDefaultVersions, e) -> this.establishState((Iterable<ApplicationLoadBalancer<ShardingKey>>)loadBalancers, (Map<TargetGroup<ShardingKey>, Iterable<TargetHealthDescription>>)targetGroupsAndTheirTargetHealthDescriptions, (Map<Listener, Iterable<Rule>>)listenersAndTheirRules, (Iterable<AutoScalingGroup>)autoScalingGroups, (Iterable<LaunchTemplate>)launchTemplates, (Iterable<LaunchTemplateVersion>)launchTemplateDefaultVersions, dnsCache, optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase)))))))).handle((v, e) -> {
                if (e != null) {
                    logger.log(Level.SEVERE, "Exception while trying to establish state of application replica set " + this.getName(), (Throwable)e);
                }
                return null;
            })).get(Math.round(((Duration)Landscape.WAIT_FOR_PROCESS_TIMEOUT.get()).asMinutes()), TimeUnit.MINUTES);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e2) {
            logger.log(Level.SEVERE, "Exception while waiting for establishing state of application replica set.");
            throw e2;
        }
    }

    @Override
    public Map<AwsShard<ShardingKey>, Iterable<ShardingKey>> getShards() {
        return this.shards;
    }

    public AwsApplicationReplicaSetImpl(String replicaSetAndServerName, ProcessT master, Optional<Iterable<ProcessT>> replicas, CompletableFuture<Iterable<ApplicationLoadBalancer<ShardingKey>>> allLoadBalancersInRegion, CompletableFuture<Map<TargetGroup<ShardingKey>, Iterable<TargetHealthDescription>>> allTargetGroupsInRegion, CompletableFuture<Map<Listener, Iterable<Rule>>> allLoadBalancerRulesInRegion, AwsLandscape<ShardingKey> landscape, CompletableFuture<Iterable<AutoScalingGroup>> allAutoScalingGroups, CompletableFuture<Iterable<LaunchTemplate>> allLaunchTemplates, CompletableFuture<Iterable<LaunchTemplateVersion>> allLaunchTemplateDefaultVersions, DNSCache dnsCache, String pathPrefixForShardingKey, Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws InterruptedException, ExecutionException, TimeoutException {
        this(replicaSetAndServerName, null, master, replicas, allLoadBalancersInRegion, allTargetGroupsInRegion, allLoadBalancerRulesInRegion, allAutoScalingGroups, allLaunchTemplates, allLaunchTemplateDefaultVersions, dnsCache, pathPrefixForShardingKey, optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase);
    }

    private Void establishState(Iterable<ApplicationLoadBalancer<ShardingKey>> loadBalancers, Map<TargetGroup<ShardingKey>, Iterable<TargetHealthDescription>> targetGroupsAndTheirTargetHealthDescriptions, Map<Listener, Iterable<Rule>> listenersAndTheirRules, Iterable<AutoScalingGroup> autoScalingGroups, Iterable<LaunchTemplate> launchTemplates, Iterable<LaunchTemplateVersion> launchTemplateDefaultVersions, DNSCache dnsCache, Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) {
        TargetGroup myMasterTargetGroup = null;
        TargetGroup singleTargetGroupCandidate = null;
        HashSet<TargetGroup<ShardingKey>> otherTargetGroupsFound = new HashSet<TargetGroup<ShardingKey>>();
        for (Map.Entry e2 : targetGroupsAndTheirTargetHealthDescriptions.entrySet()) {
            if ((e2.getKey().getProtocol() == ProtocolEnum.HTTP || e2.getKey().getProtocol() == ProtocolEnum.HTTPS) && e2.getKey().getLoadBalancerArn() != null && e2.getKey().getHealthCheckPort().intValue() == ((AwsApplicationProcess)this.getMaster()).getPort()) {
                if (!this.masterTargetGroup.isDone() && !Util.isEmpty((Iterable)Util.filter(e2.getValue(), target -> target.target().id().equals(((AwsApplicationProcess)this.getMaster()).getHost().getId())))) {
                    if (this.hasMasterRuleForward(listenersAndTheirRules, e2.getKey())) {
                        myMasterTargetGroup = e2.getKey();
                        this.masterTargetGroup.complete(myMasterTargetGroup);
                    } else {
                        singleTargetGroupCandidate = e2.getKey();
                    }
                }
                if (this.publicTargetGroup.isDone() || Util.isEmpty((Iterable)Util.filter(e2.getValue(), target -> Util.contains((Iterable)Util.map((Iterable)this.getReplicas(), replica -> replica.getHost().getId()), (Object)target.target().id()))) && Util.isEmpty((Iterable)Util.filter(e2.getValue(), target -> target.target().id().equals(((AwsApplicationProcess)this.getMaster()).getHost().getId()))) || !this.hasPublicRuleForward(listenersAndTheirRules, e2.getKey()) || this.hasPathCondition(listenersAndTheirRules, e2.getKey())) continue;
                this.publicTargetGroup.complete(e2.getKey());
                this.tryToFindAutoScalingGroup(e2.getKey(), autoScalingGroups, launchTemplates, launchTemplateDefaultVersions);
                continue;
            }
            try {
                if ((e2.getKey().getProtocol() == ProtocolEnum.TCP || e2.getKey().getProtocol() == ProtocolEnum.TCP_UDP) && e2.getKey().getLoadBalancerArn() != null && IntStream.of(((AwsApplicationProcess)this.getMaster()).getAllTCPPorts(optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase)).anyMatch(p -> p == ((TargetGroup)e2.getKey()).getPort())) {
                    if (Util.isEmpty((Iterable)Util.filter(e2.getValue(), target -> target.target().id().equals(((AwsApplicationProcess)this.getMaster()).getHost().getId())))) continue;
                    otherTargetGroupsFound.add(e2.getKey());
                    continue;
                }
                if (e2.getKey().getProtocol() != ProtocolEnum.UDP && e2.getKey().getProtocol() != ProtocolEnum.TCP_UDP || e2.getKey().getLoadBalancerArn() == null || !IntStream.of(((AwsApplicationProcess)this.getMaster()).getAllUDPPorts(optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase)).anyMatch(p -> p == ((TargetGroup)e2.getKey()).getPort()) || Util.isEmpty((Iterable)Util.filter(e2.getValue(), target -> target.target().id().equals(((AwsApplicationProcess)this.getMaster()).getHost().getId())))) continue;
                otherTargetGroupsFound.add(e2.getKey());
            }
            catch (Exception ex2) {
                throw new RuntimeException(ex2);
            }
        }
        this.otherTargetGroups.complete(otherTargetGroupsFound);
        this.shards.putAll(this.establishShards(targetGroupsAndTheirTargetHealthDescriptions, listenersAndTheirRules, autoScalingGroups, launchTemplates, launchTemplateDefaultVersions));
        if (!this.autoScalingGroup.isDone()) {
            this.autoScalingGroup.complete(null);
        }
        if (!this.masterTargetGroup.isDone() && !this.publicTargetGroup.isDone() && singleTargetGroupCandidate != null) {
            myMasterTargetGroup = singleTargetGroupCandidate;
            this.masterTargetGroup.complete(singleTargetGroupCandidate);
            this.publicTargetGroup.complete(singleTargetGroupCandidate);
        }
        TargetGroup finalMasterTargetGroup = myMasterTargetGroup;
        String hostname = null;
        ApplicationLoadBalancer myLoadBalancer = null;
        if (finalMasterTargetGroup != null) {
            block3: for (Map.Entry<Listener, Iterable<Rule>> e3 : listenersAndTheirRules.entrySet()) {
                for (Rule rule : e3.getValue()) {
                    if (Util.isEmpty((Iterable)Util.filter((Iterable)rule.actions(), action -> action.type() == ActionTypeEnum.FORWARD && !Util.isEmpty((Iterable)Util.filter((Iterable)action.forwardConfig().targetGroups(), targetGroup2 -> targetGroup2.targetGroupArn().equals(finalMasterTargetGroup.getTargetGroupArn())))))) continue;
                    hostname = (String)((RuleCondition)Util.first((Iterable)Util.filter((Iterable)rule.conditions(), condition -> condition.field().equals("host-header")))).hostHeaderConfig().values().iterator().next();
                    this.setHostname(hostname);
                    myLoadBalancer = (ApplicationLoadBalancer)Util.first((Iterable)Util.filter(loadBalancers, loadBalancer -> loadBalancer.getArn().equals(((Listener)e3.getKey()).loadBalancerArn())));
                    this.loadBalancer.complete(myLoadBalancer);
                    dnsCache.getHostedZoneId(AwsLandscape.getHostedZoneName(hostname)).handle((hzid, ex) -> this.hostedZoneId.complete((String)hzid));
                    dnsCache.getResourceRecordSetsAsync(hostname).thenAccept(resourceRecordSets -> {
                        Optional<ResourceRecordSet> firstResourceRecordSet = Util.stream((Iterable)resourceRecordSets).findFirst();
                        if (!firstResourceRecordSet.isPresent()) {
                            this.resourceRecordSet.complete(null);
                        } else {
                            firstResourceRecordSet.ifPresent(rrs -> {
                                this.resourceRecordSet.complete((ResourceRecordSet)rrs);
                                try {
                                    if (rrs.type() == RRType.CNAME && !Util.isEmpty((Iterable)Util.filter((Iterable)rrs.resourceRecords(), rr -> {
                                        try {
                                            return rr.value().equals(this.getLoadBalancer().getDNSName());
                                        }
                                        catch (InterruptedException | ExecutionException e1) {
                                            logger.log(Level.WARNING, "This shouldn't have happened", e1);
                                            throw new RuntimeException(e1);
                                        }
                                    }))) {
                                        logger.fine("Found DNS resource record " + this.getHostname() + " pointing to application replica set's load balancer " + this.getLoadBalancer().getArn());
                                    }
                                }
                                catch (InterruptedException | ExecutionException e1) {
                                    logger.log(Level.WARNING, "This shouldn't have happened", e1);
                                }
                            });
                        }
                    });
                    break block3;
                }
            }
        }
        ApplicationLoadBalancer finalLoadBalancer = myLoadBalancer;
        if (hostname != null) {
            String finalHostname = hostname;
            HashSet<Rule> rules = new HashSet<Rule>();
            for (Rule rule : listenersAndTheirRules.entrySet().stream().filter(e -> ((Listener)e.getKey()).loadBalancerArn().equals(finalLoadBalancer.getArn())).map(e -> (Iterable)e.getValue()).findAny().get()) {
                if (!rule.conditions().stream().anyMatch(condition -> condition.field().equals("host-header") && condition.values().contains(finalHostname))) continue;
                if (rule.conditions().stream().anyMatch(condition -> condition.field().equals("path-pattern") && condition.values().contains("/")) && rule.actions().stream().anyMatch(action -> action.type() == ActionTypeEnum.REDIRECT)) {
                    this.defaultRedirectRule.complete(rule);
                }
                rules.add(rule);
            }
            this.loadBalancerRules.complete(rules);
            if (!this.defaultRedirectRule.isDone()) {
                this.defaultRedirectRule.complete(null);
            }
        } else {
            logger.fine("Couldn't find hostname, target group(s) and rules for " + this.getName());
            this.loadBalancerRules.complete(Collections.emptySet());
            this.defaultRedirectRule.complete(null);
            if (this.getName().equals(ARCHIVE_SERVER_NAME)) {
                this.setHostname("www.sapsailing.com");
            } else {
                logger.warning("Found an application replica set " + this.getName() + " that is not the " + ARCHIVE_SERVER_NAME + " replica set; no hostname can be inferred.");
                this.setHostname(null);
            }
        }
        return null;
    }

    private AwsAutoScalingGroup getShardAutoscalingGroup(TargetGroup<ShardingKey> targetGroup, Iterable<AutoScalingGroup> autoScalingGroups, Iterable<LaunchTemplate> launchTemplates, Iterable<LaunchTemplateVersion> launchTemplateDefaultVersions) {
        AwsAutoScalingGroup autoscalinggroup = Util.stream(autoScalingGroups).filter(autoScalingGroup -> autoScalingGroup.targetGroupARNs().contains(targetGroup.getTargetGroupArn())).findFirst().map(asg -> new AwsAutoScalingGroupImpl((AutoScalingGroup)asg, (LaunchTemplate)Util.filter((Iterable)launchTemplates, lc -> Util.equalsWithNull((Object)lc.launchTemplateId(), (Object)asg.launchTemplate().launchTemplateId())).iterator().next(), (LaunchTemplateVersion)Util.filter((Iterable)launchTemplateDefaultVersions, ltv -> Util.equalsWithNull((Object)ltv.launchTemplateId(), (Object)asg.launchTemplate().launchTemplateId())).iterator().next(), targetGroup.getRegion())).orElse(null);
        return autoscalinggroup;
    }

    private HashMap<AwsShard<ShardingKey>, Iterable<ShardingKey>> establishShards(Map<TargetGroup<ShardingKey>, Iterable<TargetHealthDescription>> targetGroupsAndTheirTargetHealthDescriptions, Map<Listener, Iterable<Rule>> listenersAndTheirRules, Iterable<AutoScalingGroup> autoScalingGroups, Iterable<LaunchTemplate> launchTemplates, Iterable<LaunchTemplateVersion> launchTemplateDefaultVersions) {
        HashMap<AwsShard<ShardingKey>, Iterable<ShardingKey>> shardMap = new HashMap<AwsShard<ShardingKey>, Iterable<ShardingKey>>();
        for (Map.Entry<TargetGroup<ShardingKey>, Iterable<TargetHealthDescription>> e : targetGroupsAndTheirTargetHealthDescriptions.entrySet()) {
            Set<Rule> pathRules;
            if (e.getKey().getProtocol() != ProtocolEnum.HTTP && e.getKey().getProtocol() != ProtocolEnum.HTTPS || e.getKey().getLoadBalancerArn() == null || e.getKey().getHealthCheckPort().intValue() != ((AwsApplicationProcess)this.getMaster()).getPort() || (pathRules = this.getListenerRulesWithPathToReplica(listenersAndTheirRules, e.getKey())).isEmpty() || !ShardTargetGroupName.isValidShardTargetGroupName((String)e.getKey().getName())) continue;
            Set<ShardingKey> shardingKeys = this.getShardingKeys(listenersAndTheirRules, e.getKey());
            String tagName = null;
            Iterable<TagDescription> tagsDescs = e.getKey().getTagDescriptions();
            for (TagDescription des : tagsDescs) {
                Iterable tag = Util.filter((Iterable)des.tags(), t -> t.key().equals("shardname"));
                if (Util.isEmpty((Iterable)tag)) continue;
                tagName = ((Tag)tag.iterator().next()).value();
                break;
            }
            try {
                ShardTargetGroupName shardName = ShardTargetGroupName.parse((String)e.getKey().getName(), tagName);
                AwsShardImpl<ShardingKey> shard = new AwsShardImpl<ShardingKey>(this.getName(), shardName.getShardName(), shardingKeys, e.getKey(), e.getKey().getLoadBalancer(), pathRules, this.getShardAutoscalingGroup(e.getKey(), autoScalingGroups, launchTemplates, launchTemplateDefaultVersions));
                shardMap.put(shard, shard.getKeys());
            }
            catch (Exception e1) {
                logger.info(e1.getMessage());
            }
        }
        return shardMap;
    }

    @Override
    public ShardTargetGroupName getNewShardName(String shardName, String targetGroupNamePrefix) throws Exception {
        return ShardTargetGroupName.create((String)this.getName(), (String)shardName, (String)targetGroupNamePrefix);
    }

    @Override
    public void stopAllUnmanagedReplicas(Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        logger.info("Stopping all unmanaged replicas of replica set " + this);
        for (AwsApplicationProcess replica : this.getReplicas()) {
            if (this.getAutoScalingGroup() != null && replica.getHost().isManagedByAutoScalingGroup(Collections.singleton(this.getAutoScalingGroup()))) continue;
            logger.info("Found unmanaged replica " + replica + ". Removing from public target group and stopping...");
            this.getPublicTargetGroup().removeTarget((AwsInstance<ShardingKey>)replica.getHost());
            replica.stopAndTerminateIfLast(optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase);
        }
    }

    private boolean hasPublicRuleForward(Map<Listener, Iterable<Rule>> listenersAndTheirRules, TargetGroup<ShardingKey> publicTargetGroupCandidate) {
        return this.hasListenerRuleWithHostHeaderForward(listenersAndTheirRules, publicTargetGroupCandidate, (String)HttpRequestHeaderConstants.HEADER_FORWARD_TO_REPLICA.getB());
    }

    private boolean hasPathCondition(Map<Listener, Iterable<Rule>> listenersAndTheirRules, TargetGroup<ShardingKey> shardingTargetGroupCandidate) {
        String shardTargetGroupCandidateArn = shardingTargetGroupCandidate.getTargetGroupArn();
        for (Map.Entry<Listener, Iterable<Rule>> e : listenersAndTheirRules.entrySet()) {
            if (!Util.equalsWithNull((Object)e.getKey().loadBalancerArn(), (Object)shardingTargetGroupCandidate.getLoadBalancerArn())) continue;
            for (Rule rule : e.getValue()) {
                for (Action action : rule.actions()) {
                    if (action.type() != ActionTypeEnum.FORWARD) continue;
                    for (TargetGroupTuple targetGroupTuple : action.forwardConfig().targetGroups()) {
                        if (!Util.equalsWithNull((Object)targetGroupTuple.targetGroupArn(), (Object)shardTargetGroupCandidateArn)) continue;
                        for (RuleCondition condition : rule.conditions()) {
                            if (!Util.equalsWithNull((Object)condition.field(), (Object)"path-pattern")) continue;
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean hasListenerRuleWithHostHeaderForward(Map<Listener, Iterable<Rule>> listenersAndTheirRules, TargetGroup<ShardingKey> publicTargetGroupCandidate, String hostHeaderForwardTo) {
        String publicTargetGroupCandidateArn = publicTargetGroupCandidate.getTargetGroupArn();
        for (Map.Entry<Listener, Iterable<Rule>> e : listenersAndTheirRules.entrySet()) {
            if (!Util.equalsWithNull((Object)e.getKey().loadBalancerArn(), (Object)publicTargetGroupCandidate.getLoadBalancerArn())) continue;
            for (Rule rule : e.getValue()) {
                for (Action action : rule.actions()) {
                    if (action.type() != ActionTypeEnum.FORWARD) continue;
                    for (TargetGroupTuple targetGroupTuple : action.forwardConfig().targetGroups()) {
                        if (!Util.equalsWithNull((Object)targetGroupTuple.targetGroupArn(), (Object)publicTargetGroupCandidateArn)) continue;
                        for (RuleCondition condition : rule.conditions()) {
                            if (!Util.equalsWithNull((Object)condition.field(), (Object)"http-header") || !Util.equalsWithNull((Object)condition.httpHeaderConfig().httpHeaderName(), (Object)"X-SAPSSE-Forward-Request-To") || !condition.httpHeaderConfig().values().contains(hostHeaderForwardTo)) continue;
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private Set<Rule> getListenerRulesWithPathToReplica(Map<Listener, Iterable<Rule>> listenersAndTheirRules, TargetGroup<ShardingKey> shardTargetGroupCandidate) {
        String shardTargetGroupCandidateArn = shardTargetGroupCandidate.getTargetGroupArn();
        HashSet<Rule> res = new HashSet<Rule>();
        for (Map.Entry<Listener, Iterable<Rule>> e : listenersAndTheirRules.entrySet()) {
            if (!Util.equalsWithNull((Object)e.getKey().loadBalancerArn(), (Object)shardTargetGroupCandidate.getLoadBalancerArn())) continue;
            for (Rule rule : e.getValue()) {
                for (Action action : rule.actions()) {
                    if (action.type() != ActionTypeEnum.FORWARD) continue;
                    for (TargetGroupTuple targetGroupTuple : action.forwardConfig().targetGroups()) {
                        if (!Util.equalsWithNull((Object)targetGroupTuple.targetGroupArn(), (Object)shardTargetGroupCandidateArn)) continue;
                        for (RuleCondition condition : rule.conditions()) {
                            if (!Util.equalsWithNull((Object)condition.field(), (Object)"path-pattern")) continue;
                            for (RuleCondition ruleCondition : rule.conditions()) {
                                if (!Util.equalsWithNull((Object)ruleCondition.field(), (Object)"http-header") || !Util.equalsWithNull((Object)ruleCondition.httpHeaderConfig().httpHeaderName(), (Object)HttpRequestHeaderConstants.HEADER_FORWARD_TO_REPLICA.getA()) || !ruleCondition.httpHeaderConfig().values().contains(HttpRequestHeaderConstants.HEADER_FORWARD_TO_REPLICA.getB())) continue;
                                res.add(rule);
                            }
                        }
                    }
                }
            }
        }
        return res;
    }

    private Set<ShardingKey> getShardingKeys(Map<Listener, Iterable<Rule>> listenersAndTheirRules, TargetGroup<ShardingKey> shardTargetGroupCandidate) {
        String publicTargetGroupCandidateArn = shardTargetGroupCandidate.getTargetGroupArn();
        HashSet shardingKeys = new HashSet();
        for (Map.Entry<Listener, Iterable<Rule>> e : listenersAndTheirRules.entrySet()) {
            if (!Util.equalsWithNull((Object)e.getKey().loadBalancerArn(), (Object)shardTargetGroupCandidate.getLoadBalancerArn())) continue;
            for (Rule rule : e.getValue()) {
                for (Action action : rule.actions()) {
                    if (action.type() != ActionTypeEnum.FORWARD) continue;
                    for (TargetGroupTuple targetGroupTuple : action.forwardConfig().targetGroups()) {
                        if (!Util.equalsWithNull((Object)targetGroupTuple.targetGroupArn(), (Object)publicTargetGroupCandidateArn)) continue;
                        for (RuleCondition condition : rule.conditions()) {
                            if (!Util.equalsWithNull((Object)condition.field(), (Object)"http-header") || !Util.equalsWithNull((Object)condition.httpHeaderConfig().httpHeaderName(), (Object)HttpRequestHeaderConstants.HEADER_FORWARD_TO_REPLICA.getA()) || !condition.httpHeaderConfig().values().contains(HttpRequestHeaderConstants.HEADER_FORWARD_TO_REPLICA.getB())) continue;
                            for (RuleCondition ruleCondition : rule.conditions()) {
                                if (!Util.equalsWithNull((Object)ruleCondition.field(), (Object)"path-pattern")) continue;
                                Util.addAll((Iterable)Util.map((Iterable)ruleCondition.values(), path -> ShardProcedure.getShardingKeyFromPathCondition(path, this.pathPrefixForShardingKey)), shardingKeys);
                            }
                        }
                    }
                }
            }
        }
        return shardingKeys;
    }

    private boolean hasMasterRuleForward(Map<Listener, Iterable<Rule>> listenersAndTheirRules, TargetGroup<ShardingKey> masterTargetGroupCandidate) {
        return this.hasListenerRuleWithHostHeaderForward(listenersAndTheirRules, masterTargetGroupCandidate, (String)HttpRequestHeaderConstants.HEADER_FORWARD_TO_MASTER.getB());
    }

    private void tryToFindAutoScalingGroup(TargetGroup<ShardingKey> targetGroup, Iterable<AutoScalingGroup> autoScalingGroups, Iterable<LaunchTemplate> launchTemplates, Iterable<LaunchTemplateVersion> launchTemplateDefaultVersions) {
        this.autoScalingGroup.complete(Util.stream(autoScalingGroups).filter(autoScalingGroup -> autoScalingGroup.targetGroupARNs().contains(targetGroup.getTargetGroupArn())).findFirst().map(asg -> new AwsAutoScalingGroupImpl((AutoScalingGroup)asg, (LaunchTemplate)Util.first((Iterable)Util.filter((Iterable)launchTemplates, lt -> Util.equalsWithNull((Object)lt.launchTemplateId(), asg.launchTemplate() == null ? null : asg.launchTemplate().launchTemplateId()))), (LaunchTemplateVersion)Util.first((Iterable)Util.filter((Iterable)launchTemplateDefaultVersions, ltv -> Util.equalsWithNull((Object)ltv.launchTemplateId(), asg.launchTemplate() == null ? null : asg.launchTemplate().launchTemplateId()))), targetGroup.getRegion())).orElse(null));
    }

    @Override
    public ApplicationLoadBalancer<ShardingKey> getLoadBalancer() throws InterruptedException, ExecutionException {
        return this.loadBalancer.get();
    }

    @Override
    public TargetGroup<ShardingKey> getMasterTargetGroup() throws InterruptedException, ExecutionException {
        return this.masterTargetGroup.get();
    }

    @Override
    public TargetGroup<ShardingKey> getPublicTargetGroup() throws InterruptedException, ExecutionException {
        return this.publicTargetGroup.get();
    }

    @Override
    public Iterable<TargetGroup<ShardingKey>> getOtherTargetGroups() throws InterruptedException, ExecutionException {
        return this.otherTargetGroups.get();
    }

    @Override
    public Iterable<Rule> getLoadBalancerRules() throws InterruptedException, ExecutionException {
        return this.loadBalancerRules.get();
    }

    @Override
    public Rule getDefaultRedirectRule() throws InterruptedException, ExecutionException {
        return this.defaultRedirectRule.get();
    }

    @Override
    public AwsAutoScalingGroup getAutoScalingGroup() throws InterruptedException, ExecutionException {
        return this.autoScalingGroup.get();
    }

    @Override
    public String getHostedZoneId() throws InterruptedException, ExecutionException {
        return this.hostedZoneId.get();
    }

    @Override
    public ResourceRecordSet getResourceRecordSet() throws InterruptedException, ExecutionException {
        return this.resourceRecordSet.get();
    }

    @Override
    public void restartAllReplicas(Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        for (AwsApplicationProcess replica : this.getReplicas()) {
            logger.info("Restarting replica " + replica + " in replica set " + this.getName());
            try {
                replica.restart(optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase);
                logger.info("Wating until restarted replica " + replica + " in replica set " + this.getName() + " has become ready:");
                replica.waitUntilReady(optionalTimeout);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Problem restarting replica " + replica + ". Continuing by restarting the next replica if there are more.", e);
            }
        }
    }

    @Override
    public boolean isLocalReplicaSet() {
        return this.getName().equals(ServerInfo.getName());
    }

    @Override
    public void removeShard(AwsShard<ShardingKey> shard, AwsLandscape<ShardingKey> landscape) throws Exception {
        landscape.deleteLoadBalancerListenerRules(shard.getTargetGroup().getRegion(), (Rule[])Util.toArray(this.getLoadBalancer().getRulesForTargetGroups(Collections.singleton(shard.getTargetGroup())), (Object[])new Rule[0]));
        landscape.removeAutoScalingGroup(shard.getAutoScalingGroup());
        landscape.deleteTargetGroup(shard.getTargetGroup());
    }
}

