/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.racelogtracking.impl;

import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.trackfiles.TrackFileImportDeviceIdentifier;
import com.sap.sailing.domain.trackfiles.TrackFileImportDeviceIdentifierImpl;
import com.sap.sailing.server.gateway.serialization.racelog.tracking.DeviceIdentifierJsonHandler;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TransformationException;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.util.UUID;
import org.json.simple.JSONObject;

public class TrackFileImportDeviceIdentifierJsonHandler
implements DeviceIdentifierJsonHandler {
    public static TimePoint loadTimePoint(Object object) {
        if (object == null) {
            return null;
        }
        return new MillisecondsTimePoint(((Number)object).longValue());
    }

    public static Long storeTimePoint(TimePoint timePoint) {
        if (timePoint == null) {
            return null;
        }
        return timePoint.asMillis();
    }

    public DeviceIdentifier deserialize(Object serialized, String type, String stringRepresentation) throws TransformationException {
        if (serialized == null) {
            throw new TransformationException("Received nothing to deserialize");
        }
        JSONObject json = (JSONObject)serialized;
        UUID uuid = UUID.fromString((String)json.get((Object)Fields.UUID.name()));
        String fileName = (String)json.get((Object)Fields.FILE_NAME.name());
        String trackName = (String)json.get((Object)Fields.TRACK_NAME.name());
        TimePoint uploaded = TrackFileImportDeviceIdentifierJsonHandler.loadTimePoint(json.get((Object)Fields.UPLOADED_MILLIS.name()));
        return new TrackFileImportDeviceIdentifierImpl(uuid, stringRepresentation, fileName, trackName, uploaded);
    }

    public Util.Pair<String, JSONObject> serialize(DeviceIdentifier deviceIdentifier) throws TransformationException {
        TrackFileImportDeviceIdentifier id = TrackFileImportDeviceIdentifierImpl.cast((DeviceIdentifier)deviceIdentifier);
        JSONObject result = new JSONObject();
        result.put((Object)Fields.UUID.name(), (Object)id.getId().toString());
        result.put((Object)Fields.FILE_NAME.name(), (Object)id.getFileName());
        result.put((Object)Fields.TRACK_NAME.name(), (Object)id.getTrackName());
        result.put((Object)Fields.UPLOADED_MILLIS.name(), (Object)TrackFileImportDeviceIdentifierJsonHandler.storeTimePoint(id.getUploadedAt()));
        return new Util.Pair((Object)"FILE", (Object)result);
    }

    private static enum Fields {
        UUID,
        FILE_NAME,
        TRACK_NAME,
        UPLOADED_MILLIS;

    }
}

