/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.base;

import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.BoatFactory;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorFactory;
import com.sap.sailing.domain.base.CompetitorWithBoat;
import com.sap.sailing.domain.base.Nationality;
import com.sap.sailing.domain.base.impl.DynamicBoat;
import com.sap.sailing.domain.base.impl.DynamicCompetitor;
import com.sap.sailing.domain.base.impl.DynamicCompetitorWithBoat;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.CompetitorWithBoatDTO;
import com.sap.sse.common.Color;
import com.sap.sse.common.Duration;
import java.net.URI;
import java.util.Map;

public interface CompetitorAndBoatStore
extends CompetitorFactory,
BoatFactory {
    public DynamicCompetitor getExistingCompetitorByIdAsString(String var1);

    public CompetitorWithBoat getExistingCompetitorWithBoatByIdAsString(String var1);

    public void allowCompetitorResetToDefaults(Competitor var1);

    public void clear();

    public int getCompetitorsCount();

    public void clearCompetitors();

    public Iterable<? extends Competitor> getAllCompetitors();

    public Iterable<CompetitorWithBoat> getCompetitorsWithBoat();

    public Iterable<Competitor> getCompetitorsWithoutBoat();

    public Competitor updateCompetitor(String var1, String var2, String var3, Color var4, String var5, Nationality var6, URI var7, URI var8, Double var9, Duration var10, String var11, boolean var12);

    public void addNewCompetitors(Iterable<DynamicCompetitor> var1);

    public void addNewCompetitorsWithBoat(Iterable<DynamicCompetitorWithBoat> var1);

    public CompetitorDTO convertToCompetitorDTO(Competitor var1);

    public CompetitorWithBoatDTO convertToCompetitorWithBoatDTO(CompetitorWithBoat var1);

    public CompetitorDTO convertToCompetitorWithOptionalBoatDTO(Competitor var1);

    public Map<CompetitorDTO, BoatDTO> convertToCompetitorAndBoatDTOs(Map<Competitor, ? extends Boat> var1);

    public void addCompetitorUpdateListener(CompetitorUpdateListener var1);

    public void removeCompetitorUpdateListener(CompetitorUpdateListener var1);

    public DynamicBoat getExistingBoatByIdAsString(String var1);

    public void allowBoatResetToDefaults(DynamicBoat var1);

    public int getBoatsCount();

    public void clearBoats();

    public Iterable<? extends Boat> getBoats();

    public Iterable<? extends Boat> getStandaloneBoats();

    public Competitor migrateToCompetitorWithoutBoat(CompetitorWithBoat var1);

    public Boat updateBoat(String var1, String var2, Color var3, String var4);

    public void addNewBoats(Iterable<DynamicBoat> var1);

    public BoatDTO convertToBoatDTO(Boat var1);

    public void addBoatUpdateListener(BoatUpdateListener var1);

    public void removeBoatUpdateListener(BoatUpdateListener var1);

    public static interface BoatUpdateListener {
        public void boatUpdated(Boat var1);

        public void boatCreated(Boat var1);
    }

    public static interface CompetitorUpdateListener {
        public void competitorUpdated(Competitor var1);

        public void competitorCreated(Competitor var1);
    }
}

