/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.declination.impl;

import com.sap.sailing.declination.Declination;
import com.sap.sailing.declination.impl.AbstractDeclinationRecord;
import com.sap.sailing.domain.common.Position;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.DegreeBearingImpl;

public class DeclinationRecordImpl
extends AbstractDeclinationRecord
implements Declination {
    private static final long serialVersionUID = 6918630656182340186L;
    private final Bearing annualChange;

    public DeclinationRecordImpl(Position position, TimePoint timePoint, Bearing bearing, Bearing annualChange) {
        super(position, timePoint, bearing);
        this.annualChange = annualChange;
    }

    @Override
    public Bearing getAnnualChange() {
        return this.annualChange;
    }

    @Override
    public Bearing getBearingCorrectedTo(TimePoint timePoint) {
        return new DegreeBearingImpl(this.getBearing().getDegrees() + this.getAnnualChange().getDegrees() * (double)(timePoint.asMillis() - this.getTimePoint().asMillis()) / 1000.0 / 3600.0 / 24.0 / 365.0);
    }

    @Override
    public String toString() {
        return this.getTimePoint() + "@" + this.getPosition() + ": " + this.getBearing() + ", " + this.getAnnualChange() + "/year";
    }
}

