/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.components;

import com.sap.sse.datamining.components.AdditionalResultDataBuilder;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.components.ProcessorInstruction;
import com.sap.sse.datamining.impl.components.AbstractParallelProcessor;
import com.sap.sse.datamining.impl.components.AbstractProcessorInstruction;
import com.sap.sse.datamining.impl.components.ProcessorInstructionPriority;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractRetrievalProcessor<InputType, ResultType>
extends AbstractParallelProcessor<InputType, ResultType> {
    private final int retrievalLevel;
    private final String retrievedDataTypeMessageKey;
    private final AtomicInteger retrievedDataAmount;

    public AbstractRetrievalProcessor(Class<InputType> inputType, Class<ResultType> resultType, ExecutorService executor, Collection<Processor<ResultType, ?>> resultReceivers, int retrievalLevel, String retrievedDataTypeMessageKey) {
        super(inputType, resultType, executor, resultReceivers);
        this.retrievalLevel = retrievalLevel;
        this.retrievedDataTypeMessageKey = retrievedDataTypeMessageKey;
        this.retrievedDataAmount = new AtomicInteger();
    }

    @Override
    protected ProcessorInstruction<ResultType> createInstruction(final InputType element) {
        return new AbstractProcessorInstruction<ResultType>(this, ProcessorInstructionPriority.createRetrievalPriority(this.retrievalLevel)){

            @Override
            public ResultType computeResult() {
                for (Object retrievedElement : AbstractRetrievalProcessor.this.retrieveData(element)) {
                    if (this.isAborted()) break;
                    AbstractRetrievalProcessor.this.retrievedDataAmount.incrementAndGet();
                    AbstractRetrievalProcessor.this.forwardResultToReceivers(retrievedElement);
                }
                return AbstractRetrievalProcessor.this.createInvalidResult();
            }
        };
    }

    protected abstract Iterable<ResultType> retrieveData(InputType var1);

    @Override
    protected void setAdditionalData(AdditionalResultDataBuilder additionalDataBuilder) {
        additionalDataBuilder.setDataTypeMessageKey(this.retrievedDataTypeMessageKey);
        additionalDataBuilder.setRetrievedDataAmount(this.retrievedDataAmount.get());
    }
}

