/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security;

import com.sap.sse.common.Duration;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.concurrent.ConcurrentWeakHashMap;
import com.sap.sse.security.impl.Activator;
import com.sap.sse.util.TimerWithRunnable;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.SessionException;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.SessionContext;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.web.servlet.Cookie;
import org.apache.shiro.web.servlet.ShiroHttpServletRequest;
import org.apache.shiro.web.servlet.SimpleCookie;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.apache.shiro.web.util.WebUtils;

public class SecurityWebSessionManager
extends DefaultWebSessionManager {
    private static final Logger log = Logger.getLogger(SecurityWebSessionManager.class.getName());
    private static final TimerWithRunnable timer = new TimerWithRunnable("Timer delaying Session.touch() onChange(s) notifications", true);
    private static final Duration MAX_DURATION_ASSUMED_FOR_MESSAGE_DELIVERY = Duration.ONE_SECOND.times(30L);
    private static final String GLOBAL_SESSION_ID_COOKIE_NAME = "JSESSIONID_GLOBAL";
    private static final Duration MAX_DURATION_AFTER_WHICH_TO_PING_SESSION = Duration.ONE_HOUR;
    private static final Object DUMMY = new Object();
    private static final ConcurrentWeakHashMap<Session, Object> sessionsAlreadyScheduledForOnChange = new ConcurrentWeakHashMap();

    public SecurityWebSessionManager() {
        this.getSessionIdCookie().setPath("/");
        Thread backgroundThreadWaitingForSecurityServiceToObtainSharedAcrossSubdomains = new Thread(() -> {
            String domainForSecurityServiceSharing = Activator.getSecurityService().getSharedAcrossSubdomainsOf();
            if (domainForSecurityServiceSharing != null) {
                this.getSessionIdCookie().setDomain(domainForSecurityServiceSharing);
                this.getSessionIdCookie().setName(GLOBAL_SESSION_ID_COOKIE_NAME);
            }
        }, "Background thread of " + ((Object)((Object)this)).getClass().getName() + " waiting for security service");
        backgroundThreadWaitingForSecurityServiceToObtainSharedAcrossSubdomains.setDaemon(true);
        backgroundThreadWaitingForSecurityServiceToObtainSharedAcrossSubdomains.start();
    }

    public void touch(SessionKey key) throws InvalidSessionException {
        Session s = this.lookupRequiredSession(key);
        s.touch();
        this.triggerOnChangeLatestInHalfTimeoutPeriod(s);
    }

    private void triggerOnChangeLatestInHalfTimeoutPeriod(Session s) {
        Duration sendDurationLatestIn = new MillisecondsDurationImpl(s.getTimeout()).minus(MAX_DURATION_ASSUMED_FOR_MESSAGE_DELIVERY);
        if (!sessionsAlreadyScheduledForOnChange.containsKey((Object)s)) {
            sessionsAlreadyScheduledForOnChange.put((Object)s, DUMMY);
            timer.schedule(() -> {
                this.onChange(s);
                sessionsAlreadyScheduledForOnChange.remove((Object)s);
            }, MillisecondsTimePoint.now().plus(sendDurationLatestIn.compareTo((Object)MAX_DURATION_AFTER_WHICH_TO_PING_SESSION) > 0 ? MAX_DURATION_AFTER_WHICH_TO_PING_SESSION : sendDurationLatestIn).asDate());
        }
    }

    private Session lookupSession(SessionKey key) throws SessionException {
        if (key == null) {
            throw new NullPointerException("SessionKey argument cannot be null.");
        }
        return this.doGetSession(key);
    }

    private Session lookupRequiredSession(SessionKey key) throws SessionException {
        Session session = this.lookupSession(key);
        if (session == null) {
            String msg = "Unable to locate required Session instance based on SessionKey [" + key + "].";
            throw new UnknownSessionException(msg);
        }
        return session;
    }

    protected void onStart(Session session, SessionContext context) {
        if (!WebUtils.isHttp((Object)context)) {
            log.fine("SessionContext argument is not HTTP compatible or does not have an HTTP request/response pair. No session ID cookie will be set.");
        } else {
            HttpServletRequest request = WebUtils.getHttpRequest((Object)context);
            HttpServletResponse response = WebUtils.getHttpResponse((Object)context);
            if (this.isSessionIdCookieEnabled()) {
                Serializable sessionId = session.getId();
                this.storeSessionId(sessionId, request, response);
            } else {
                log.fine("Session ID cookie is disabled.  No cookie has been set for new session with id " + session.getId());
            }
            request.removeAttribute(ShiroHttpServletRequest.REFERENCED_SESSION_ID_SOURCE);
            request.setAttribute(ShiroHttpServletRequest.REFERENCED_SESSION_IS_NEW, (Object)Boolean.TRUE);
        }
    }

    private void storeSessionId(Serializable currentId, HttpServletRequest request, HttpServletResponse response) {
        if (currentId == null) {
            String msg = "sessionId cannot be null when persisting for subsequent requests.";
            throw new IllegalArgumentException("sessionId cannot be null when persisting for subsequent requests.");
        }
        Cookie template = this.getSessionIdCookie();
        SimpleCookie cookie = new SimpleCookie(template){

            public Cookie.SameSiteOptions getSameSite() {
                return Cookie.SameSiteOptions.NONE;
            }
        };
        String idString = currentId.toString();
        cookie.setValue(idString);
        cookie.setSecure(true);
        cookie.saveTo(request, response);
        log.fine("Set session ID cookie for session with id " + idString);
    }
}

