/*
 * Decompiled with CFR 0.152.
 */
package difflib;

import difflib.Delta;
import difflib.DeltaComparator;
import difflib.PatchFailedException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class Patch<T> {
    private List<Delta<T>> deltas = new LinkedList<Delta<T>>();

    public List<T> applyTo(List<T> target) throws PatchFailedException {
        LinkedList<T> result = new LinkedList<T>(target);
        ListIterator<Delta<T>> it = this.getDeltas().listIterator(this.deltas.size());
        while (it.hasPrevious()) {
            Delta<T> delta = it.previous();
            delta.applyTo(result);
        }
        return result;
    }

    public boolean isEmpty() {
        return this.deltas.isEmpty();
    }

    public List<T> applyToInPlace(List<T> target) throws PatchFailedException {
        List<T> result = target;
        ListIterator<Delta<T>> it = this.getDeltas().listIterator(this.deltas.size());
        while (it.hasPrevious()) {
            Delta<T> delta = it.previous();
            delta.applyTo(result);
        }
        return result;
    }

    public List<T> restore(List<T> target) {
        LinkedList<T> result = new LinkedList<T>(target);
        ListIterator<Delta<T>> it = this.getDeltas().listIterator(this.deltas.size());
        while (it.hasPrevious()) {
            Delta<T> delta = it.previous();
            delta.restore(result);
        }
        return result;
    }

    public void addDelta(Delta<T> delta) {
        this.deltas.add(delta);
    }

    public List<Delta<T>> getDeltas() {
        Collections.sort(this.deltas, new DeltaComparator());
        return this.deltas;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('[');
        boolean first = true;
        for (Delta<T> delta : this.getDeltas()) {
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            result.append(delta);
        }
        result.append(']');
        return result.toString();
    }
}

