/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.components.aggregators;

import com.sap.sailing.datamining.data.ManeuverSpeedDetailsStatistic;
import com.sap.sailing.datamining.impl.components.aggregators.ManeuverSpeedDetailsStatisticAggregationProcessorHelper;
import com.sap.sailing.datamining.shared.ManeuverSpeedDetailsAggregation;
import com.sap.sailing.datamining.shared.ManeuverSpeedDetailsAggregationImpl;
import com.sap.sse.datamining.components.AggregationProcessorDefinition;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.GroupedDataEntry;
import com.sap.sse.datamining.impl.components.SimpleAggregationProcessorDefinition;
import com.sap.sse.datamining.impl.components.aggregators.AbstractParallelGroupedDataStoringAggregationProcessor;
import com.sap.sse.datamining.shared.GroupKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class ManeuverSpeedDetailsStatisticMedianAggregationProcessor
extends AbstractParallelGroupedDataStoringAggregationProcessor<ManeuverSpeedDetailsStatistic, ManeuverSpeedDetailsAggregation> {
    private static final String MESSAGE_KEY = "MedianTrendForTWAs";
    private final ManeuverSpeedDetailsStatisticAggregationProcessorHelper helper = new ManeuverSpeedDetailsStatisticAggregationProcessorHelper(MedianManeuverSpeedDetailsAggregationCreator.class);
    private static final AggregationProcessorDefinition<ManeuverSpeedDetailsStatistic, ManeuverSpeedDetailsAggregation> DEFINITION = new SimpleAggregationProcessorDefinition(ManeuverSpeedDetailsStatistic.class, ManeuverSpeedDetailsAggregation.class, "MedianTrendForTWAs", ManeuverSpeedDetailsStatisticMedianAggregationProcessor.class);

    public ManeuverSpeedDetailsStatisticMedianAggregationProcessor(ExecutorService executor, Collection<Processor<Map<GroupKey, ManeuverSpeedDetailsAggregation>, ?>> resultReceivers) {
        super(executor, resultReceivers, MESSAGE_KEY);
    }

    public static AggregationProcessorDefinition<ManeuverSpeedDetailsStatistic, ManeuverSpeedDetailsAggregation> getDefinition() {
        return DEFINITION;
    }

    protected void storeElement(GroupedDataEntry<ManeuverSpeedDetailsStatistic> element) {
        this.helper.storeElement(element);
    }

    protected Map<GroupKey, ManeuverSpeedDetailsAggregation> aggregateResult() {
        return this.helper.aggregateResult();
    }

    static class MedianManeuverSpeedDetailsAggregationCreator
    implements ManeuverSpeedDetailsStatisticAggregationProcessorHelper.ManeuverSpeedDetailsAggregationCreator {
        private int count = 0;
        private ArrayList<Double>[] valuesPerTWA = MedianManeuverSpeedDetailsAggregationCreator.initValuesPerAngle();

        MedianManeuverSpeedDetailsAggregationCreator() {
        }

        private static ArrayList<Double>[] initValuesPerAngle() {
            ArrayList[] valuesPerAngle = new ArrayList[360];
            int i = 0;
            while (i < 360) {
                valuesPerAngle[i] = new ArrayList(1000);
                ++i;
            }
            return valuesPerAngle;
        }

        @Override
        public void addElement(ManeuverSpeedDetailsStatistic dataEntry) {
            double[] maneuverValuePerTWA = dataEntry.getManeuverValuePerTWA();
            int i = 0;
            while (i < maneuverValuePerTWA.length) {
                if (maneuverValuePerTWA[i] != 0.0) {
                    this.valuesPerTWA[i].add(maneuverValuePerTWA[i]);
                }
                ++i;
            }
            ++this.count;
        }

        public ManeuverSpeedDetailsAggregationImpl aggregateResult() {
            double[] valuePerTWA = new double[360];
            int[] countPerTWA = new int[360];
            int i = 0;
            while (i < 360) {
                ArrayList<Double> valuesList = this.valuesPerTWA[i];
                int size = valuesList.size();
                if (size > 0) {
                    double[] values = new double[size];
                    int j = 0;
                    for (double value : valuesList) {
                        values[j++] = value;
                    }
                    Arrays.sort(values);
                    int middle = size / 2;
                    valuePerTWA[i] = size % 2 == 1 ? values[middle] : (values[middle - 1] + values[middle]) / 2.0;
                }
                countPerTWA[i] = size;
                ++i;
            }
            return new ManeuverSpeedDetailsAggregationImpl(valuePerTWA, countPerTWA, this.count);
        }
    }
}

