/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.components.aggregators;

import com.sap.sailing.datamining.data.ManeuverSpeedDetailsStatistic;
import com.sap.sailing.datamining.impl.components.aggregators.ManeuverSpeedDetailsStatisticAggregationProcessorHelper;
import com.sap.sailing.datamining.shared.ManeuverSpeedDetailsAggregation;
import com.sap.sailing.datamining.shared.ManeuverSpeedDetailsAggregationImpl;
import com.sap.sse.datamining.components.AggregationProcessorDefinition;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.GroupedDataEntry;
import com.sap.sse.datamining.impl.components.SimpleAggregationProcessorDefinition;
import com.sap.sse.datamining.impl.components.aggregators.AbstractParallelGroupedDataAggregationProcessor;
import com.sap.sse.datamining.shared.GroupKey;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class ManeuverSpeedDetailsStatisticAvgAggregationProcessor
extends AbstractParallelGroupedDataAggregationProcessor<ManeuverSpeedDetailsStatistic, ManeuverSpeedDetailsAggregation> {
    private static final String MESSAGE_KEY = "AvgTrendForTWAs";
    private final ManeuverSpeedDetailsStatisticAggregationProcessorHelper helper = new ManeuverSpeedDetailsStatisticAggregationProcessorHelper(AvgManeuverSpeedDetailsAggregationCreator.class);
    private static final AggregationProcessorDefinition<ManeuverSpeedDetailsStatistic, ManeuverSpeedDetailsAggregation> DEFINITION = new SimpleAggregationProcessorDefinition(ManeuverSpeedDetailsStatistic.class, ManeuverSpeedDetailsAggregation.class, "AvgTrendForTWAs", ManeuverSpeedDetailsStatisticAvgAggregationProcessor.class);

    public ManeuverSpeedDetailsStatisticAvgAggregationProcessor(ExecutorService executor, Collection<Processor<Map<GroupKey, ManeuverSpeedDetailsAggregation>, ?>> resultReceivers) {
        super(executor, resultReceivers, MESSAGE_KEY);
    }

    public static AggregationProcessorDefinition<ManeuverSpeedDetailsStatistic, ManeuverSpeedDetailsAggregation> getDefinition() {
        return DEFINITION;
    }

    protected void handleElement(GroupedDataEntry<ManeuverSpeedDetailsStatistic> element) {
        this.helper.storeElement(element);
    }

    protected Map<GroupKey, ManeuverSpeedDetailsAggregation> getResult() {
        return this.helper.aggregateResult();
    }

    static class AvgManeuverSpeedDetailsAggregationCreator
    implements ManeuverSpeedDetailsStatisticAggregationProcessorHelper.ManeuverSpeedDetailsAggregationCreator {
        private double[] sumValuesPerTWA = new double[360];
        private int[] countPerTWA = new int[360];
        private int count = 0;

        AvgManeuverSpeedDetailsAggregationCreator() {
        }

        @Override
        public void addElement(ManeuverSpeedDetailsStatistic dataEntry) {
            double[] maneuverValuePerTWA = dataEntry.getManeuverValuePerTWA();
            int i = 0;
            while (i < maneuverValuePerTWA.length) {
                if (maneuverValuePerTWA[i] != 0.0) {
                    int n = i;
                    this.sumValuesPerTWA[n] = this.sumValuesPerTWA[n] + maneuverValuePerTWA[i];
                    int n2 = i;
                    this.countPerTWA[n2] = this.countPerTWA[n2] + 1;
                }
                ++i;
            }
            ++this.count;
        }

        public ManeuverSpeedDetailsAggregationImpl aggregateResult() {
            double[] averages = new double[360];
            int i = 0;
            while (i < 360) {
                if (this.countPerTWA[i] > 0) {
                    averages[i] = this.sumValuesPerTWA[i] / (double)this.countPerTWA[i];
                }
                ++i;
            }
            return new ManeuverSpeedDetailsAggregationImpl(averages, this.countPerTWA, this.count);
        }
    }
}

