/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.polars.mining;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.SpeedWithConfidence;
import com.sap.sailing.domain.base.impl.SpeedWithConfidenceImpl;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.impl.KnotSpeedImpl;
import com.sap.sailing.domain.common.polars.NotEnoughDataHasBeenAddedException;
import com.sap.sailing.domain.polars.PolarsChangedListener;
import com.sap.sailing.polars.impl.CubicEquation;
import com.sap.sailing.polars.mining.AngleClusterPolarClusterKey;
import com.sap.sailing.polars.mining.CubicRegressionPerCourseProcessor;
import com.sap.sailing.polars.mining.GPSFixMovingWithPolarContext;
import com.sap.sailing.polars.mining.PolarDataDimensionCollectionFactory;
import com.sap.sailing.polars.regression.IncrementalLeastSquares;
import com.sap.sailing.polars.regression.impl.IncrementalAnyOrderLeastSquaresImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Speed;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.datamining.components.AdditionalResultDataBuilder;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.data.Cluster;
import com.sap.sse.datamining.data.ClusterGroup;
import com.sap.sse.datamining.factories.GroupKeyFactory;
import com.sap.sse.datamining.impl.components.GroupedDataEntry;
import com.sap.sse.datamining.shared.GroupKey;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import org.apache.commons.math.analysis.polynomials.PolynomialFunction;

public class SpeedRegressionPerAngleClusterProcessor
implements Processor<GroupedDataEntry<GPSFixMovingWithPolarContext>, Void>,
Serializable {
    private static final long serialVersionUID = 3279917556091599077L;
    private static final Logger logger = Logger.getLogger(CubicRegressionPerCourseProcessor.class.getName());
    private final Map<GroupKey, IncrementalLeastSquares> regressions = new HashMap<GroupKey, IncrementalLeastSquares>();
    private final Map<BoatClass, Long> fixCountPerBoatClass = new HashMap<BoatClass, Long>();
    private final ClusterGroup<Bearing> angleClusterGroup;
    private transient ConcurrentMap<BoatClass, Set<PolarsChangedListener>> listeners;

    public SpeedRegressionPerAngleClusterProcessor(ClusterGroup<Bearing> angleClusterGroup) {
        this.angleClusterGroup = angleClusterGroup;
    }

    public boolean canProcessElements() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processElement(GroupedDataEntry<GPSFixMovingWithPolarContext> element) {
        IncrementalLeastSquares regression;
        GroupKey key = element.getKey();
        BoatClass boatClass = ((GPSFixMovingWithPolarContext)element.getDataEntry()).getBoatClass();
        Map<Object, Serializable> map = this.fixCountPerBoatClass;
        synchronized (map) {
            if (!this.fixCountPerBoatClass.containsKey(boatClass)) {
                this.fixCountPerBoatClass.put(boatClass, 0L);
            }
            this.fixCountPerBoatClass.put(boatClass, this.fixCountPerBoatClass.get(boatClass) + 1L);
        }
        map = this.regressions;
        synchronized (map) {
            regression = this.regressions.get(key);
            if (regression == null) {
                regression = new IncrementalAnyOrderLeastSquaresImpl(3, false);
                this.regressions.put(key, regression);
            }
        }
        GPSFixMovingWithPolarContext fix = (GPSFixMovingWithPolarContext)element.getDataEntry();
        regression.addData(((Wind)fix.getWind().getObject()).getKnots(), fix.getBoatSpeed().getObject().getKnots());
        Set listenersForBoatClass = (Set)this.listeners.get(fix.getBoatClass());
        if (listenersForBoatClass != null) {
            for (PolarsChangedListener listener : listenersForBoatClass) {
                listener.polarsChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpeedWithConfidence<Void> estimateBoatSpeed(BoatClass boatClass, Speed windSpeed, Bearing trueWindAngle) throws NotEnoughDataHasBeenAddedException {
        Object incrementalLeastSquares;
        double speedSum = 0.0;
        double numberOfSpeeds = 0.0;
        long fixCount = 0L;
        int i = -2;
        while (i <= 2) {
            GroupKey key = this.createGroupKey(boatClass, (Bearing)new DegreeBearingImpl(Math.abs(trueWindAngle.getDegrees()) + (double)i));
            if (this.regressions.containsKey(key) && (fixCount += (incrementalLeastSquares = this.regressions.get(key)).getNumberOfAddedPoints()) > 10L) {
                speedSum += incrementalLeastSquares.getOrCreatePolynomialFunction().value(windSpeed.getKnots());
                numberOfSpeeds += 1.0;
            }
            ++i;
        }
        fixCount = (long)((double)fixCount / numberOfSpeeds);
        long fixCountOverall = 0L;
        if (numberOfSpeeds < 2.0 || fixCount < 10L) {
            throw new NotEnoughDataHasBeenAddedException("Not enough data has been added to Per Course Regressions");
        }
        incrementalLeastSquares = this.fixCountPerBoatClass;
        synchronized (incrementalLeastSquares) {
            fixCountOverall = this.fixCountPerBoatClass.get(boatClass);
        }
        KnotSpeedImpl speed = new KnotSpeedImpl(speedSum / numberOfSpeeds);
        return new SpeedWithConfidenceImpl((Speed)speed, Math.min(1.0, 5.0 * ((double)fixCount / (double)fixCountOverall)), null);
    }

    public Util.Pair<List<Speed>, Double> estimateWindSpeeds(BoatClass boatClass, Speed boatSpeed, Bearing trueWindAngle, double referenceTwsKnots) throws NotEnoughDataHasBeenAddedException {
        ArrayList<KnotSpeedImpl> windSpeeds = new ArrayList<KnotSpeedImpl>();
        int i = -2;
        while (i <= 2) {
            IncrementalLeastSquares incrementalLeastSquares;
            long fixesCount;
            GroupKey key = this.createGroupKey(boatClass, (Bearing)new DegreeBearingImpl(Math.abs(trueWindAngle.getDegrees()) + (double)i));
            if (this.regressions.containsKey(key) && (fixesCount = (incrementalLeastSquares = this.regressions.get(key)).getNumberOfAddedPoints()) > 10L) {
                double[] windSpeedCandidates;
                double[] coefficients = incrementalLeastSquares.getOrCreatePolynomialFunction().getCoefficients();
                CubicEquation equation = new CubicEquation(coefficients[3], coefficients[2], coefficients[1], -boatSpeed.getKnots());
                double bestWindSpeedCandidateInKnots = Double.MAX_VALUE;
                double bestOptimalSpeedDifference = Double.MAX_VALUE;
                double[] dArray = windSpeedCandidates = equation.solve();
                int n = windSpeedCandidates.length;
                int n2 = 0;
                while (n2 < n) {
                    double optimalSpeedDifference;
                    double windSpeedCandidateInKnots = dArray[n2];
                    if (windSpeedCandidateInKnots > 2.0 && windSpeedCandidateInKnots < 20.0 && (optimalSpeedDifference = Math.abs(referenceTwsKnots - windSpeedCandidateInKnots)) < bestOptimalSpeedDifference) {
                        bestOptimalSpeedDifference = optimalSpeedDifference;
                        bestWindSpeedCandidateInKnots = windSpeedCandidateInKnots;
                    }
                    ++n2;
                }
                if (bestWindSpeedCandidateInKnots != Double.MAX_VALUE) {
                    windSpeeds.add(new KnotSpeedImpl(bestWindSpeedCandidateInKnots));
                }
            }
            ++i;
        }
        return new Util.Pair(windSpeeds, (Object)Math.min(1.0, 0.5));
    }

    private GroupKey createGroupKey(final BoatClass boatClass, final Bearing angle) {
        GroupKey compoundKey;
        AngleClusterPolarClusterKey key = new AngleClusterPolarClusterKey(){

            @Override
            public BoatClass getBoatClass() {
                return boatClass;
            }

            @Override
            public Cluster<Bearing> getAngleCluster() {
                return SpeedRegressionPerAngleClusterProcessor.this.angleClusterGroup.getClusterFor((Serializable)angle);
            }
        };
        try {
            compoundKey = GroupKeyFactory.createNestingCompoundKeyFor((Object)key, PolarDataDimensionCollectionFactory.getSpeedRegressionPerAngleClusterClusterKeyDimensions());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return compoundKey;
    }

    public void onFailure(Throwable failure) {
        logger.severe("Polar Data Mining Pipe failed.");
        throw new RuntimeException("Polar Data Miner failed.", failure);
    }

    public PolynomialFunction getSpeedRegressionFunction(BoatClass boatClass, double trueWindAngle) throws NotEnoughDataHasBeenAddedException {
        GroupKey key = this.createGroupKey(boatClass, (Bearing)new DegreeBearingImpl(trueWindAngle));
        if (!this.regressions.containsKey(key)) {
            throw new NotEnoughDataHasBeenAddedException();
        }
        PolynomialFunction polynomialFunction = this.regressions.get(key).getOrCreatePolynomialFunction();
        return polynomialFunction;
    }

    public void setListeners(ConcurrentMap<BoatClass, Set<PolarsChangedListener>> listeners) {
        this.listeners = listeners;
    }

    Set<BoatClass> getAvailableBoatClasses() {
        return Collections.unmodifiableSet(this.fixCountPerBoatClass.keySet());
    }

    public Class<GroupedDataEntry<GPSFixMovingWithPolarContext>> getInputType() {
        return null;
    }

    public Class<Void> getResultType() {
        return null;
    }

    public void finish() throws InterruptedException {
    }

    public boolean isFinished() {
        return false;
    }

    public void abort() {
    }

    public boolean isAborted() {
        return false;
    }

    public AdditionalResultDataBuilder getAdditionalResultData(AdditionalResultDataBuilder additionalDataBuilder) {
        return null;
    }

    public ClusterGroup<Bearing> getAngleCluster() {
        return this.angleClusterGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<GroupKey, IncrementalAnyOrderLeastSquaresImpl> getRegressionsImpl() {
        Map<GroupKey, IncrementalLeastSquares> map = this.regressions;
        synchronized (map) {
            HashMap map2 = new HashMap();
            this.regressions.keySet().stream().forEach(key -> {
                IncrementalAnyOrderLeastSquaresImpl incrementalAnyOrderLeastSquaresImpl = map2.put(key, (IncrementalAnyOrderLeastSquaresImpl)this.regressions.get(key));
            });
            return Collections.unmodifiableMap(map2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<BoatClass, Long> getFixCountPerBoatClass() {
        Map<BoatClass, Long> map = this.fixCountPerBoatClass;
        synchronized (map) {
            return Collections.unmodifiableMap(this.fixCountPerBoatClass);
        }
    }
}

