/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sailing.domain.maneuverdetection.ManeuverMainCurveWithEstimationData;
import com.sap.sailing.domain.tracking.ManeuverCurveBoundaries;
import com.sap.sailing.server.gateway.serialization.impl.ManeuverCurveBoundariesJsonSerializer;
import org.json.simple.JSONObject;

public class ManeuverMainCurveWithEstimationDataJsonSerializer
extends ManeuverCurveBoundariesJsonSerializer {
    public static final String AVG_TURNING_RATE_IN_DEGREES_PER_SECOND = "avgTurningRateInDegreesPerSecond";
    public static final String MAX_TURNING_RATE_IN_DEGREES_PER_SECOND = "maxTurningRateInDegreesPerSecond";
    public static final String COURSE_AT_LOWEST_SPEED = "courseAtLowestSpeed";
    public static final String COURSE_AT_HIGHEST_SPEED = "courseAtHighestSpeed";
    public static final String LOWEST_SPEED_TIMEPOINT = "lowestSpeedTimePoint";
    public static final String HIGHEST_SPEED_TIMEPOINT = "highestSpeedTimePoint";
    public static final String COURSE_AT_MAX_TURNING_RATE = "courseAtMaxTurningRate";
    public static final String MAX_TURNING_RATE_TIMEPOINT = "maxTurningRateTimePoint";
    public static final String GPS_FIXES_COUNT = "gpsFixesCount";
    public static final String LONGEST_INTERVAL_BETWEEN_TWO_FIXES = "longestIntervalBetweenTwoFixesInSeconds";

    @Override
    public JSONObject serialize(ManeuverCurveBoundaries maneuverBoundaries) {
        JSONObject result = super.serialize(maneuverBoundaries);
        if (maneuverBoundaries instanceof ManeuverMainCurveWithEstimationData) {
            ManeuverMainCurveWithEstimationData mainCurve = (ManeuverMainCurveWithEstimationData)maneuverBoundaries;
            result.put((Object)AVG_TURNING_RATE_IN_DEGREES_PER_SECOND, (Object)mainCurve.getAvgTurningRateInDegreesPerSecond());
            result.put((Object)MAX_TURNING_RATE_IN_DEGREES_PER_SECOND, (Object)mainCurve.getMaxTurningRateInDegreesPerSecond());
            result.put((Object)COURSE_AT_LOWEST_SPEED, (Object)mainCurve.getLowestSpeed().getBearing().getDegrees());
            result.put((Object)COURSE_AT_HIGHEST_SPEED, (Object)mainCurve.getHighestSpeed().getBearing().getDegrees());
            result.put((Object)LOWEST_SPEED_TIMEPOINT, (Object)mainCurve.getLowestSpeedTimePoint().asMillis());
            result.put((Object)HIGHEST_SPEED_TIMEPOINT, (Object)mainCurve.getHighestSpeedTimePoint().asMillis());
            result.put((Object)COURSE_AT_MAX_TURNING_RATE, (Object)mainCurve.getCourseAtMaxTurningRate().getDegrees());
            result.put((Object)MAX_TURNING_RATE_TIMEPOINT, (Object)mainCurve.getTimePointOfMaxTurningRate().asMillis());
            result.put((Object)GPS_FIXES_COUNT, (Object)mainCurve.getGpsFixesCount());
            result.put((Object)LONGEST_INTERVAL_BETWEEN_TWO_FIXES, (Object)mainCurve.getLongestIntervalBetweenTwoFixes().asSeconds());
        }
        return result;
    }
}

