/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.impl;

import com.sap.sailing.domain.abstractlog.regatta.tracking.analyzing.impl.RegattaLogDeviceMappingFinder;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.common.PassingInstruction;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.impl.GPSFixImpl;
import com.sap.sailing.domain.coursetemplate.ControlPointWithMarkConfiguration;
import com.sap.sailing.domain.coursetemplate.CourseConfiguration;
import com.sap.sailing.domain.coursetemplate.CourseTemplate;
import com.sap.sailing.domain.coursetemplate.CourseTemplateCompatibilityChecker;
import com.sap.sailing.domain.coursetemplate.FixedPositioning;
import com.sap.sailing.domain.coursetemplate.FreestyleMarkConfiguration;
import com.sap.sailing.domain.coursetemplate.FreestyleMarkProperties;
import com.sap.sailing.domain.coursetemplate.MarkConfiguration;
import com.sap.sailing.domain.coursetemplate.MarkConfigurationRequestAnnotation;
import com.sap.sailing.domain.coursetemplate.MarkConfigurationResponseAnnotation;
import com.sap.sailing.domain.coursetemplate.MarkPairWithConfiguration;
import com.sap.sailing.domain.coursetemplate.MarkProperties;
import com.sap.sailing.domain.coursetemplate.MarkPropertiesBasedMarkConfiguration;
import com.sap.sailing.domain.coursetemplate.MarkRole;
import com.sap.sailing.domain.coursetemplate.MarkTemplate;
import com.sap.sailing.domain.coursetemplate.MarkTemplateBasedMarkConfiguration;
import com.sap.sailing.domain.coursetemplate.Positioning;
import com.sap.sailing.domain.coursetemplate.PositioningVisitor;
import com.sap.sailing.domain.coursetemplate.TrackingDeviceBasedPositioning;
import com.sap.sailing.domain.coursetemplate.WaypointWithMarkConfiguration;
import com.sap.sailing.domain.coursetemplate.impl.CourseConfigurationImpl;
import com.sap.sailing.domain.coursetemplate.impl.FreestyleMarkConfigurationImpl;
import com.sap.sailing.domain.coursetemplate.impl.MarkConfigurationRequestAnnotationImpl;
import com.sap.sailing.domain.coursetemplate.impl.MarkConfigurationResponseAnnotationImpl;
import com.sap.sailing.domain.coursetemplate.impl.MarkPairWithConfigurationImpl;
import com.sap.sailing.domain.coursetemplate.impl.MarkPropertiesBasedMarkConfigurationImpl;
import com.sap.sailing.domain.coursetemplate.impl.MarkTemplateBasedMarkConfigurationImpl;
import com.sap.sailing.domain.coursetemplate.impl.RegattaMarkConfigurationImpl;
import com.sap.sailing.domain.coursetemplate.impl.WaypointWithMarkConfigurationImpl;
import com.sap.sailing.domain.racelogtracking.DeviceMappingWithRegattaLogEvent;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.shared.server.SharedSailingData;
import com.sap.sse.common.RepeatablePart;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CourseConfigurationBuilder {
    private final SharedSailingData sharedSailingData;
    private final Regatta optionalRegatta;
    private final CourseTemplate optionalCourseTemplate;
    private final String name;
    private final String shortName;
    private final URL optionalImageUrl;
    private Set<MarkConfiguration<MarkConfigurationRequestAnnotation>> markConfigurations = new HashSet<MarkConfiguration<MarkConfigurationRequestAnnotation>>();
    private Map<MarkConfiguration<MarkConfigurationRequestAnnotation>, MarkRole> associatedRoles = new HashMap<MarkConfiguration<MarkConfigurationRequestAnnotation>, MarkRole>();
    private List<WaypointWithMarkConfiguration<MarkConfigurationRequestAnnotation>> waypoints = new ArrayList<WaypointWithMarkConfiguration<MarkConfigurationRequestAnnotation>>();
    private RepeatablePart optionalRepeatablePart;
    private Integer numberOfLaps;
    private Map<MarkPairWithConfiguration<MarkConfigurationRequestAnnotation>, MarkPairWithConfiguration<MarkConfigurationRequestAnnotation>> markPairCache = new HashMap<MarkPairWithConfiguration<MarkConfigurationRequestAnnotation>, MarkPairWithConfiguration<MarkConfigurationRequestAnnotation>>();

    public CourseConfigurationBuilder(SharedSailingData sharedSailingData, Regatta optionalRegatta, CourseTemplate optionalCourseTemplate, String name, String shortName, URL optionalImageUrl) {
        this.sharedSailingData = sharedSailingData;
        this.optionalRegatta = optionalRegatta;
        this.optionalCourseTemplate = optionalCourseTemplate;
        this.name = name;
        this.shortName = shortName;
        this.optionalImageUrl = optionalImageUrl;
    }

    public MarkConfiguration<MarkConfigurationRequestAnnotation> addMarkConfiguration(UUID optionalMarkTemplateID, UUID optionalMarkPropertiesID, UUID optionalMarkID, FreestyleMarkProperties commonMarkProperties, Positioning optionalPositioning, boolean storeToInventory, MarkConfigurationRequestAnnotation.MarkRoleCreationRequest optionalMarkRoleCreationRequest) {
        MarkConfiguration<MarkConfigurationRequestAnnotation> result;
        MarkConfigurationRequestAnnotationImpl markConfigurationRequestAnnotation = new MarkConfigurationRequestAnnotationImpl(storeToInventory, optionalPositioning, optionalMarkRoleCreationRequest);
        if (commonMarkProperties != null) {
            if (optionalMarkID != null) {
                throw new IllegalArgumentException("Freestyle mark configurations may not reference an existing regatta mark");
            }
            result = this.addFreestyleMarkConfiguration(optionalMarkTemplateID, optionalMarkPropertiesID, commonMarkProperties, (MarkConfigurationRequestAnnotation)markConfigurationRequestAnnotation);
        } else if (optionalMarkID != null) {
            result = this.addRegattaMarkConfiguration(optionalMarkID, (MarkConfigurationRequestAnnotation)markConfigurationRequestAnnotation);
        } else if (optionalMarkPropertiesID != null) {
            result = this.addMarkPropertiesConfiguration(optionalMarkPropertiesID, optionalMarkTemplateID, (MarkConfigurationRequestAnnotation)markConfigurationRequestAnnotation);
        } else if (optionalMarkTemplateID != null) {
            result = this.addMarkTemplateConfiguration(optionalMarkTemplateID, (MarkConfigurationRequestAnnotation)markConfigurationRequestAnnotation);
        } else {
            throw new IllegalArgumentException("Mark configuration could not be constructed due to missing specification");
        }
        this.markConfigurations.add(result);
        return result;
    }

    public MarkTemplateBasedMarkConfiguration<MarkConfigurationRequestAnnotation> addMarkTemplateConfiguration(UUID markTemplateID, MarkConfigurationRequestAnnotation markConfigurationRequestAnnotation) {
        MarkTemplate resolvedMarkTemplate = this.resolveMarkTemplateByID(markTemplateID);
        if (resolvedMarkTemplate == null) {
            throw new IllegalStateException("Mark template with ID " + markTemplateID + " could not be resolved");
        }
        MarkTemplateBasedMarkConfigurationImpl result = new MarkTemplateBasedMarkConfigurationImpl(resolvedMarkTemplate, (Object)markConfigurationRequestAnnotation);
        this.markConfigurations.add((MarkConfiguration<MarkConfigurationRequestAnnotation>)result);
        return result;
    }

    private MarkTemplate resolveMarkTemplateByID(UUID markTemplateID) {
        MarkTemplate resolvedMarkTemplate = null;
        if (this.optionalCourseTemplate != null) {
            resolvedMarkTemplate = this.optionalCourseTemplate.getMarkTemplateByIdIfContainedInCourseTemplate(markTemplateID);
        }
        if (resolvedMarkTemplate == null) {
            resolvedMarkTemplate = this.sharedSailingData.getMarkTemplateById(markTemplateID);
        }
        return resolvedMarkTemplate;
    }

    private MarkRole resolveMarkRoleByID(UUID markRoleID) {
        MarkRole resolvedMarkRole = null;
        if (this.optionalCourseTemplate != null) {
            resolvedMarkRole = this.optionalCourseTemplate.getMarkRoleByIdIfContainedInCourseTemplate(markRoleID);
        }
        if (resolvedMarkRole == null) {
            resolvedMarkRole = this.sharedSailingData.getMarkRoleById(markRoleID);
        }
        return resolvedMarkRole;
    }

    public MarkPropertiesBasedMarkConfiguration<MarkConfigurationRequestAnnotation> addMarkPropertiesConfiguration(UUID markPropertiesID, UUID optionalMarkTemplateID, MarkConfigurationRequestAnnotation markConfigurationRequestAnnotation) {
        MarkProperties resolvedMarkProperties = this.sharedSailingData.getMarkPropertiesById(markPropertiesID);
        if (resolvedMarkProperties == null) {
            throw new IllegalArgumentException("Mark properties with ID " + markPropertiesID + " could not be resolved");
        }
        MarkTemplate resolvedMarkTemplate = optionalMarkTemplateID == null ? null : this.resolveMarkTemplateByID(optionalMarkTemplateID);
        MarkPropertiesBasedMarkConfigurationImpl result = new MarkPropertiesBasedMarkConfigurationImpl(resolvedMarkProperties, resolvedMarkTemplate, (Object)markConfigurationRequestAnnotation);
        this.markConfigurations.add((MarkConfiguration<MarkConfigurationRequestAnnotation>)result);
        return result;
    }

    public FreestyleMarkConfiguration<MarkConfigurationRequestAnnotation> addFreestyleMarkConfiguration(UUID optionalMarkTemplateID, UUID optionalMarkPropertiesID, FreestyleMarkProperties commonMarkProperties, MarkConfigurationRequestAnnotation markConfigurationRequestAnnotation) {
        MarkTemplate resolvedMarkTemplate = optionalMarkTemplateID == null ? null : this.resolveMarkTemplateByID(optionalMarkTemplateID);
        MarkProperties resolvedMarkProperties = this.sharedSailingData.getMarkPropertiesById(optionalMarkPropertiesID);
        FreestyleMarkConfigurationImpl result = new FreestyleMarkConfigurationImpl(resolvedMarkTemplate, resolvedMarkProperties, commonMarkProperties, (Object)markConfigurationRequestAnnotation);
        this.markConfigurations.add((MarkConfiguration<MarkConfigurationRequestAnnotation>)result);
        return result;
    }

    public MarkConfiguration<MarkConfigurationRequestAnnotation> addRegattaMarkConfiguration(UUID markID, MarkConfigurationRequestAnnotation markConfigurationRequestAnnotation) {
        if (this.optionalRegatta == null) {
            throw new IllegalStateException("Require a valid regatta in CourseConfigurationBuilder to add regatta mark with ID " + markID);
        }
        for (RaceColumn raceColumn : this.optionalRegatta.getRaceColumns()) {
            for (Mark mark : raceColumn.getAvailableMarks()) {
                if (!mark.getId().equals(markID)) continue;
                UUID markTemplateIdOrNull = mark.getOriginatingMarkTemplateIdOrNull();
                MarkTemplate markTemplateOrNull = markTemplateIdOrNull == null ? null : this.resolveMarkTemplateByID(markTemplateIdOrNull);
                UUID markPropertiesIdOrNull = mark.getOriginatingMarkPropertiesIdOrNull();
                MarkProperties markPropertiesOrNull = markPropertiesIdOrNull == null ? null : this.sharedSailingData.getMarkPropertiesById(markPropertiesIdOrNull);
                RegattaMarkConfigurationImpl result = new RegattaMarkConfigurationImpl(mark, (Object)markConfigurationRequestAnnotation, markTemplateOrNull, markPropertiesOrNull);
                this.markConfigurations.add((MarkConfiguration<MarkConfigurationRequestAnnotation>)result);
                return result;
            }
        }
        throw new IllegalArgumentException("Mark " + markID + " could not be found in regatta " + this.optionalRegatta.getName());
    }

    public void addWaypoint(MarkConfiguration<MarkConfigurationRequestAnnotation> markConfiguration, PassingInstruction passingInstruction) {
        if (!this.markConfigurations.contains(markConfiguration)) {
            throw new IllegalArgumentException();
        }
        this.waypoints.add((WaypointWithMarkConfiguration<MarkConfigurationRequestAnnotation>)new WaypointWithMarkConfigurationImpl(markConfiguration, passingInstruction));
    }

    public void addWaypoint(MarkConfiguration<MarkConfigurationRequestAnnotation> leftMark, MarkConfiguration<MarkConfigurationRequestAnnotation> rightMark, String name, PassingInstruction passingInstruction, String shortNameForMarkPair) {
        if (!this.markConfigurations.contains(leftMark) || !this.markConfigurations.contains(rightMark)) {
            throw new IllegalArgumentException();
        }
        MarkPairWithConfiguration markPair = this.markPairCache.computeIfAbsent((MarkPairWithConfiguration<MarkConfigurationRequestAnnotation>)new MarkPairWithConfigurationImpl(name, leftMark, rightMark, shortNameForMarkPair), mp -> mp);
        this.waypoints.add((WaypointWithMarkConfiguration<MarkConfigurationRequestAnnotation>)new WaypointWithMarkConfigurationImpl((ControlPointWithMarkConfiguration)markPair, passingInstruction));
    }

    public void setRole(MarkConfiguration<MarkConfigurationRequestAnnotation> markConfiguration, UUID markRoleId) {
        if (!this.markConfigurations.contains(markConfiguration)) {
            throw new IllegalArgumentException();
        }
        if (markRoleId != null) {
            MarkRole candidate = this.resolveMarkRoleByID(markRoleId);
            this.associatedRoles.put(markConfiguration, candidate);
        }
    }

    public void setOptionalRepeatablePart(RepeatablePart optionalRepeatablePart) {
        this.optionalRepeatablePart = optionalRepeatablePart;
    }

    public void setNumberOfLaps(Integer numberOfLaps) {
        this.numberOfLaps = numberOfLaps;
    }

    private Integer checkComplianceWithCourseTemplate() {
        Integer numberOfLaps = this.optionalCourseTemplate == null ? null : new CourseTemplateCompatibilityCheckerForBuilder().isCourseInstanceOfCourseTemplate();
        return numberOfLaps;
    }

    public CourseConfiguration<MarkConfigurationRequestAnnotation> build() {
        Integer compliantOrNull = this.checkComplianceWithCourseTemplate();
        return new CourseConfigurationImpl(compliantOrNull == null ? null : this.optionalCourseTemplate, this.markConfigurations, this.associatedRoles, this.waypoints, this.optionalRepeatablePart, compliantOrNull == null ? null : this.numberOfLaps, this.name, this.shortName, this.optionalImageUrl);
    }

    public static MarkConfigurationResponseAnnotation getPositioningIfAvailable(Regatta regatta, TrackedRace optionalRace, Mark mark, Function<DeviceIdentifier, GPSFix> positionResolver) {
        return CourseConfigurationBuilder.createMarkConfigurationResponseAnnotation(optionalRace, mark, CourseConfigurationBuilder.findAllDevicesAndMappedRangesForMark(regatta, mark, positionResolver));
    }

    private static MarkConfigurationResponseAnnotation createMarkConfigurationResponseAnnotation(Function<DeviceIdentifier, GPSFix> positionResolver, DeviceIdentifier identifier) {
        GPSFix position = identifier != null ? positionResolver.apply(identifier) : null;
        return new MarkConfigurationResponseAnnotationImpl(position, identifier);
    }

    private static MarkConfigurationResponseAnnotation createMarkConfigurationResponseAnnotation(TrackedRace optionalRace, Mark mark, Iterable<Util.Triple<DeviceIdentifier, TimeRange, GPSFix>> deviceMappings) {
        GPSFixTrack trackForMark;
        GPSFix position = null;
        if (optionalRace != null && (trackForMark = optionalRace.getTrack(mark)) != null) {
            position = (GPSFix)trackForMark.getLastFixAtOrBefore(MillisecondsTimePoint.now());
        }
        if (position == null) {
            position = CourseConfigurationBuilder.findGpsFixForMostRecentOrOngoingMapping(deviceMappings);
        }
        return new MarkConfigurationResponseAnnotationImpl(position, deviceMappings);
    }

    public static GPSFix findGpsFixForMostRecentOrOngoingMapping(Iterable<Util.Triple<DeviceIdentifier, TimeRange, GPSFix>> deviceMappings) {
        Util.Triple<DeviceIdentifier, TimeRange, GPSFix> bestMatchingDeviceMapping = null;
        for (Util.Triple<DeviceIdentifier, TimeRange, GPSFix> deviceMapping : deviceMappings) {
            if (deviceMapping.getC() == null || !(bestMatchingDeviceMapping == null || ((TimeRange)deviceMapping.getB()).hasOpenEnd() && !((TimeRange)bestMatchingDeviceMapping.getB()).hasOpenEnd() || ((TimeRange)deviceMapping.getB()).hasOpenEnd() && ((TimeRange)bestMatchingDeviceMapping.getB()).hasOpenEnd() && ((TimeRange)deviceMapping.getB()).startsAfter((TimeRange)bestMatchingDeviceMapping.getB())) && (((TimeRange)deviceMapping.getB()).hasOpenEnd() || ((TimeRange)bestMatchingDeviceMapping.getB()).hasOpenEnd() || !((TimeRange)deviceMapping.getB()).endsAfter((TimeRange)bestMatchingDeviceMapping.getB()))) continue;
            bestMatchingDeviceMapping = deviceMapping;
        }
        return bestMatchingDeviceMapping == null ? null : (GPSFix)bestMatchingDeviceMapping.getC();
    }

    public static DeviceMappingWithRegattaLogEvent<Mark> findMostRecentOrOngoingMapping(Regatta regatta, Mark mark) {
        Map deviceMappings = (Map)new RegattaLogDeviceMappingFinder(regatta.getRegattaLog()).analyze();
        List foundMappings = (List)deviceMappings.get(mark);
        DeviceMappingWithRegattaLogEvent bestMatchingDeviceMapping = null;
        if (foundMappings != null) {
            for (DeviceMappingWithRegattaLogEvent event : foundMappings) {
                if (!(bestMatchingDeviceMapping == null || event.getTimeRange().hasOpenEnd() && !bestMatchingDeviceMapping.getTimeRange().hasOpenEnd() || event.getTimeRange().hasOpenEnd() && bestMatchingDeviceMapping.getTimeRange().hasOpenEnd() && event.getTimeRange().startsAfter(bestMatchingDeviceMapping.getTimeRange())) && (event.getTimeRange().hasOpenEnd() || bestMatchingDeviceMapping.getTimeRange().hasOpenEnd() || !event.getTimeRange().endsAfter(bestMatchingDeviceMapping.getTimeRange()))) continue;
                bestMatchingDeviceMapping = event;
            }
        }
        return bestMatchingDeviceMapping;
    }

    private static Iterable<Util.Triple<DeviceIdentifier, TimeRange, GPSFix>> findAllDevicesAndMappedRangesForMark(Regatta regatta, Mark mark, Function<DeviceIdentifier, GPSFix> positionResolver) {
        Map deviceMappings = (Map)new RegattaLogDeviceMappingFinder(regatta.getRegattaLog()).analyze();
        List foundMappings = (List)deviceMappings.get(mark);
        Iterable<Object> result = foundMappings == null ? Collections.emptySet() : (Iterable)foundMappings.stream().map(dm -> new Util.Triple((Object)dm.getDevice(), (Object)dm.getTimeRange(), (Object)((GPSFix)positionResolver.apply(dm.getDevice())))).collect(Collectors.toList());
        return result;
    }

    public static MarkConfigurationResponseAnnotation getPositioningIfAvailable(Positioning positioning, final Function<DeviceIdentifier, GPSFix> positionResolver) {
        MarkConfigurationResponseAnnotation result = positioning != null ? (MarkConfigurationResponseAnnotation)positioning.accept((PositioningVisitor)new PositioningVisitor<MarkConfigurationResponseAnnotation>(){

            public MarkConfigurationResponseAnnotation visit(FixedPositioning fixedPositioning) {
                return new MarkConfigurationResponseAnnotationImpl((GPSFix)new GPSFixImpl(fixedPositioning.getFixedPosition(), MillisecondsTimePoint.now()));
            }

            public MarkConfigurationResponseAnnotation visit(TrackingDeviceBasedPositioning trackingDeviceBasedPositioning) {
                return CourseConfigurationBuilder.createMarkConfigurationResponseAnnotation(positionResolver, trackingDeviceBasedPositioning.getDeviceIdentifier());
            }
        }) : null;
        return result;
    }

    private class CourseTemplateCompatibilityCheckerForBuilder
    extends CourseTemplateCompatibilityChecker<CourseConfigurationBuilder, MarkConfiguration<MarkConfigurationRequestAnnotation>, WaypointWithMarkConfiguration<MarkConfigurationRequestAnnotation>> {
        public CourseTemplateCompatibilityCheckerForBuilder() {
            super((Object)CourseConfigurationBuilder.this, CourseConfigurationBuilder.this.optionalCourseTemplate);
        }

        protected MarkRole getMarkRole(MarkConfiguration<MarkConfigurationRequestAnnotation> markFromCourse) {
            return (MarkRole)CourseConfigurationBuilder.this.associatedRoles.get(markFromCourse);
        }

        protected Iterable<MarkConfiguration<MarkConfigurationRequestAnnotation>> getMarks(WaypointWithMarkConfiguration<MarkConfigurationRequestAnnotation> waypoint) {
            return waypoint.getControlPoint().getMarkConfigurations();
        }

        protected Iterable<WaypointWithMarkConfiguration<MarkConfigurationRequestAnnotation>> getWaypoints(CourseConfigurationBuilder course) {
            assert (course == CourseConfigurationBuilder.this);
            return CourseConfigurationBuilder.this.waypoints;
        }
    }
}

