/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.spectator;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.NoSelectionModel;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SingleSelectionModel;
import com.sap.sailing.domain.common.dto.PlacemarkOrderDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.gwt.ui.adminconsole.LeaderboardConfigPanel;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.LeaderboardGroupDTO;
import com.sap.sailing.gwt.ui.shared.StrippedLeaderboardDTO;
import com.sap.sailing.gwt.ui.spectator.LeaderboardGroupOverviewPanel;
import com.sap.sailing.gwt.ui.spectator.LeaderboardGroupOverviewTableResources;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.BaseCelltable;
import com.sap.sse.gwt.client.player.Timer;
import com.sap.sse.gwt.client.shared.components.CollapsablePanel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class LeaderboardGroupOverviewPanel
extends FormPanel {
    public static final String STYLE_NAME_PREFIX = "groupOverviewPanel-";
    private static final AnchorTemplates ANCHORTEMPLATE = (AnchorTemplates)GWT.create(AnchorTemplates.class);
    private final SailingServiceAsync sailingService;
    private final ErrorReporter errorReporter;
    private final StringMessages stringMessages;
    private TextBox locationTextBox;
    private TextBox nameTextBox;
    private TextBox fromTextBox;
    private TextBox untilTextBox;
    private CheckBox onlyLiveCheckBox;
    private CellTable<LeaderboardGroupDTO> groupsTable;
    private ListDataProvider<LeaderboardGroupDTO> groupsDataProvider;
    private SingleSelectionModel<LeaderboardGroupDTO> groupsSelectionModel;
    private CollapsablePanel collapsableDetailsPanel;
    private Label noGroupSelectedLabel;
    private FlowPanel groupDetailsPanel;
    private HTML groupDescriptionHTML;
    private CellTable<StrippedLeaderboardDTO> leaderboardsTable;
    private ListDataProvider<StrippedLeaderboardDTO> leaderboardsDataProvider;
    private SingleSelectionModel<StrippedLeaderboardDTO> leaderboardsSelectionModel;
    private FlowPanel leaderboardDetailsPanel;
    private CellTable<RaceColumnDTO> racesTable;
    private NoSelectionModel<RaceColumnDTO> racesSelectionModel;
    private ListDataProvider<RaceColumnDTO> racesDataProvider;
    private List<LeaderboardGroupDTO> availableGroups;
    private final boolean showRaceDetails;
    private final Timer timerForClientServerOffset;

    public LeaderboardGroupOverviewPanel(SailingServiceAsync sailingService, ErrorReporter errorReporter, StringMessages stringMessages, boolean showRaceDetails) {
        this.showRaceDetails = showRaceDetails;
        this.sailingService = sailingService;
        this.errorReporter = errorReporter;
        this.stringMessages = stringMessages;
        this.timerForClientServerOffset = new Timer(Timer.PlayModes.Replay);
        this.availableGroups = new ArrayList();
        LeaderboardGroupOverviewTableResources tableResources = (LeaderboardGroupOverviewTableResources)GWT.create(LeaderboardGroupOverviewTableResources.class);
        FlowPanel mainPanel = new FlowPanel();
        this.setWidget((Widget)mainPanel);
        mainPanel.setSize("100%", "100%");
        mainPanel.add((Widget)this.createSearchGUI());
        mainPanel.add((Widget)this.createGroupsGUI(tableResources));
        mainPanel.add((Widget)this.createDetailsGUI(tableResources));
        this.loadGroups();
    }

    private CollapsablePanel createSearchGUI() {
        FlowPanel searchPanel = new FlowPanel();
        searchPanel.setWidth("100%");
        CollapsablePanel collapsableSearchPanel = new CollapsablePanel(this.stringMessages.searchEvents(), false);
        collapsableSearchPanel.setContent((Widget)searchPanel);
        collapsableSearchPanel.setCollapsingEnabled(false);
        collapsableSearchPanel.setOpen(true);
        collapsableSearchPanel.setWidth("100%");
        Label locationLabel = new Label(String.valueOf(this.stringMessages.location()) + ":");
        locationLabel.setStyleName("groupOverviewPanel-searchLabel");
        locationLabel.getElement().getStyle().setFloat(Style.Float.LEFT);
        searchPanel.add((Widget)locationLabel);
        this.locationTextBox = new TextBox();
        this.locationTextBox.setStyleName("groupOverviewPanel-searchInputField");
        this.locationTextBox.getElement().getStyle().setFloat(Style.Float.LEFT);
        this.locationTextBox.addKeyUpHandler((KeyUpHandler)new /* Unavailable Anonymous Inner Class!! */);
        searchPanel.add((Widget)this.locationTextBox);
        Label nameLabel = new Label(String.valueOf(this.stringMessages.name()) + ":");
        nameLabel.setStyleName("groupOverviewPanel-searchLabel");
        nameLabel.getElement().getStyle().setFloat(Style.Float.LEFT);
        searchPanel.add((Widget)nameLabel);
        this.nameTextBox = new TextBox();
        this.nameTextBox.setStyleName("groupOverviewPanel-searchInputField");
        this.nameTextBox.getElement().getStyle().setFloat(Style.Float.LEFT);
        this.nameTextBox.addKeyUpHandler((KeyUpHandler)new /* Unavailable Anonymous Inner Class!! */);
        searchPanel.add((Widget)this.nameTextBox);
        this.onlyLiveCheckBox = new CheckBox(this.stringMessages.onlyLiveEvents());
        this.onlyLiveCheckBox.setStyleName("groupOverviewPanel-searchCheckBox");
        this.onlyLiveCheckBox.getElement().getStyle().setFloat(Style.Float.LEFT);
        this.onlyLiveCheckBox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        searchPanel.add((Widget)this.onlyLiveCheckBox);
        Label fromDateLabel = new Label(String.valueOf(this.stringMessages.from()) + ":");
        fromDateLabel.setStyleName("groupOverviewPanel-searchLabel");
        fromDateLabel.getElement().getStyle().setFloat(Style.Float.LEFT);
        searchPanel.add((Widget)fromDateLabel);
        this.fromTextBox = new TextBox();
        this.fromTextBox.setStyleName("groupOverviewPanel-searchInputField");
        this.fromTextBox.getElement().getStyle().setFloat(Style.Float.LEFT);
        this.fromTextBox.addKeyUpHandler((KeyUpHandler)new /* Unavailable Anonymous Inner Class!! */);
        searchPanel.add((Widget)this.fromTextBox);
        Label toDateLabel = new Label(String.valueOf(this.stringMessages.until()) + ":");
        toDateLabel.setStyleName("groupOverviewPanel-searchLabel");
        toDateLabel.getElement().getStyle().setFloat(Style.Float.LEFT);
        searchPanel.add((Widget)toDateLabel);
        this.untilTextBox = new TextBox();
        this.untilTextBox.setStyleName("groupOverviewPanel-searchInputField");
        this.untilTextBox.getElement().setPropertyString("clear", "right");
        this.untilTextBox.addKeyUpHandler((KeyUpHandler)new /* Unavailable Anonymous Inner Class!! */);
        searchPanel.add((Widget)this.untilTextBox);
        return collapsableSearchPanel;
    }

    private CollapsablePanel createGroupsGUI(LeaderboardGroupOverviewTableResources tableResources) {
        FlowPanel groupPanel = new FlowPanel();
        groupPanel.setStyleName("groupOverviewPanel-groupPanel");
        CollapsablePanel collapsableGroupPanel = new CollapsablePanel(this.stringMessages.leaderboardGroups(), false);
        collapsableGroupPanel.setContent((Widget)groupPanel);
        collapsableGroupPanel.setOpen(true);
        collapsableGroupPanel.setWidth("100%");
        6 groupsLocationColumn = new /* Unavailable Anonymous Inner Class!! */;
        groupsLocationColumn.setSortable(true);
        LeaderboardConfigPanel.AnchorCell groupsNameAnchorCell = new LeaderboardConfigPanel.AnchorCell();
        7 groupsNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        groupsNameColumn.setSortable(true);
        8 groupsLeaderboardsColumn = new /* Unavailable Anonymous Inner Class!! */;
        groupsLeaderboardsColumn.setSortable(false);
        9 groupsStartDateColumn = new /* Unavailable Anonymous Inner Class!! */;
        groupsStartDateColumn.setSortable(true);
        this.groupsTable = new BaseCelltable(10000, (CellTable.Resources)tableResources);
        this.groupsTable.setWidth("100%");
        this.groupsSelectionModel = new SingleSelectionModel();
        this.groupsSelectionModel.addSelectionChangeHandler((SelectionChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
        this.groupsTable.setSelectionModel((SelectionModel)this.groupsSelectionModel);
        this.groupsTable.addColumn((Column)groupsLocationColumn, this.stringMessages.location());
        this.groupsTable.addColumn((Column)groupsNameColumn, this.stringMessages.name());
        this.groupsTable.addColumn((Column)groupsLeaderboardsColumn, this.stringMessages.leaderboards());
        this.groupsTable.addColumn((Column)groupsStartDateColumn, this.stringMessages.startDate());
        groupPanel.add((Widget)this.groupsTable);
        this.groupsDataProvider = new ListDataProvider();
        this.groupsDataProvider.addDataDisplay((HasData)this.groupsTable);
        ColumnSortEvent.ListHandler groupsListHandler = new ColumnSortEvent.ListHandler(this.groupsDataProvider.getList());
        groupsListHandler.setComparator((Column)groupsLocationColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        groupsListHandler.setComparator((Column)groupsNameColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        groupsListHandler.setComparator((Column)groupsStartDateColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        this.groupsTable.addColumnSortHandler((ColumnSortEvent.Handler)groupsListHandler);
        return collapsableGroupPanel;
    }

    private CollapsablePanel createDetailsGUI(LeaderboardGroupOverviewTableResources tableResources) {
        FlowPanel detailsPanel = new FlowPanel();
        detailsPanel.setStyleName("groupOverviewPanel-detailsPanel");
        this.collapsableDetailsPanel = new CollapsablePanel(this.stringMessages.details(), false);
        this.collapsableDetailsPanel.setContent((Widget)detailsPanel);
        this.collapsableDetailsPanel.setWidth("100%");
        this.noGroupSelectedLabel = new Label(this.stringMessages.noGroupSelected());
        detailsPanel.add((Widget)this.noGroupSelectedLabel);
        this.groupDetailsPanel = new FlowPanel();
        this.groupDetailsPanel.setVisible(false);
        this.groupDetailsPanel.setSize("100%", "100%");
        this.groupDetailsPanel.setStyleName("groupOverviewPanel-groupDetailsPanel");
        detailsPanel.add((Widget)this.groupDetailsPanel);
        this.groupDescriptionHTML = new HTML();
        this.groupDescriptionHTML.setStyleName("groupOverviewPanel-groupDescription");
        this.groupDetailsPanel.add((Widget)this.groupDescriptionHTML);
        Label groupDetailsLabel = new Label(String.valueOf(this.stringMessages.leaderboardsInGroup()) + ": ");
        groupDetailsLabel.getElement().getStyle().setPadding(5.0, Style.Unit.PX);
        this.groupDetailsPanel.add((Widget)groupDetailsLabel);
        14 leaderboardsLocationColumn = new /* Unavailable Anonymous Inner Class!! */;
        LeaderboardConfigPanel.AnchorCell leaderboardsNameAnchorCell = new LeaderboardConfigPanel.AnchorCell();
        15 leaderboardsNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        16 leaderboardsRacesColumn = new /* Unavailable Anonymous Inner Class!! */;
        17 leaderboardsStartDateColumn = new /* Unavailable Anonymous Inner Class!! */;
        this.leaderboardsTable = new BaseCelltable(10000, (CellTable.Resources)tableResources);
        this.leaderboardsTable.setWidth("100%");
        this.leaderboardsSelectionModel = new SingleSelectionModel();
        this.leaderboardsSelectionModel.addSelectionChangeHandler((SelectionChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
        this.leaderboardsTable.setSelectionModel((SelectionModel)this.leaderboardsSelectionModel);
        this.leaderboardsTable.addColumn((Column)leaderboardsLocationColumn, this.stringMessages.location());
        this.leaderboardsTable.addColumn((Column)leaderboardsNameColumn, this.stringMessages.name());
        this.leaderboardsTable.addColumn((Column)leaderboardsRacesColumn, this.stringMessages.races());
        this.leaderboardsTable.addColumn((Column)leaderboardsStartDateColumn, this.stringMessages.startDate());
        this.groupDetailsPanel.add((Widget)this.leaderboardsTable);
        this.leaderboardsDataProvider = new ListDataProvider();
        this.leaderboardsDataProvider.addDataDisplay((HasData)this.leaderboardsTable);
        this.leaderboardDetailsPanel = new FlowPanel();
        this.leaderboardDetailsPanel.setSize("100%", "100%");
        this.leaderboardDetailsPanel.setStyleName("groupOverviewPanel-leaderboardDetailsPanel");
        this.leaderboardDetailsPanel.setVisible(false);
        this.leaderboardDetailsPanel.getElement().setPropertyString("clear", "right");
        detailsPanel.add((Widget)this.leaderboardDetailsPanel);
        Label leaderboardDetailsLabel = new Label(String.valueOf(this.stringMessages.racesInLeaderboard()) + ":");
        leaderboardDetailsLabel.getElement().getStyle().setPadding(5.0, Style.Unit.PX);
        this.leaderboardDetailsPanel.add((Widget)leaderboardDetailsLabel);
        19 racesLocationColumn = new /* Unavailable Anonymous Inner Class!! */;
        LeaderboardConfigPanel.AnchorCell racesNameAnchorCell = new LeaderboardConfigPanel.AnchorCell();
        20 racesNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        21 racesStartDateColumn = new /* Unavailable Anonymous Inner Class!! */;
        this.racesTable = new CellTable(200, (CellTable.Resources)tableResources);
        this.racesTable.setWidth("100%");
        this.racesSelectionModel = new NoSelectionModel();
        this.racesTable.setSelectionModel((SelectionModel)this.racesSelectionModel);
        this.racesTable.addColumn((Column)racesLocationColumn, this.stringMessages.location());
        this.racesTable.addColumn((Column)racesNameColumn, this.stringMessages.name());
        this.racesTable.addColumn((Column)racesStartDateColumn, this.stringMessages.startDate());
        this.leaderboardDetailsPanel.add((Widget)this.racesTable);
        this.racesDataProvider = new ListDataProvider();
        this.racesDataProvider.addDataDisplay((HasData)this.racesTable);
        return this.collapsableDetailsPanel;
    }

    private void loadGroups() {
        long clientTimeWhenRequestWasSent = System.currentTimeMillis();
        this.sailingService.getLeaderboardGroups(true, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void onGroupSelectionChanged() {
        LeaderboardGroupDTO selectedGroup = (LeaderboardGroupDTO)this.groupsSelectionModel.getSelectedObject();
        StrippedLeaderboardDTO selectedLeaderboard = (StrippedLeaderboardDTO)this.leaderboardsSelectionModel.getSelectedObject();
        if (selectedGroup != null) {
            this.setGroupDetailsVisible(true);
            if (selectedLeaderboard != null) {
                this.setLeaderboardDetailsVisible(selectedGroup.leaderboards.contains(selectedLeaderboard));
            }
            this.fillGroupDetails(selectedGroup);
        } else {
            this.setGroupDetailsVisible(false);
            this.setLeaderboardDetailsVisible(false);
        }
    }

    private void setGroupDetailsVisible(boolean visible) {
        this.noGroupSelectedLabel.setVisible(!visible);
        this.groupDetailsPanel.setVisible(visible);
        if (visible) {
            this.collapsableDetailsPanel.setOpen(true);
        }
    }

    private void fillGroupDetails(LeaderboardGroupDTO group) {
        this.groupDescriptionHTML.setHTML(new SafeHtmlBuilder().appendEscapedLines(group.getDescription()).toSafeHtml());
        this.leaderboardsDataProvider.getList().clear();
        this.leaderboardsDataProvider.getList().addAll(group.leaderboards);
    }

    private void onLeaderboardSelectionChanged() {
        StrippedLeaderboardDTO selectedLeaderboard = (StrippedLeaderboardDTO)this.leaderboardsSelectionModel.getSelectedObject();
        this.setLeaderboardDetailsVisible(selectedLeaderboard != null);
        if (selectedLeaderboard != null) {
            this.fillLeaderboardDetails(selectedLeaderboard);
        }
    }

    private void setLeaderboardDetailsVisible(boolean visible) {
        this.leaderboardDetailsPanel.setVisible(visible);
    }

    private void fillLeaderboardDetails(StrippedLeaderboardDTO leaderboard) {
        this.racesDataProvider.getList().clear();
        this.racesDataProvider.getList().addAll(leaderboard.getRaceList());
    }

    private void onCheckBoxLiveChange() {
        if (this.onlyLiveCheckBox.getValue().booleanValue()) {
            String today = DateTimeFormat.getFormat((String)"dd.MM.yyyy").format(new Date()).toString();
            this.fromTextBox.setText(today);
            this.fromTextBox.setEnabled(false);
            this.untilTextBox.setText("");
            this.untilTextBox.setEnabled(false);
        } else {
            this.fromTextBox.setText("");
            this.fromTextBox.setEnabled(true);
            this.untilTextBox.setText("");
            this.untilTextBox.setEnabled(true);
        }
        this.onSearchCriteriaChange();
    }

    private void onSearchCriteriaChange() {
        String location = this.locationTextBox.getText();
        String name = this.nameTextBox.getText();
        boolean onlyLive = this.onlyLiveCheckBox.getValue();
        Date from = null;
        Date until = null;
        try {
            from = DateTimeFormat.getFormat((String)"dd.MM.yyyy").parse(this.fromTextBox.getText());
            until = DateTimeFormat.getFormat((String)"dd.MM.yyyy").parse(this.untilTextBox.getText());
            long time = until.getTime() + 86400000L;
            until = new Date(time);
        }
        catch (IllegalArgumentException time) {
            // empty catch block
        }
        this.groupsDataProvider.getList().clear();
        for (LeaderboardGroupDTO group : this.availableGroups) {
            if (!this.checkSearchCriteria(group, location, name, onlyLive, from, until)) continue;
            this.groupsDataProvider.getList().add(group);
        }
        ColumnSortEvent.fire((HasHandlers)this.groupsTable, (ColumnSortList)this.groupsTable.getColumnSortList());
    }

    private boolean checkSearchCriteria(LeaderboardGroupDTO forGroup, String location, String name, boolean onlyLive, Date from, Date until) {
        Date startDate;
        boolean result = true;
        if (result && location != null && location.length() > 0) {
            result = this.textContainsStringsToCheck(PlacemarkOrderDTO.placemarksOfAllOrderAsSeperatedString((Iterable)forGroup.getGroupPlaces(), (boolean)true), location.split("\\s"));
        }
        if (result && name != null && name.length() > 0) {
            result = this.textContainsStringsToCheck(forGroup.getName(), name.split("\\s"));
        }
        if (result && this.onlyLiveCheckBox.getValue().booleanValue()) {
            result = forGroup.hasLiveRace(this.timerForClientServerOffset.getLiveTimePointInMillis());
        } else if (result && (startDate = forGroup.getGroupStartDate()) != null) {
            if (from != null && until != null) {
                result = from.before(startDate) && until.after(startDate);
            } else if (from != null) {
                result = from.before(startDate);
            } else if (until != null) {
                result = until.after(startDate);
            }
        }
        return result;
    }

    private boolean textContainsStringsToCheck(String text, String[] stringsToCheck) {
        boolean contains = false;
        String[] stringArray = stringsToCheck;
        int n = stringsToCheck.length;
        int n2 = 0;
        while (n2 < n) {
            String stringToCheck = stringArray[n2];
            contains = text.toLowerCase().contains(stringToCheck.toLowerCase());
            if (!contains) break;
            ++n2;
        }
        return contains;
    }

    static /* synthetic */ void access$0(LeaderboardGroupOverviewPanel leaderboardGroupOverviewPanel) {
        leaderboardGroupOverviewPanel.onSearchCriteriaChange();
    }

    static /* synthetic */ void access$1(LeaderboardGroupOverviewPanel leaderboardGroupOverviewPanel) {
        leaderboardGroupOverviewPanel.onCheckBoxLiveChange();
    }

    static /* synthetic */ StringMessages access$2(LeaderboardGroupOverviewPanel leaderboardGroupOverviewPanel) {
        return leaderboardGroupOverviewPanel.stringMessages;
    }

    static /* synthetic */ boolean access$3(LeaderboardGroupOverviewPanel leaderboardGroupOverviewPanel) {
        return leaderboardGroupOverviewPanel.showRaceDetails;
    }

    static /* synthetic */ AnchorTemplates access$4() {
        return ANCHORTEMPLATE;
    }

    static /* synthetic */ void access$5(LeaderboardGroupOverviewPanel leaderboardGroupOverviewPanel) {
        leaderboardGroupOverviewPanel.onGroupSelectionChanged();
    }

    static /* synthetic */ SingleSelectionModel access$6(LeaderboardGroupOverviewPanel leaderboardGroupOverviewPanel) {
        return leaderboardGroupOverviewPanel.groupsSelectionModel;
    }

    static /* synthetic */ void access$7(LeaderboardGroupOverviewPanel leaderboardGroupOverviewPanel) {
        leaderboardGroupOverviewPanel.onLeaderboardSelectionChanged();
    }

    static /* synthetic */ SingleSelectionModel access$8(LeaderboardGroupOverviewPanel leaderboardGroupOverviewPanel) {
        return leaderboardGroupOverviewPanel.leaderboardsSelectionModel;
    }

    static /* synthetic */ Timer access$9(LeaderboardGroupOverviewPanel leaderboardGroupOverviewPanel) {
        return leaderboardGroupOverviewPanel.timerForClientServerOffset;
    }

    static /* synthetic */ void access$10(LeaderboardGroupOverviewPanel leaderboardGroupOverviewPanel, List list) {
        leaderboardGroupOverviewPanel.availableGroups = list;
    }

    static /* synthetic */ ListDataProvider access$11(LeaderboardGroupOverviewPanel leaderboardGroupOverviewPanel) {
        return leaderboardGroupOverviewPanel.groupsDataProvider;
    }

    static /* synthetic */ List access$12(LeaderboardGroupOverviewPanel leaderboardGroupOverviewPanel) {
        return leaderboardGroupOverviewPanel.availableGroups;
    }

    static /* synthetic */ ErrorReporter access$13(LeaderboardGroupOverviewPanel leaderboardGroupOverviewPanel) {
        return leaderboardGroupOverviewPanel.errorReporter;
    }
}

