/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.shared;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.home.communication.eventview.EventViewDTO;
import com.sap.sailing.gwt.home.communication.media.MediaDTO;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.SailingVideoDTO;
import com.sap.sailing.gwt.ui.shared.EventDTO;
import com.sap.sailing.gwt.ui.shared.SailingImageDTO;
import com.sap.sse.common.media.MediaTagConstants;
import com.sap.sse.gwt.client.media.AbstractMediaDTO;
import com.sap.sse.gwt.client.media.ImageDTO;
import com.sap.sse.gwt.client.media.VideoDTO;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.UserService;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.stream.Collectors;

/*
 * Exception performing whole class analysis ignored.
 */
public class ManageMediaModel {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    protected final SailingServiceWriteAsync sailingServiceWrite;
    protected final UserService userService;
    private final EventViewDTO eventViewDto;
    private final StringMessages i18n;
    private MediaDTO mediaDto;
    private Collection<SailingImageDTO> images = new LinkedHashSet();
    private Collection<VideoDTO> videos = new LinkedHashSet();

    public ManageMediaModel(SailingServiceWriteAsync sailingServiceWrite, UserService userService, EventViewDTO eventViewDto, StringMessages i18n) {
        this.sailingServiceWrite = sailingServiceWrite;
        this.userService = userService;
        this.eventViewDto = eventViewDto;
        this.i18n = i18n;
    }

    private void setEventDto(EventDTO eventDto) {
        this.setVideos((Collection)eventDto.getVideos());
        this.setImages((Collection)eventDto.getImages());
    }

    public Collection<SailingImageDTO> getImages() {
        return this.images;
    }

    public Collection<VideoDTO> getVideos() {
        return this.videos;
    }

    public void setMedia(MediaDTO mediaDto) {
        this.mediaDto = mediaDto;
        this.setVideos(mediaDto.getVideos());
        this.setImages(mediaDto.getPhotos());
    }

    private void setVideos(Collection<? extends VideoDTO> videos) {
        this.videos = new LinkedHashSet(videos.stream().sorted(Comparator.comparing(AbstractMediaDTO::getCreatedAtDate).reversed()).collect(Collectors.toList()));
    }

    private void setImages(Collection<SailingImageDTO> images) {
        this.images = new LinkedHashSet(images.stream().filter(video -> video.hasTag(MediaTagConstants.GALLERY.getName())).sorted(Comparator.comparing(AbstractMediaDTO::getCreatedAtDate).reversed()).collect(Collectors.toList()));
    }

    public void deleteImage(ImageDTO imageDto, Consumer<EventDTO> callback) {
        this.loadEventData(eventDto -> {
            Collection toRemove = eventDto.getImages().stream().filter(image -> image.getSourceRef().equals(imageDto.getSourceRef()) && image.getCreatedAtDate().equals(imageDto.getCreatedAtDate())).collect(Collectors.toList());
            toRemove.forEach(arg_0 -> ((EventDTO)eventDto).removeImage(arg_0));
            this.updateEventDto(eventDto, callback);
            this.mediaDto.getPhotos().stream().filter(photo -> photo.getSourceRef().equals(imageDto.getSourceRef()) && photo.getCreatedAtDate().equals(imageDto.getCreatedAtDate())).forEach(photo -> this.mediaDto.removePhoto(photo));
        });
    }

    public void deleteVideo(VideoDTO videoDto, Consumer<EventDTO> callback) {
        this.loadEventData(eventDto -> {
            Collection toRemove = eventDto.getVideos().stream().filter(video -> video.getSourceRef().equals(videoDto.getSourceRef()) && video.getCreatedAtDate().equals(videoDto.getCreatedAtDate())).collect(Collectors.toList());
            toRemove.forEach(arg_0 -> ((EventDTO)eventDto).removeVideo(arg_0));
            this.updateEventDto(eventDto, callback);
            this.mediaDto.getVideos().stream().filter(video -> video.getSourceRef().equals(videoDto.getSourceRef()) && video.getCreatedAtDate().equals(videoDto.getCreatedAtDate())).forEach(video -> this.mediaDto.removeVideo(video));
        });
    }

    public void addImages(List<SailingImageDTO> imageList, Consumer<EventDTO> callback) {
        this.loadEventData(eventDto -> {
            for (SailingImageDTO image : imageList) {
                eventDto.addImage((ImageDTO)image);
                this.mediaDto.addPhoto(new SailingImageDTO(null, (ImageDTO)image));
            }
            this.updateEventDto(eventDto, callback);
        });
    }

    public void addVideos(List<SailingVideoDTO> videoList, Consumer<EventDTO> callback) {
        this.loadEventData(eventDto -> {
            for (SailingVideoDTO video : videoList) {
                eventDto.getVideos().add(video);
                this.mediaDto.addVideo(video);
            }
            this.updateEventDto(eventDto, callback);
        });
    }

    public void addImagesAndVideos(List<ImageDTO> imageList, List<VideoDTO> videoList, Consumer<EventDTO> callback) {
        this.loadEventData(eventDto -> {
            for (ImageDTO image : imageList) {
                this.mediaDto.addPhoto(eventDto.addImage(image));
            }
            for (VideoDTO video : videoList) {
                this.mediaDto.addVideo(eventDto.addVideo(video));
            }
            this.updateEventDto(eventDto, callback);
        });
    }

    public void reloadMedia(Consumer<EventDTO> callback) {
        this.loadEventData(eventDto -> {
            this.setVideos((Collection)eventDto.getVideos());
            this.setImages((Collection)eventDto.getImages());
            callback.accept((EventDTO)eventDto);
        });
    }

    private void loadEventData(Consumer<EventDTO> callback) {
        this.sailingServiceWrite.getEventById(this.eventViewDto.getId(), true, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateEventDto(EventDTO eventDto, Consumer<EventDTO> callback) {
        if (this.hasPermissions()) {
            this.sailingServiceWrite.updateEvent(eventDto, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public boolean hasPermissions() {
        return ManageMediaModel.hasEventMediaPermissions((SecuredDTO)this.eventViewDto, (UserService)this.userService);
    }

    public boolean hasPermissions(EventDTO eventDto) {
        return ManageMediaModel.hasEventMediaPermissions((SecuredDTO)eventDto, (UserService)this.userService);
    }

    public String getEventName() {
        return this.eventViewDto.getName();
    }

    public static boolean hasEventMediaPermissions(SecuredDTO securedDTO, UserService userService) {
        boolean hasPermission = userService.hasPermission(securedDTO, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE) || userService.hasPermission(securedDTO, (HasPermissions.Action)SecuredDomainType.EventActions.UPLOAD_MEDIA);
        return hasPermission;
    }

    static /* synthetic */ StringMessages access$0(ManageMediaModel manageMediaModel) {
        return manageMediaModel.i18n;
    }

    static /* synthetic */ Logger access$1(ManageMediaModel manageMediaModel) {
        return manageMediaModel.logger;
    }

    static /* synthetic */ void access$2(ManageMediaModel manageMediaModel, EventDTO eventDTO) {
        manageMediaModel.setEventDto(eventDTO);
    }
}

