/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import java.util.HashMap;
import java.util.Map;

public class BulkScoreCorrectionDTO
implements IsSerializable {
    private String leaderboardName;
    private Map<String, Map<String, MaxPointsReason>> maxPointsUpdatesForRaceColumnByCompetitorIdAsString;
    private Map<String, Map<String, Double>> scoreUpdatesForRaceColumnByCompetitorIdAsString;

    public BulkScoreCorrectionDTO() {
    }

    public BulkScoreCorrectionDTO(String leaderboardName) {
        this.leaderboardName = leaderboardName;
        this.maxPointsUpdatesForRaceColumnByCompetitorIdAsString = new HashMap();
        this.scoreUpdatesForRaceColumnByCompetitorIdAsString = new HashMap();
    }

    public void addScoreUpdate(CompetitorDTO competitor, RaceColumnDTO raceColumn, double newScore) {
        HashMap<String, Double> map = (HashMap<String, Double>)this.scoreUpdatesForRaceColumnByCompetitorIdAsString.get(competitor.getIdAsString());
        if (map == null) {
            map = new HashMap<String, Double>();
            this.scoreUpdatesForRaceColumnByCompetitorIdAsString.put(competitor.getIdAsString(), map);
        }
        map.put(raceColumn.getName(), newScore);
    }

    public void addMaxPointsReasonUpdate(CompetitorDTO competitor, RaceColumnDTO raceColumn, MaxPointsReason newReason) {
        HashMap<String, MaxPointsReason> map = (HashMap<String, MaxPointsReason>)this.maxPointsUpdatesForRaceColumnByCompetitorIdAsString.get(competitor.getIdAsString());
        if (map == null) {
            map = new HashMap<String, MaxPointsReason>();
            this.maxPointsUpdatesForRaceColumnByCompetitorIdAsString.put(competitor.getIdAsString(), map);
        }
        map.put(raceColumn.getName(), newReason);
    }

    public Map<String, Map<String, MaxPointsReason>> getMaxPointsUpdatesForRaceColumnByCompetitorIdAsString() {
        return this.maxPointsUpdatesForRaceColumnByCompetitorIdAsString;
    }

    public Map<String, Map<String, Double>> getScoreUpdatesForRaceColumnByCompetitorIdAsString() {
        return this.scoreUpdatesForRaceColumnByCompetitorIdAsString;
    }

    public String getLeaderboardName() {
        return this.leaderboardName;
    }
}

