/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.polarmining;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.impl.WindSpeedSteppingWithMaxDistance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class WindSpeedSteppingConfiguratorPanel
extends HorizontalPanel {
    private List<TextBox> textBoxes = new ArrayList();
    private Button minusButton;
    private Button plusButton;

    public WindSpeedSteppingConfiguratorPanel(WindSpeedSteppingWithMaxDistance windStepping) {
        this.setupPlusAndMinusButtons();
        double[] levels = windStepping.getRawStepping();
        int i = 0;
        while (i < levels.length) {
            TextBox textBox = this.createSingleBox((int)Math.round(levels[i]));
            this.textBoxes.add(textBox);
            ++i;
        }
        this.updateTextBoxes();
    }

    private void setupPlusAndMinusButtons() {
        this.minusButton = new Button("-");
        this.minusButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.plusButton = new Button("+");
        this.plusButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateTextBoxes() {
        this.clear();
        for (Widget widget : this.textBoxes) {
            this.add(widget);
        }
        if (this.textBoxes.size() > 1) {
            this.add((Widget)this.minusButton);
        }
        this.add((Widget)this.plusButton);
    }

    public WindSpeedSteppingWithMaxDistance getStepping(double maxDistance) {
        ArrayList<Double> levelList = new ArrayList<Double>();
        for (TextBox box : this.textBoxes) {
            levelList.add(Double.valueOf(Integer.parseInt(box.getValue())));
        }
        Collections.sort(levelList);
        double[] levels = new double[levelList.size()];
        int i = 0;
        for (Double level : levelList) {
            levels[i++] = level;
        }
        return new WindSpeedSteppingWithMaxDistance(levels, maxDistance);
    }

    private TextBox createSingleBox(int level) {
        TextBox textBox = new TextBox();
        textBox.setMaxLength(2);
        textBox.setVisibleLength(2);
        textBox.setText(Integer.toString(level));
        return textBox;
    }

    static /* synthetic */ List access$0(WindSpeedSteppingConfiguratorPanel windSpeedSteppingConfiguratorPanel) {
        return windSpeedSteppingConfiguratorPanel.textBoxes;
    }

    static /* synthetic */ void access$1(WindSpeedSteppingConfiguratorPanel windSpeedSteppingConfiguratorPanel) {
        windSpeedSteppingConfiguratorPanel.updateTextBoxes();
    }

    static /* synthetic */ TextBox access$2(WindSpeedSteppingConfiguratorPanel windSpeedSteppingConfiguratorPanel, int n) {
        return windSpeedSteppingConfiguratorPanel.createSingleBox(n);
    }
}

