/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.leaderboard;

import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.domain.common.dto.LeaderboardDTO;
import com.sap.sailing.domain.common.dto.LeaderboardEntryDTO;
import com.sap.sailing.domain.common.dto.LeaderboardRowDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.gwt.settings.client.leaderboard.RaceColumnSelectionStrategies;
import com.sap.sailing.gwt.ui.client.RaceTimesInfoProvider;
import com.sap.sailing.gwt.ui.client.RaceTimesInfoProviderListener;
import com.sap.sailing.gwt.ui.leaderboard.AbstractRaceColumnSelection;
import com.sap.sailing.gwt.ui.leaderboard.LastNRacesColumnSelection;
import com.sap.sailing.gwt.ui.shared.RaceTimesInfoDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LastNRacesColumnSelection
extends AbstractRaceColumnSelection
implements RaceTimesInfoProviderListener {
    private final int numberOfLastRacesToShow;
    private final RaceTimesInfoProvider raceTimesInfoProvider;
    private LeaderboardDTO lastLeaderboard;
    private Map<RegattaAndRaceIdentifier, RaceTimesInfoDTO> raceTimesInfo;

    public LastNRacesColumnSelection(int numberOfLastRacesToShow, RaceTimesInfoProvider raceTimesInfoProvider) {
        this.numberOfLastRacesToShow = numberOfLastRacesToShow;
        this.raceTimesInfoProvider = raceTimesInfoProvider;
        raceTimesInfoProvider.addRaceTimesInfoProviderListener((RaceTimesInfoProviderListener)this);
        Date now = new Date();
        this.raceTimesInfosReceived(raceTimesInfoProvider.getRaceTimesInfos(), now.getTime(), now, now.getTime());
    }

    public void requestRaceColumnSelection(RaceColumnDTO column) {
    }

    public void requestClear() {
    }

    public void autoUpdateRaceColumnSelectionForUpdatedLeaderboard(LeaderboardDTO oldLeaderboard, LeaderboardDTO newLeaderboard) {
        this.lastLeaderboard = newLeaderboard;
        this.updateRaceTimesInfoProvider(newLeaderboard);
    }

    private void updateRaceTimesInfoProvider(LeaderboardDTO newLeaderboard) {
        HashSet oldRaceIdentifiers = new HashSet(this.raceTimesInfoProvider.getRaceIdentifiers());
        HashSet<RegattaAndRaceIdentifier> newRaceIdentifiers = new HashSet<RegattaAndRaceIdentifier>();
        for (RaceColumnDTO column : newLeaderboard.getRaceList()) {
            for (FleetDTO fleet : column.getFleets()) {
                RegattaAndRaceIdentifier raceIdentifier = column.getRaceIdentifier(fleet);
                if (raceIdentifier == null) continue;
                newRaceIdentifiers.add(raceIdentifier);
            }
        }
        for (RegattaAndRaceIdentifier old : oldRaceIdentifiers) {
            if (newRaceIdentifiers.contains(old)) continue;
            this.raceTimesInfoProvider.removeRaceIdentifier((RaceIdentifier)old);
        }
        for (RegattaAndRaceIdentifier neew : newRaceIdentifiers) {
            if (oldRaceIdentifiers.contains(neew)) continue;
            this.raceTimesInfoProvider.addRaceIdentifier(neew, false);
        }
    }

    public void raceTimesInfosReceived(Map<RegattaAndRaceIdentifier, RaceTimesInfoDTO> raceTimesInfo, long clientTimeWhenRequestWasSent, Date serverTimeDuringRequest, long clientTimeWhenResponseWasReceived) {
        this.raceTimesInfo = raceTimesInfo;
    }

    private Iterable<RaceColumnDTO> getRaceColumnsFromNewestToOldest(LeaderboardDTO leaderboard, Map<RegattaAndRaceIdentifier, RaceTimesInfoDTO> raceTimesInfo) {
        ArrayList<RaceColumnDTO> columns = new ArrayList<RaceColumnDTO>(leaderboard.getRaceList());
        Iterator i = columns.iterator();
        while (i.hasNext()) {
            RaceColumnDTO column = (RaceColumnDTO)i.next();
            if (this.getLatestStart(column) != null || this.hasScoreCorrections(leaderboard, column)) continue;
            i.remove();
        }
        1 comparator = new /* Unavailable Anonymous Inner Class!! */;
        Collections.sort(columns, comparator);
        return columns;
    }

    private boolean hasScoreCorrections(LeaderboardDTO leaderboard, RaceColumnDTO column) {
        for (Map.Entry e : leaderboard.rows.entrySet()) {
            LeaderboardEntryDTO entry = (LeaderboardEntryDTO)((LeaderboardRowDTO)e.getValue()).fieldsByRaceColumnName.get(column.getName());
            if (entry == null || !entry.hasScoreCorrection()) continue;
            return true;
        }
        return false;
    }

    private Date getLatestStart(RaceColumnDTO column) {
        Date latestStart = null;
        for (FleetDTO fleet : column.getFleets()) {
            RegattaAndRaceIdentifier raceIdentifier = column.getRaceIdentifier(fleet);
            RaceTimesInfoDTO times = (RaceTimesInfoDTO)this.raceTimesInfo.get(raceIdentifier);
            if (times == null || times.startOfRace == null || latestStart != null && !times.startOfRace.after(latestStart)) continue;
            latestStart = times.startOfRace;
        }
        return latestStart;
    }

    public Iterable<RaceColumnDTO> getSelectedRaceColumns() {
        List<RaceColumnDTO> result;
        LeaderboardDTO leaderboard = this.lastLeaderboard;
        if (leaderboard == null || this.raceTimesInfo == null) {
            result = Collections.emptyList();
        } else {
            Iterable raceColumnsFromNewestToOldest = this.getRaceColumnsFromNewestToOldest(leaderboard, this.raceTimesInfo);
            ArrayList<RaceColumnDTO> resultList = new ArrayList<RaceColumnDTO>(this.numberOfLastRacesToShow);
            Iterator i = raceColumnsFromNewestToOldest.iterator();
            while (i.hasNext() && resultList.size() < this.numberOfLastRacesToShow) {
                resultList.add((RaceColumnDTO)i.next());
            }
            result = resultList;
        }
        return result;
    }

    public RaceColumnSelectionStrategies getType() {
        return RaceColumnSelectionStrategies.LAST_N;
    }

    public Integer getNumberOfLastRaceColumnsToShow() {
        return this.numberOfLastRacesToShow;
    }
}

