/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.racemap;

import com.google.gwt.maps.client.MapWidget;
import com.google.gwt.maps.client.base.Point;
import com.google.gwt.maps.client.base.Size;
import com.google.gwt.maps.client.overlays.Marker;
import com.google.gwt.maps.client.overlays.MarkerImage;
import com.google.gwt.maps.client.overlays.MarkerOptions;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.resources.client.TextResource;
import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.gwt.ui.client.shared.racemap.ImageTransformer;
import com.sap.sailing.gwt.ui.client.shared.racemap.ManeuverColor;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapResources;
import com.sap.sse.common.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class RaceMapImageManager {
    private static final int MARKER_HEIGHT = 26;
    private static final int MARKER_WIDTH = 26;
    private final ImageTransformer combinedWindIconTransformer;
    private final ImageTransformer trueNorthIndicatorIconTransformer;
    private final ImageTransformer windSensorIconTransformer;
    private final Map<Util.Pair<ManeuverType, ManeuverColor>, Marker> maneuverIconsForTypeAndDirectionIndicatingColor;
    private final RaceMapResources resources;

    public RaceMapImageManager(RaceMapResources resources) {
        this.resources = resources;
        this.maneuverIconsForTypeAndDirectionIndicatingColor = new HashMap();
        this.trueNorthIndicatorIconTransformer = new ImageTransformer(resources.trueNorthIndicatorIcon());
        this.combinedWindIconTransformer = new ImageTransformer(resources.combinedWindIcon());
        this.windSensorIconTransformer = new ImageTransformer(resources.expeditionWindIcon());
    }

    public void loadMapIcons(MapWidget map) {
        if (map != null) {
            ArrayList<ManeuverType> maneuvers = new ArrayList<ManeuverType>();
            ManeuverType[] maneuverTypeArray = ManeuverType.values();
            int n = maneuverTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ManeuverType type = maneuverTypeArray[n2];
                maneuvers.add(type);
                ++n2;
            }
            for (ManeuverType maneuver : maneuvers) {
                Marker icon = this.createMarker(this.getResources().maneuverMarkerRed());
                this.getManeuverIconsForTypeAndDirectionIndicatingColor().put(new Util.Pair((Object)maneuver, (Object)ManeuverColor.RED), icon);
                icon = this.createMarker(this.getResources().maneuverMarkerGreen());
                this.getManeuverIconsForTypeAndDirectionIndicatingColor().put(new Util.Pair((Object)maneuver, (Object)ManeuverColor.GREEN), icon);
            }
        }
    }

    private Marker createMarker(ImageResource ressource) {
        MarkerOptions options = MarkerOptions.newInstance();
        MarkerImage markerImage = MarkerImage.newInstance((String)ressource.getSafeUri().asString());
        markerImage.setAnchor(Point.newInstance((double)13.0, (double)13.0));
        markerImage.setScaledSize(Size.newInstance((double)26.0, (double)26.0));
        options.setIcon(markerImage);
        Marker marker = Marker.newInstance((MarkerOptions)options);
        return marker;
    }

    ImageTransformer getTrueNorthIndicatorIconTransformer() {
        return this.trueNorthIndicatorIconTransformer;
    }

    ImageTransformer getCombinedWindIconTransformer() {
        return this.combinedWindIconTransformer;
    }

    ImageTransformer getWindSensorIconTransformer() {
        return this.windSensorIconTransformer;
    }

    TextResource getWindFinderLogo() {
        return this.getResources().getWindFinderLogo();
    }

    Map<Util.Pair<ManeuverType, ManeuverColor>, Marker> getManeuverIconsForTypeAndDirectionIndicatingColor() {
        return this.maneuverIconsForTypeAndDirectionIndicatingColor;
    }

    private RaceMapResources getResources() {
        return this.resources;
    }
}

