/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.text.client.DateTimeFormatRenderer;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.ui.adminconsole.AbstractRaceManagementPanel;
import com.sap.sailing.gwt.ui.adminconsole.places.AdminConsoleView;
import com.sap.sailing.gwt.ui.client.DurationAsHoursMinutesSecondsFormatter;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.common.Duration;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.UserService;

public class TrackedRacesManagementPanel
extends AbstractRaceManagementPanel {
    private final DateTimeFormatRenderer dateFormatter = new DateTimeFormatRenderer((com.google.gwt.i18n.shared.DateTimeFormat)DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_SHORT));
    private final DateTimeFormatRenderer timeFormatter = new DateTimeFormatRenderer((com.google.gwt.i18n.shared.DateTimeFormat)DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.TIME_LONG));
    private final DurationAsHoursMinutesSecondsFormatter durationFormatter = new DurationAsHoursMinutesSecondsFormatter();
    private final UserService userService;
    private final Grid raceDataGrid;
    private final Button setStartTimeButton;

    public TrackedRacesManagementPanel(AdminConsoleView.Presenter presenter, StringMessages stringMessages) {
        super(presenter, true, stringMessages);
        this.userService = presenter.getUserService();
        this.setStartTimeButton = new Button(stringMessages.setStartTimeReceived(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.selectedRaceContentPanel.add((Widget)this.setStartTimeButton);
        this.raceDataGrid = new Grid(7, 2);
        this.raceDataGrid.setText(0, 0, String.valueOf(stringMessages.startTime()) + ":");
        this.raceDataGrid.setText(1, 0, String.valueOf(stringMessages.endTime()) + ":");
        this.raceDataGrid.setText(2, 0, String.valueOf(stringMessages.finishingTime()) + ":");
        this.raceDataGrid.setText(3, 0, String.valueOf(stringMessages.duration()) + ":");
        this.raceDataGrid.setText(4, 0, String.valueOf(stringMessages.startOfTracking()) + ":");
        this.raceDataGrid.setText(5, 0, String.valueOf(stringMessages.endOfTracking()) + ":");
        this.raceDataGrid.setText(6, 0, String.valueOf(stringMessages.delayForLiveMode()) + " (ms):");
        this.selectedRaceContentPanel.add((Widget)this.raceDataGrid);
    }

    void refreshSelectedRaceData() {
        if (this.singleSelectedRace != null && this.selectedRaceDTO != null) {
            if (this.selectedRaceDTO.startOfRace != null) {
                this.raceDataGrid.setText(0, 1, String.valueOf(this.dateFormatter.render(this.selectedRaceDTO.startOfRace)) + " " + this.timeFormatter.render(this.selectedRaceDTO.startOfRace));
            } else {
                this.raceDataGrid.setText(0, 1, "");
            }
            if (this.selectedRaceDTO.endOfRace != null) {
                this.raceDataGrid.setText(1, 1, String.valueOf(this.dateFormatter.render(this.selectedRaceDTO.endOfRace)) + " " + this.timeFormatter.render(this.selectedRaceDTO.endOfRace));
            } else {
                this.raceDataGrid.setText(1, 1, "");
            }
            if (this.selectedRaceDTO.raceFinishedTime != null) {
                this.raceDataGrid.setText(2, 1, String.valueOf(this.dateFormatter.render(this.selectedRaceDTO.raceFinishedTime)) + " " + this.timeFormatter.render(this.selectedRaceDTO.raceFinishedTime));
            } else {
                this.raceDataGrid.setText(2, 1, "");
            }
            if (this.selectedRaceDTO.startOfRace != null && this.selectedRaceDTO.endOfRace != null) {
                MillisecondsDurationImpl duration = new MillisecondsDurationImpl(this.selectedRaceDTO.endOfRace.getTime() - this.selectedRaceDTO.startOfRace.getTime());
                this.raceDataGrid.setText(3, 1, this.durationFormatter.getHoursMinutesSeconds((Duration)duration));
            } else {
                this.raceDataGrid.setText(3, 1, "");
            }
            if (this.selectedRaceDTO.trackedRace != null && this.selectedRaceDTO.trackedRace.startOfTracking != null) {
                this.raceDataGrid.setText(4, 1, String.valueOf(this.dateFormatter.render(this.selectedRaceDTO.trackedRace.startOfTracking)) + " " + this.timeFormatter.render(this.selectedRaceDTO.trackedRace.startOfTracking));
            } else {
                this.raceDataGrid.setText(4, 1, "");
            }
            if (this.selectedRaceDTO.trackedRace != null && this.selectedRaceDTO.trackedRace.endOfTracking != null) {
                this.raceDataGrid.setText(5, 1, String.valueOf(this.dateFormatter.render(this.selectedRaceDTO.trackedRace.endOfTracking)) + " " + this.timeFormatter.render(this.selectedRaceDTO.trackedRace.endOfTracking));
            } else {
                this.raceDataGrid.setText(5, 1, "");
            }
            if (this.selectedRaceDTO.trackedRace != null) {
                this.raceDataGrid.setText(6, 1, "" + this.selectedRaceDTO.trackedRace.delayToLiveInMs);
            }
        }
        this.setStartTimeButton.setVisible(this.selectedRaceDTO != null && this.userService.hasPermission((SecuredDTO)this.selectedRaceDTO, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE));
    }

    static /* synthetic */ SailingServiceWriteAsync access$0(TrackedRacesManagementPanel trackedRacesManagementPanel) {
        return trackedRacesManagementPanel.sailingServiceWrite;
    }

    static /* synthetic */ ErrorReporter access$1(TrackedRacesManagementPanel trackedRacesManagementPanel) {
        return trackedRacesManagementPanel.errorReporter;
    }

    static /* synthetic */ AdminConsoleView.Presenter access$2(TrackedRacesManagementPanel trackedRacesManagementPanel) {
        return trackedRacesManagementPanel.presenter;
    }
}

