/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import com.sap.sailing.domain.common.impl.NauticalMileDistance;
import com.sap.sailing.domain.common.orc.ORCPerformanceCurveLegTypes;
import com.sap.sailing.domain.common.orc.impl.ORCPerformanceCurveLegImpl;
import com.sap.sailing.gwt.ui.adminconsole.AbstractORCPerformanceCurveLegDialog;
import com.sap.sailing.gwt.ui.adminconsole.CourseManagementWidget;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.WaypointDTO;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.dialog.DoubleBox;

public class ORCPerformanceCurveLegDialog
extends AbstractORCPerformanceCurveLegDialog<ORCPerformanceCurveLegImpl> {
    private final Button fetchTrackingBasedDistanceAndTwaButton;
    private final ListBox legTypeBox;
    private final DoubleBox distanceInNauticalMilesBox;
    private final DoubleBox twdBox;
    private final DoubleBox legDirectionBox;
    private final DoubleBox twaBox;
    private final StringMessages stringMessages;
    private final ListDataProvider<WaypointDTO> waypointList;
    private final WaypointDTO forLegEndingAt;
    private final CourseManagementWidget.LegGeometrySupplier legGeometrySupplier;

    public ORCPerformanceCurveLegDialog(StringMessages stringMessages, WaypointDTO forLegEndingAt, ListDataProvider<WaypointDTO> waypointList, ORCPerformanceCurveLegImpl orcLegParametersSoFar, CourseManagementWidget.LegGeometrySupplier legGeometrySupplier, DataEntryDialog.Validator<ORCPerformanceCurveLegImpl> validator, DataEntryDialog.DialogCallback<ORCPerformanceCurveLegImpl> callback) {
        super(stringMessages.orcPerformanceCurveLeg(), stringMessages.orcPerformanceCurveLegName(waypointList.getList().indexOf(forLegEndingAt), forLegEndingAt.getName()), stringMessages, validator, callback);
        this.stringMessages = stringMessages;
        this.forLegEndingAt = forLegEndingAt;
        this.waypointList = waypointList;
        this.legGeometrySupplier = legGeometrySupplier;
        this.fetchTrackingBasedDistanceAndTwaButton = new Button(stringMessages.orcPerformanceCurveFetchTrackedLegGeometry());
        this.fetchTrackingBasedDistanceAndTwaButton.addClickHandler(e -> this.fetchTrackingBasedDistanceAndTwa());
        this.legTypeBox = this.createLegTypeBox(orcLegParametersSoFar);
        this.distanceInNauticalMilesBox = this.createDoubleBox(5);
        this.twdBox = this.createDoubleBox(5);
        this.legDirectionBox = this.createDoubleBox(5);
        this.twaBox = this.createDoubleBox(5);
        this.twdBox.addValueChangeHandler(e -> this.updateTwaBoxFromTwdAndLegDirection(this.twdBox, this.legDirectionBox, this.twaBox));
        this.legDirectionBox.addValueChangeHandler(e -> this.updateTwaBoxFromTwdAndLegDirection(this.twdBox, this.legDirectionBox, this.twaBox));
        if (orcLegParametersSoFar != null) {
            this.distanceInNauticalMilesBox.setValue((Object)orcLegParametersSoFar.getLength().getNauticalMiles());
            if (orcLegParametersSoFar.getTwa() != null) {
                this.twaBox.setValue((Object)orcLegParametersSoFar.getTwa().getDegrees());
            }
        }
        this.legTypeBox.addChangeHandler(e -> this.updateFetchTrackingBasedDistanceAndTwaButtonEnabledState());
        this.updateFetchTrackingBasedDistanceAndTwaButtonEnabledState();
    }

    private void fetchTrackingBasedDistanceAndTwa() {
        int zeroBasedLegIndex = this.waypointList.getList().indexOf(this.forLegEndingAt) - 1;
        this.legGeometrySupplier.getLegGeometry(new int[]{zeroBasedLegIndex}, new ORCPerformanceCurveLegTypes[]{this.getSelectedLegType()}, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private ORCPerformanceCurveLegTypes getSelectedLegType() {
        String selectedValue = this.legTypeBox.getSelectedValue();
        return selectedValue == null || selectedValue.equals("null") ? null : ORCPerformanceCurveLegTypes.valueOf((String)selectedValue);
    }

    private void updateFetchTrackingBasedDistanceAndTwaButtonEnabledState() {
        boolean twaIsSelected = this.getSelectedLegType() == ORCPerformanceCurveLegTypes.TWA;
        this.twaBox.setEnabled(twaIsSelected);
    }

    protected Widget getAdditionalWidget() {
        Grid result = new Grid(6, 2);
        int row = 0;
        result.setWidget(row, 0, (Widget)new Label(this.stringMessages.legType()));
        result.setWidget(row++, 1, (Widget)this.legTypeBox);
        result.setWidget(row, 0, (Widget)new Label(this.stringMessages.distanceInNauticalMiles()));
        result.setWidget(row++, 1, (Widget)this.distanceInNauticalMilesBox);
        result.setWidget(row, 0, (Widget)new Label(this.stringMessages.twdInDegrees()));
        result.setWidget(row++, 1, (Widget)this.twdBox);
        result.setWidget(row, 0, (Widget)new Label(this.stringMessages.legDirectionInDegrees()));
        result.setWidget(row++, 1, (Widget)this.legDirectionBox);
        result.setWidget(row, 0, (Widget)new Label(this.stringMessages.legTwaInDegrees()));
        result.setWidget(row++, 1, (Widget)this.twaBox);
        result.setWidget(row, 0, (Widget)this.fetchTrackingBasedDistanceAndTwaButton);
        return result;
    }

    public FocusWidget getInitialFocusWidget() {
        return this.legTypeBox;
    }

    protected ORCPerformanceCurveLegImpl getResult() {
        ORCPerformanceCurveLegTypes selectedLegType = this.getSelectedLegType();
        ORCPerformanceCurveLegImpl result = selectedLegType == null ? null : (selectedLegType == ORCPerformanceCurveLegTypes.TWA ? new ORCPerformanceCurveLegImpl((Distance)(this.distanceInNauticalMilesBox.getValue() == null ? null : new NauticalMileDistance(((Double)this.distanceInNauticalMilesBox.getValue()).doubleValue())), (Bearing)(this.twaBox.getValue() == null ? null : new DegreeBearingImpl(((Double)this.twaBox.getValue()).doubleValue()))) : new ORCPerformanceCurveLegImpl((Distance)(this.distanceInNauticalMilesBox.getValue() == null ? null : new NauticalMileDistance(((Double)this.distanceInNauticalMilesBox.getValue()).doubleValue())), selectedLegType));
        return result;
    }

    static /* synthetic */ DoubleBox access$2(ORCPerformanceCurveLegDialog oRCPerformanceCurveLegDialog) {
        return oRCPerformanceCurveLegDialog.twaBox;
    }

    static /* synthetic */ DoubleBox access$3(ORCPerformanceCurveLegDialog oRCPerformanceCurveLegDialog) {
        return oRCPerformanceCurveLegDialog.distanceInNauticalMilesBox;
    }

    static /* synthetic */ void access$4(ORCPerformanceCurveLegDialog oRCPerformanceCurveLegDialog) {
        oRCPerformanceCurveLegDialog.validateAndUpdate();
    }
}

