/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SetSelectionModel;
import com.sap.sailing.gwt.ui.adminconsole.IPBlocklistTableWrapper;
import com.sap.sailing.gwt.ui.adminconsole.TableWrapper;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.EntityIdentityComparator;
import com.sap.sse.gwt.client.celltable.FlushableCellTable;
import com.sap.sse.gwt.client.celltable.RefreshableSelectionModel;
import com.sap.sse.gwt.client.panels.LabeledAbstractFilterablePanel;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.WildcardPermission;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.SelectedElementsCountingButton;
import com.sap.sse.security.ui.shared.IpToTimedLockDTO;
import java.util.ArrayList;
import java.util.Comparator;

abstract class IPBlocklistTableWrapper
extends TableWrapper<IpToTimedLockDTO, RefreshableSelectionModel<IpToTimedLockDTO>> {
    private final UserService userService;
    private final LabeledAbstractFilterablePanel<IpToTimedLockDTO> filterField;
    private final String errorMessageOnDataFailureString;

    protected abstract void fetchData(AsyncCallback<ArrayList<IpToTimedLockDTO>> var1);

    protected abstract void unlockIP(String var1, AsyncCallback<Void> var2);

    public IPBlocklistTableWrapper(SailingServiceWriteAsync sailingServiceWrite, UserService userService, String errorMessageOnDataFailureString, StringMessages stringMessages, ErrorReporter errorReporter) {
        super(sailingServiceWrite, stringMessages, errorReporter, true, true, (EntityIdentityComparator)new /* Unavailable Anonymous Inner Class!! */);
        this.userService = userService;
        this.errorMessageOnDataFailureString = errorMessageOnDataFailureString;
        this.filterField = this.composeFilterField();
        this.asWidget().ensureDebugId("wrappedTable");
        this.table.ensureDebugId("cellTable");
        this.configureDataColumns();
        this.setButtonsAndFilterOnMainPanel();
        this.loadDataAndPopulateTable();
    }

    private void setButtonsAndFilterOnMainPanel() {
        HorizontalPanel searchPanel = new HorizontalPanel();
        searchPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        searchPanel.setSpacing(5);
        Label label = new Label(String.valueOf(((StringMessages)this.getStringMessages()).filterIpAddresses()) + ": ");
        searchPanel.add((Widget)label);
        searchPanel.add((Widget)this.filterField.getTextBox());
        this.mainPanel.insert((Widget)searchPanel, 0);
        this.mainPanel.insert(this.composeButtonPanel(), 1);
        this.mainPanel.setSpacing(5);
    }

    private Widget composeButtonPanel() {
        HorizontalPanel buttonPanel = new HorizontalPanel();
        buttonPanel.setSpacing(5);
        Button refreshButton = new Button(((StringMessages)this.getStringMessages()).refresh(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        refreshButton.ensureDebugId("refreshButton");
        buttonPanel.add((Widget)refreshButton);
        if (this.hasUnlockPermission()) {
            SelectedElementsCountingButton unlockButton = this.composeUnlockButton();
            unlockButton.ensureDebugId("unlockButton");
            buttonPanel.add((Widget)unlockButton);
        }
        return buttonPanel;
    }

    private boolean hasUnlockPermission() {
        WildcardPermission unlockIpPermission = SecuredSecurityTypes.LOCKED_IP.getPermission(new HasPermissions.Action[]{HasPermissions.DefaultActions.DELETE});
        return this.userService.hasPermission(unlockIpPermission, this.userService.getServerInfo().getOwnership());
    }

    private SelectedElementsCountingButton<IpToTimedLockDTO> composeUnlockButton() {
        return new SelectedElementsCountingButton(((StringMessages)this.getStringMessages()).unlock(), (SetSelectionModel)this.getSelectionModel(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void loadDataAndPopulateTable() {
        4 dataInitializationCallback = new /* Unavailable Anonymous Inner Class!! */;
        this.fetchData((AsyncCallback)dataInitializationCallback);
    }

    private void configureDataColumns() {
        ColumnSortEvent.ListHandler columnListHandler = this.getColumnSortHandler();
        this.addColumn(record -> record.getIp(), ((StringMessages)this.getStringMessages()).ipAddress());
        Comparator expiryComparator = (o1, o2) -> o1.getTimedLock().getLockedUntil().compareTo((Object)o2.getTimedLock().getLockedUntil());
        this.addColumn(record -> record.getTimedLock().getLockedUntil().toString(), ((StringMessages)this.getStringMessages()).lockedUntil(), expiryComparator);
        this.table.addColumnSortHandler((ColumnSortEvent.Handler)columnListHandler);
    }

    private LabeledAbstractFilterablePanel<IpToTimedLockDTO> composeFilterField() {
        5 filterField = new /* Unavailable Anonymous Inner Class!! */;
        this.registerSelectionModelOnNewDataProvider(filterField.getAllListDataProvider());
        return filterField;
    }

    static /* synthetic */ void access$0(IPBlocklistTableWrapper iPBlocklistTableWrapper) {
        iPBlocklistTableWrapper.loadDataAndPopulateTable();
    }

    static /* synthetic */ ErrorReporter access$1(IPBlocklistTableWrapper iPBlocklistTableWrapper) {
        return iPBlocklistTableWrapper.errorReporter;
    }

    static /* synthetic */ String access$2(IPBlocklistTableWrapper iPBlocklistTableWrapper) {
        return iPBlocklistTableWrapper.errorMessageOnDataFailureString;
    }

    static /* synthetic */ LabeledAbstractFilterablePanel access$3(IPBlocklistTableWrapper iPBlocklistTableWrapper) {
        return iPBlocklistTableWrapper.filterField;
    }

    static /* synthetic */ FlushableCellTable access$4(IPBlocklistTableWrapper iPBlocklistTableWrapper) {
        return iPBlocklistTableWrapper.table;
    }
}

