/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.shared.partials.videoplayer;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.home.desktop.partials.mainmedia.MainMedia;
import com.sap.sailing.gwt.home.shared.partials.videoplayer.PlayButton;
import com.sap.sailing.gwt.home.shared.partials.videoplayer.VideoPlayerResources;
import com.sap.sailing.gwt.ui.client.media.PauseEvent;
import com.sap.sailing.gwt.ui.client.media.PlayEvent;
import com.sap.sailing.gwt.ui.client.media.VideoJSPlayer;
import com.sap.sse.gwt.client.media.TakedownNoticeService;
import com.sap.sse.gwt.client.media.VideoDTO;

public class VideoPlayer
extends Composite {
    private final VideoPlayerResources.LocalCss style = VideoPlayerResources.INSTANCE.css();
    private VideoJSPlayer videoJSPlayer;
    protected final FlowPanel panel;
    private final PlayButton playButton = new PlayButton();
    private boolean initialized = false;
    private final String eventName;

    public VideoPlayer(TakedownNoticeService takedownNoticeService, String eventName) {
        this(true, false, takedownNoticeService, eventName);
    }

    public VideoPlayer(MainMedia.MutualExclusionPlayHandler exclusionPlayer, TakedownNoticeService takedownNoticeService, String eventName) {
        this(takedownNoticeService, eventName);
        exclusionPlayer.register(this.videoJSPlayer);
    }

    public VideoPlayer(boolean fullHeightWidth, boolean autoplay, TakedownNoticeService takedownNoticeService, String eventName) {
        this.style.ensureInjected();
        this.eventName = eventName;
        this.panel = new FlowPanel();
        this.panel.addStyleName(this.style.videoPlayer());
        this.videoJSPlayer = new VideoJSPlayer(fullHeightWidth, autoplay, takedownNoticeService, "takedownRequestForEventGalleryVideo");
        this.videoJSPlayer.addPlayHandler((PlayEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
        this.videoJSPlayer.addPauseHandler((PauseEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
        this.panel.add((Widget)this.videoJSPlayer);
        this.playButton.addDomHandler((EventHandler)new /* Unavailable Anonymous Inner Class!! */, ClickEvent.getType());
        this.panel.add((Widget)this.playButton);
        this.initWidget((Widget)this.panel);
    }

    protected void initialize() {
    }

    protected void onPlay() {
        this.playButton.setVisible(false);
    }

    protected void onPaused() {
        this.playButton.setVisible(true);
    }

    public void setVideo(VideoDTO video) {
        if (!this.initialized) {
            this.initialize();
        }
        this.videoJSPlayer.setVideo(video.getMimeType(), video.getSourceRef(), this.eventName);
    }

    public boolean isFullscreen() {
        return this.videoJSPlayer.isFullscreen();
    }

    public boolean paused() {
        return this.videoJSPlayer.paused();
    }

    public void play() {
        this.videoJSPlayer.play();
    }

    static /* synthetic */ VideoJSPlayer access$0(VideoPlayer videoPlayer) {
        return videoPlayer.videoJSPlayer;
    }

    static /* synthetic */ PlayButton access$1(VideoPlayer videoPlayer) {
        return videoPlayer.playButton;
    }
}

