/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.mobile.places.user.profile.sailorprofiles.details.statistics;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.gwt.home.communication.event.SimpleCompetitorDTO;
import com.sap.sailing.gwt.home.communication.event.SimpleCompetitorWithIdDTO;
import com.sap.sailing.gwt.home.communication.user.profile.domain.SailorProfileNumericStatisticType;
import com.sap.sailing.gwt.home.communication.user.profile.domain.SailorProfileStatisticDTO;
import com.sap.sailing.gwt.home.desktop.places.user.profile.sailorprofiletab.details.events.CompetitorWithoutClubnameItemDescription;
import com.sap.sailing.gwt.home.desktop.places.user.profile.sailorprofiletab.details.statistic.SailorProfileNumericStatisticTypeFormatter;
import com.sap.sailing.gwt.home.mobile.places.user.profile.sailorprofiles.SailorProfileMobileResources;
import com.sap.sailing.gwt.home.mobile.places.user.profile.sailorprofiles.details.statistics.SailorProfileStatisticEntry;
import com.sap.sailing.gwt.settings.client.EntryPointWithSettingsLinkFactory;
import com.sap.sailing.gwt.settings.client.raceboard.RaceBoardPerspectiveOwnSettings;
import com.sap.sailing.gwt.settings.client.raceboard.RaceboardContextDefinition;
import com.sap.sailing.gwt.ui.client.FlagImageResolver;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapSettings;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.gwt.client.shared.perspective.PerspectiveCompositeSettings;
import java.util.HashMap;

public class SailorProfileStatisticEntry
extends Composite {
    private static SailorProfileOverviewEntryUiBinder uiBinder = (SailorProfileOverviewEntryUiBinder)GWT.create(SailorProfileOverviewEntryUiBinder.class);
    @UiField
    DivElement eventNameUi;
    @UiField
    DivElement timeLabelUi;
    @UiField
    DivElement timeUi;
    @UiField
    DivElement valueLabelUi;
    @UiField
    DivElement timeDivUi;
    @UiField
    DivElement valueUi;
    @UiField
    FlowPanel competitorUi;
    @UiField
    DivElement clubNameUi;
    @UiField
    Button showPointInTimeButtonUi;

    public SailorProfileStatisticEntry(SailorProfileNumericStatisticType type, SimpleCompetitorWithIdDTO competitor, SailorProfileStatisticDTO.SingleEntry entry, FlagImageResolver flagImageResolver, StringMessages stringMessages, String serializedDataMiningQuery) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        SailorProfileMobileResources.INSTANCE.css().ensureInjected();
        if (type.getAggregationType() != SailorProfileNumericStatisticType.StatisticType.AVERAGE) {
            this.timeUi.setInnerText(SailorProfileNumericStatisticTypeFormatter.format((TimePoint)entry.getRelatedTimePointOrNull()));
            this.timeLabelUi.setInnerText(String.valueOf(stringMessages.time()) + ": ");
            this.eventNameUi.setInnerText(String.valueOf(entry.getLeaderboardNameOrNull()) + " - " + entry.getRaceNameOrNull());
            this.showPointInTimeButtonUi.addClickHandler(e -> this.showInRaceboard(entry, type, competitor.getIdAsString()));
        } else {
            this.timeDivUi.removeFromParent();
            this.eventNameUi.removeFromParent();
            this.showPointInTimeButtonUi.removeFromParent();
        }
        this.valueLabelUi.setInnerText(String.valueOf(SailorProfileNumericStatisticTypeFormatter.getColumnHeadingName((SailorProfileNumericStatisticType)type, (StringMessages)stringMessages)) + ": ");
        this.valueUi.setInnerText(SailorProfileNumericStatisticTypeFormatter.format((SailorProfileNumericStatisticType)type, (Double)entry.getValue(), (StringMessages)stringMessages));
        this.competitorUi.add((Widget)new CompetitorWithoutClubnameItemDescription((SimpleCompetitorDTO)competitor, flagImageResolver));
        this.clubNameUi.setInnerText(competitor.getName());
    }

    private void showInRaceboard(SailorProfileStatisticDTO.SingleEntry entry, SailorProfileNumericStatisticType type, String competitorId) {
        RegattaAndRaceIdentifier raceIdentifier = entry.getRelatedRaceOrNull();
        RaceboardContextDefinition raceboardContext = new RaceboardContextDefinition(raceIdentifier.getRegattaName(), raceIdentifier.getRaceName(), entry.getLeaderboardNameOrNull(), entry.getLeaderboardGroupNameOrNull(), entry.getLeaderboardGroupIdOrNull(), entry.getEventIdOrNull(), type.getPlayerMode().name(), competitorId);
        RaceBoardPerspectiveOwnSettings perspectiveOwnSettings = new RaceBoardPerspectiveOwnSettings((Duration)new MillisecondsDurationImpl(entry.getRelatedTimePointOrNull().asMillis() - entry.getRelatedRaceStartTimePointOrNull().asMillis()));
        HashMap<String, RaceMapSettings> innerSettings = new HashMap<String, RaceMapSettings>();
        innerSettings.put("rm", RaceMapSettings.getDefaultWithShowMapControls((boolean)true));
        PerspectiveCompositeSettings settings = new PerspectiveCompositeSettings((Settings)perspectiveOwnSettings, innerSettings);
        String targetUrl = EntryPointWithSettingsLinkFactory.createRaceBoardLink((RaceboardContextDefinition)raceboardContext, (PerspectiveCompositeSettings)settings);
        Window.Location.assign((String)targetUrl);
    }
}

