/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.desktop.partials.standings;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.ImageElement;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.safehtml.shared.SafeUri;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.UIObject;
import com.sap.sailing.gwt.home.communication.event.SimpleCompetitorDTO;
import com.sap.sailing.gwt.home.communication.event.minileaderboard.MiniLeaderboardItemDTO;
import com.sap.sailing.gwt.home.desktop.partials.standings.StandingsListCompetitor;
import com.sap.sailing.gwt.ui.client.FlagImageResolver;
import com.sap.sailing.gwt.ui.client.StringMessages;

public class StandingsListCompetitor
extends UIObject {
    private static final StringMessages i18n = StringMessages.INSTANCE;
    private static MyUiBinder uiBinder = (MyUiBinder)GWT.create(MyUiBinder.class);
    @UiField
    SpanElement rankUi;
    @UiField
    SpanElement teamIdUi;
    @UiField
    SpanElement teamNameUi;
    @UiField
    ImageElement flagUi;
    @UiField
    DivElement pointsUi;

    public StandingsListCompetitor(MiniLeaderboardItemDTO item, boolean showRaceCounts, FlagImageResolver flagImageResolver) {
        this.setElement((Element)uiBinder.createAndBindUi((Object)this));
        SimpleCompetitorDTO competitor = item.getCompetitor();
        this.rankUi.setInnerText(Integer.toString(item.getRank()));
        this.teamIdUi.setInnerText(competitor.getShortInfo());
        this.teamNameUi.setInnerText(competitor.getName());
        String pointsString = i18n.pointsValue(item.getNetPoints().doubleValue());
        if (showRaceCounts) {
            pointsString = String.valueOf(pointsString) + " (" + i18n.racesCount(item.getRaceCount()) + ")";
        }
        this.pointsUi.setInnerText(pointsString);
        SafeUri imageUri = flagImageResolver.getFlagImageUri(competitor.getFlagImageURL(), competitor.getTwoLetterIsoCountryCode());
        this.flagUi.setSrc(imageUri.asString());
    }
}

